/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;

@FunctionalInterface
public interface DbmsReadOnlyChecker {
    public static DbmsReadOnlyChecker writable() {
        return databaseName -> false;
    }

    public static DbmsReadOnlyChecker readOnly() {
        return databaseName -> true;
    }

    public boolean isReadOnly(String var1);

    public static class Default
    implements DbmsReadOnlyChecker {
        private final Config config;

        public Default(Config config) {
            this.config = config;
        }

        @Override
        public boolean isReadOnly(String databaseName) {
            return Default.check(this.config, databaseName);
        }

        private static boolean check(Config config, String databaseName) {
            if ("system".equals(databaseName)) {
                return false;
            }
            return config.get(GraphDatabaseSettings.read_only_databases).contains(databaseName) || Default.defaultsToReadOnlyAndNotWritable(config, databaseName);
        }

        private static boolean defaultsToReadOnlyAndNotWritable(Config config, String databaseName) {
            return config.get(GraphDatabaseSettings.read_only_database_default) != false && !config.get(GraphDatabaseSettings.writable_databases).contains(databaseName);
        }
    }
}

