/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.internal.helpers.HostnamePort;

public class ConnectorPortRegister {
    private final ConcurrentHashMap<String, HostnamePort> connectorsInfo = new ConcurrentHashMap();

    public void register(String connectorKey, InetSocketAddress localAddress) {
        this.register(connectorKey, localAddress.getHostString(), localAddress.getPort());
    }

    public void register(String connectorKey, SocketAddress localAddress) {
        this.register(connectorKey, localAddress.getHostname(), localAddress.getPort());
    }

    public void deregister(String connectorKey) {
        this.connectorsInfo.remove(connectorKey);
    }

    public HostnamePort getLocalAddress(String connectorKey) {
        return this.connectorsInfo.get(connectorKey);
    }

    private void register(String connectorKey, String hostname, int port) {
        HostnamePort hostnamePort = new HostnamePort(hostname, port);
        this.connectorsInfo.put(connectorKey, hostnamePort);
    }
}

