/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.nio.file.Path;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.factory.Maps;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.DocumentedDefaultValue;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.configuration.connectors.ConnectorDefaults;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.logging.FormattedLogFormat;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogTimeZone;

@PublicApi
public class GraphDatabaseSettings
implements SettingsDeclaration {
    public static final int DEFAULT_BLOCK_SIZE = 128;
    public static final int DEFAULT_LABEL_BLOCK_SIZE = 64;
    public static final int MINIMAL_BLOCK_SIZE = 16;
    public static final long UNSPECIFIED_TIMEOUT = 0L;
    public static final String SYSTEM_DATABASE_NAME = "system";
    public static final String DEFAULT_DATABASE_NAME = "neo4j";
    public static final String DEFAULT_DATA_DIR_NAME = "data";
    public static final String DEFAULT_DATABASES_ROOT_DIR_NAME = "databases";
    public static final String DEFAULT_TX_LOGS_ROOT_DIR_NAME = "transactions";
    public static final String DEFAULT_SCRIPT_FOLDER = "scripts";
    public static final String DEFAULT_DUMPS_DIR_NAME = "dumps";
    public static final String DEFAULT_LICENSES_DIR_NAME = "licenses";
    public static final int DEFAULT_ROUTING_CONNECTOR_PORT = 7688;
    @Description(value="Root relative to which directory settings are resolved.")
    @DocumentedDefaultValue(value="Defaults to current working directory")
    public static final Setting<Path> neo4j_home = SettingImpl.newBuilder("dbms.directories.neo4j_home", SettingValueParsers.PATH, Path.of("", new String[0]).toAbsolutePath()).addConstraint(SettingConstraints.ABSOLUTE_PATH).immutable().build();
    @Description(value="Name of the default database (aliases are not supported).")
    public static final Setting<String> default_database = SettingImpl.newBuilder("dbms.default_database", SettingValueParsers.DATABASENAME, "neo4j").build();
    @Description(value="Path of the data directory. You must not configure more than one Neo4j installation to use the same data directory.")
    public static final Setting<Path> data_directory = SettingImpl.newBuilder("dbms.directories.data", SettingValueParsers.PATH, Path.of("data", new String[0])).setDependency(neo4j_home).immutable().build();
    @Description(value="Root location where Neo4j will store transaction logs for configured databases.")
    public static final Setting<Path> transaction_logs_root_path = SettingImpl.newBuilder("dbms.directories.transaction.logs.root", SettingValueParsers.PATH, Path.of("transactions", new String[0])).setDependency(data_directory).immutable().build();
    @Description(value="Root location where Neo4j will store scripts for configured databases.")
    public static final Setting<Path> script_root_path = SettingImpl.newBuilder("dbms.directories.script.root", SettingValueParsers.PATH, Path.of("scripts", new String[0])).setDependency(data_directory).immutable().build();
    @Description(value="Root location where Neo4j will store database dumps optionally produced when dropping said databases.")
    public static final Setting<Path> database_dumps_root_path = SettingImpl.newBuilder("dbms.directories.dumps.root", SettingValueParsers.PATH, Path.of("dumps", new String[0])).setDependency(data_directory).immutable().build();
    @Description(value="Only allow read operations from this Neo4j instance. This mode still requires write access to the directory for lock purposes. Replaced by: dbms.databases.default_to_read_only, dbms.databases.read_only, dbms.databases.writable.")
    @Deprecated(since="4.3.0", forRemoval=true)
    public static final Setting<Boolean> read_only = SettingImpl.newBuilder("dbms.read_only", SettingValueParsers.BOOL, false).build();
    @Description(value="Whether or not any database on this instance are read_only by default. If false, individual databases may be marked as read_only using dbms.database.read_only. If true, individual databases may be marked as writable using dbms.databases.writable.")
    public static final Setting<Boolean> read_only_database_default = SettingImpl.newBuilder("dbms.databases.default_to_read_only", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="List of databases for which to prevent write queries. Databases not included in this list maybe read_only anyway depending upon the value of dbms.databases.default_to_read_only.")
    public static final Setting<Set<String>> read_only_databases = SettingImpl.newBuilder("dbms.databases.read_only", SettingValueParsers.setOf(SettingValueParsers.DATABASENAME), Collections.emptySet()).addConstraint(SettingConstraints.shouldNotContain("system", "read only databases collection")).dynamic().build();
    @Description(value="List of databases for which to allow write queries. Databases not included in this list will allow write queries anyway, unless dbms.databases.default_to_read_only is set to true.")
    public static final Setting<Set<String>> writable_databases = SettingImpl.newBuilder("dbms.databases.writable", SettingValueParsers.setOf(SettingValueParsers.DATABASENAME), Collections.emptySet()).dynamic().build();
    @Description(value="A strict configuration validation will prevent the database from starting up if unknown configuration options are specified in the neo4j settings namespace (such as dbms., cypher., etc).")
    public static final Setting<Boolean> strict_config_validation = SettingImpl.newBuilder("dbms.config.strict_validation", SettingValueParsers.BOOL, false).build();
    @Description(value="Whether to allow a store upgrade in case the current version of the database starts against an older version of the store.")
    public static final Setting<Boolean> allow_upgrade = SettingImpl.newBuilder("dbms.allow_upgrade", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Max number of processors used when upgrading the store. Defaults to the number of processors available to the JVM. There is a certain amount of minimum threads needed so for that reason there is no lower bound for this value. For optimal performance this value shouldn't be greater than the number of available processors.")
    public static final Setting<Integer> upgrade_processors = SettingImpl.newBuilder("dbms.upgrade_max_processors", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).dynamic().build();
    @Description(value="Database record format. Valid values are blank(no value, default), `standard`, `aligned`, or `high_limit`. Specifying a value will force new databases to that format and existing databases to migrate if `dbms.allow_upgrade=true` is specified. The `aligned` format is essentially the `standard` format with some minimal padding at the end of pages such that a single record will never cross a page boundary. The `high_limit` format is available for Enterprise Edition only. It is required if you have a graph that is larger than 34 billion nodes, 34 billion relationships, or 68 billion properties. A change of the record format is irreversible. Certain operations may suffer from a performance penalty of up to 10%, which is why this format is not switched on by default. However, if you want to change the configured record format value, you must also set `dbms.allow_upgrade=true`, because the setting implies a one-way store format migration.")
    @DocumentedDefaultValue(value="Blank (no value). New databases will use `aligned`. Existing databases will stay on their current format")
    public static final Setting<String> record_format = SettingImpl.newBuilder("dbms.record_format", SettingValueParsers.STRING, "").build();
    @Description(value="Whether to allow a system graph upgrade to happen automatically in single instance mode (dbms.mode=SINGLE). Default is true. In clustering environments no automatic upgrade will happen (dbms.mode=CORE or dbms.mode=READ_REPLICA). If set to false, or when in a clustering environment, it is necessary to call the procedure `dbms.upgrade()` to complete the upgrade.")
    public static final Setting<Boolean> allow_single_automatic_upgrade = SettingImpl.newBuilder("dbms.allow_single_automatic_upgrade", SettingValueParsers.BOOL, true).dynamic().build();
    @Description(value="Configure the operating mode of the database -- 'SINGLE' for stand-alone operation, 'CORE' for operating as a core member of a Causal Cluster, or 'READ_REPLICA' for operating as a read replica member of a Causal Cluster. Only SINGLE mode is allowed in Community")
    public static final Setting<Mode> mode = SettingImpl.newBuilder("dbms.mode", SettingValueParsers.ofEnum(Mode.class), Mode.SINGLE).build();
    @Description(value="Enable discovery service and a catchup server to be started on an Enterprise Standalone Instance 'dbms.mode=SINGLE', and with that allow for Read Replicas to connect and pull transaction from it. When 'dbms.mode' is clustered (CORE, READ_REPLICA) this setting is not recognized.")
    public static final Setting<Boolean> enable_clustering_in_standalone = SettingImpl.newBuilder("dbms.clustering.enable", SettingValueParsers.BOOL, false).build();
    @Description(value="Routing strategy for neo4j:// protocol connections.\nDefault is `CLIENT`, using client-side routing, with server-side routing as a fallback (if enabled).\nWhen set to `SERVER`, client-side routing is short-circuited, and requests will rely on server-side routing (which must be enabled for proper operation, i.e. `dbms.routing.enabled=true`).\nCan be overridden by `dbms.routing.client_side.enforce_for_domains`.")
    public static final Setting<RoutingMode> routing_default_router = SettingImpl.newBuilder("dbms.routing.default_router", SettingValueParsers.ofEnum(RoutingMode.class), RoutingMode.CLIENT).build();
    @Description(value="Always use client side routing (regardless of the default router) for neo4j:// protocol connections to these domains. A comma separated list of domains. Wildcards (*) are supported.")
    public static final Setting<Set<String>> client_side_router_enforce_for_domains = SettingImpl.newBuilder("dbms.routing.client_side.enforce_for_domains", SettingValueParsers.setOf(SettingValueParsers.STRING), Set.of()).dynamic().build();
    @Description(value="Set this to specify the default parser (language version).")
    public static final Setting<CypherParserVersion> cypher_parser_version = SettingImpl.newBuilder("cypher.default_language_version", SettingValueParsers.ofEnum(CypherParserVersion.class), CypherParserVersion.DEFAULT).build();
    @Description(value="Set this to specify the default planner for the default language version.")
    public static final Setting<CypherPlanner> cypher_planner = SettingImpl.newBuilder("cypher.planner", SettingValueParsers.ofEnum(CypherPlanner.class), CypherPlanner.DEFAULT).build();
    @Description(value="Set this to specify the behavior when Cypher planner or runtime hints cannot be fulfilled. If true, then non-conformance will result in an error, otherwise only a warning is generated.")
    public static final Setting<Boolean> cypher_hints_error = SettingImpl.newBuilder("cypher.hints_error", SettingValueParsers.BOOL, false).build();
    @Description(value="This setting is associated with performance optimization. Set this to `true` in situations where it is preferable to have any queries using the 'shortestPath' function terminate as soon as possible with no answer, rather than potentially running for a long time attempting to find an answer (even if there is no path to be found). For most queries, the 'shortestPath' algorithm will return the correct answer very quickly. However there are some cases where it is possible that the fast bidirectional breadth-first search algorithm will find no results even if they exist. This can happen when the predicates in the `WHERE` clause applied to 'shortestPath' cannot be applied to each step of the traversal, and can only be applied to the entire path. When the query planner detects these special cases, it will plan to perform an exhaustive depth-first search if the fast algorithm finds no paths. However, the exhaustive search may be orders of magnitude slower than the fast algorithm. If it is critical that queries terminate as soon as possible, it is recommended that this option be set to `true`, which means that Neo4j will never consider using the exhaustive search for shortestPath queries. However, please note that if no paths are found, an error will be thrown at run time, which will need to be handled by the application.")
    public static final Setting<Boolean> forbid_exhaustive_shortestpath = SettingImpl.newBuilder("cypher.forbid_exhaustive_shortestpath", SettingValueParsers.BOOL, false).build();
    @Description(value="This setting is associated with performance optimization. The shortest path algorithm does not work when the start and end nodes are the same. With this setting set to `false` no path will be returned when that happens. The default value of `true` will instead throw an exception. This can happen if you perform a shortestPath search after a cartesian product that might have the same start and end nodes for some of the rows passed to shortestPath. If it is preferable to not experience this exception, and acceptable for results to be missing for those rows, then set this to `false`. If you cannot accept missing results, and really want the shortestPath between two common nodes, then re-write the query using a standard Cypher variable length pattern expression followed by ordering by path length and limiting to one result.")
    public static final Setting<Boolean> forbid_shortestpath_common_nodes = SettingImpl.newBuilder("cypher.forbid_shortestpath_common_nodes", SettingValueParsers.BOOL, true).build();
    @Description(value="Set this to change the behavior for Cypher create relationship when the start or end node is missing. By default this fails the query and stops execution, but by setting this flag the create operation is simply not performed and execution continues.")
    public static final Setting<Boolean> cypher_lenient_create_relationship = SettingImpl.newBuilder("cypher.lenient_create_relationship", SettingValueParsers.BOOL, false).build();
    @Description(value="The number of cached Cypher query execution plans per database. The max number of query plans that can be kept in cache is the `number of databases` * `dbms.query_cache_size`. With 10 databases and `dbms.query_cache_size`=1000, the caches can keep 10000 plans in total on the instance, assuming that each DB receives queries that fill up its cache. ")
    public static final Setting<Integer> query_cache_size = SettingImpl.newBuilder("dbms.query_cache_size", SettingValueParsers.INT, 1000).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="The threshold for statistics above which a plan is considered stale.\n\nIf any of the underlying statistics used to create the plan have changed more than this value, the plan will be considered stale and will be replanned. Change is calculated as `abs(a-b)/max(a,b)`.\n\nThis means that a value of `0.75` requires the database to quadruple in size before query replanning. A value of `0` means that the query will be replanned as soon as there is any change in statistics and the replan interval has elapsed.\n\nThis interval is defined by `cypher.min_replan_interval` and defaults to 10s. After this interval, the divergence threshold will slowly start to decline, reaching 10% after about 7h. This will ensure that long running databases will still get query replanning on even modest changes, while not replanning frequently unless the changes are very large.")
    public static final Setting<Double> query_statistics_divergence_threshold = SettingImpl.newBuilder("cypher.statistics_divergence_threshold", SettingValueParsers.DOUBLE, 0.75).addConstraint(SettingConstraints.range(0.0, 1.0)).build();
    @Description(value="The minimum time between possible cypher query replanning events. After this time, the graph statistics will be evaluated, and if they have changed by more than the value set by cypher.statistics_divergence_threshold, the query will be replanned. If the statistics have not changed sufficiently, the same interval will need to pass before the statistics will be evaluated again. Each time they are evaluated, the divergence threshold will be reduced slightly until it reaches 10% after 7h, so that even moderately changing databases will see query replanning after a sufficiently long time interval.")
    public static final Setting<Duration> cypher_min_replan_interval = SettingImpl.newBuilder("cypher.min_replan_interval", SettingValueParsers.DURATION, Duration.ofSeconds(10L)).build();
    @Description(value="Determines if Cypher will allow using file URLs when loading data using `LOAD CSV`. Setting this value to `false` will cause Neo4j to fail `LOAD CSV` clauses that load data from the file system.")
    public static final Setting<Boolean> allow_file_urls = SettingImpl.newBuilder("dbms.security.allow_csv_import_from_file_urls", SettingValueParsers.BOOL, true).build();
    @Description(value="Sets the root directory for file URLs used with the Cypher `LOAD CSV` clause. This should be set to a directory relative to the Neo4j installation path, restricting access to only those files within that directory and its subdirectories. For example the value \"import\" will only enable access to files within the 'import' folder. Removing this setting will disable the security feature, allowing all files in the local system to be imported. Setting this to an empty field will allow access to all files within the Neo4j installation folder.")
    public static final Setting<Path> load_csv_file_url_root = SettingImpl.newBuilder("dbms.directories.import", SettingValueParsers.PATH, null).immutable().setDependency(neo4j_home).build();
    @Description(value="Selects whether to conform to the standard https://tools.ietf.org/html/rfc4180 for interpreting escaped quotation characters in CSV files loaded using `LOAD CSV`. Setting this to `false` will use the standard, interpreting repeated quotes '\"\"' as a single in-lined quote, while `true` will use the legacy convention originally supported in Neo4j 3.0 and 3.1, allowing a backslash to include quotes in-lined in fields.")
    public static final Setting<Boolean> csv_legacy_quote_escaping = SettingImpl.newBuilder("dbms.import.csv.legacy_quote_escaping", SettingValueParsers.BOOL, true).build();
    @Description(value="The size of the internal buffer in bytes used by `LOAD CSV`. If the csv file contains huge fields this value may have to be increased.")
    public static final Setting<Long> csv_buffer_size = SettingImpl.newBuilder("dbms.import.csv.buffer_size", SettingValueParsers.LONG, ByteUnit.mebiBytes((long)2L)).addConstraint(SettingConstraints.min(1L)).build();
    @Description(value="Enables or disables tracking of how much time a query spends actively executing on the CPU. Calling `dbms.listQueries` will display the time. This can also be logged in the query log by using `dbms.logs.query.time_logging_enabled`.")
    public static final Setting<Boolean> track_query_cpu_time = SettingImpl.newBuilder("dbms.track_query_cpu_time", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Enables or disables tracking of how many bytes are allocated by the execution of a query. If enabled, calling `dbms.listQueries` will display the allocated bytes. This can also be logged in the query log by using `dbms.logs.query.allocation_logging_enabled`.")
    public static final Setting<Boolean> track_query_allocation = SettingImpl.newBuilder("dbms.track_query_allocation", SettingValueParsers.BOOL, true).dynamic().build();
    @Description(value="The maximum number of concurrently running transactions. If set to 0, limit is disabled.")
    public static final Setting<Integer> max_concurrent_transactions = SettingImpl.newBuilder("dbms.transaction.concurrent.maximum", SettingValueParsers.INT, 1000).dynamic().build();
    @Description(value="Transaction creation tracing level.")
    public static final Setting<TransactionTracingLevel> transaction_tracing_level = SettingImpl.newBuilder("dbms.transaction.tracing.level", SettingValueParsers.ofEnum(TransactionTracingLevel.class), TransactionTracingLevel.DISABLED).dynamic().build();
    @Description(value="Transaction sampling percentage.")
    public static final Setting<Integer> transaction_sampling_percentage = SettingImpl.newBuilder("dbms.transaction.sampling.percentage", SettingValueParsers.INT, 5).dynamic().addConstraint(SettingConstraints.range(1, 100)).build();
    @Description(value="The maximum time interval of a transaction within which it should be completed.")
    public static final Setting<Duration> transaction_timeout = SettingImpl.newBuilder("dbms.transaction.timeout", SettingValueParsers.DURATION, Duration.ZERO).dynamic().build();
    @Description(value="The maximum time interval within which lock should be acquired. Zero (default) means timeout is disabled.")
    public static final Setting<Duration> lock_acquisition_timeout = SettingImpl.newBuilder("dbms.lock.acquisition.timeout", SettingValueParsers.DURATION, Duration.ZERO).dynamic().build();
    @Description(value="Configures the time interval between transaction monitor checks. Determines how often monitor thread will check transaction for timeout.")
    public static final Setting<Duration> transaction_monitor_check_interval = SettingImpl.newBuilder("dbms.transaction.monitor.check.interval", SettingValueParsers.DURATION, Duration.ofSeconds(2L)).build();
    @Description(value="The maximum amount of time to wait for running transactions to complete before allowing initiated database shutdown to continue")
    public static final Setting<Duration> shutdown_transaction_end_timeout = SettingImpl.newBuilder("dbms.shutdown_transaction_end_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(10L)).build();
    @Description(value="Location of the database plugin directory. Compiled Java JAR files that contain database procedures will be loaded if they are placed in this directory.")
    public static final Setting<Path> plugin_dir = SettingImpl.newBuilder("dbms.directories.plugins", SettingValueParsers.PATH, Path.of("plugins", new String[0])).setDependency(neo4j_home).immutable().build();
    @Description(value="Default log format. Will apply to all logs unless overridden.")
    public static final Setting<FormattedLogFormat> default_log_format = SettingImpl.newBuilder("dbms.logs.default_format", SettingValueParsers.ofEnum(FormattedLogFormat.class), FormattedLogFormat.PLAIN).immutable().build();
    @Description(value="Log format to use for user log.")
    public static final Setting<FormattedLogFormat> store_user_log_format = SettingImpl.newBuilder("dbms.logs.user.format", SettingValueParsers.ofEnum(FormattedLogFormat.class), null).setDependency(default_log_format).build();
    @Description(value="Threshold for rotation of the user log (_neo4j.log_). If set to 0, log rotation is disabled. Note that if dbms.logs.user.stdout_enabled is enabled this setting will be ignored.")
    public static final Setting<Long> store_user_log_rotation_threshold = SettingImpl.newBuilder("dbms.logs.user.rotation.size", SettingValueParsers.BYTES, 0L).addConstraint(SettingConstraints.range(0L, Long.MAX_VALUE)).build();
    @Description(value="Threshold for rotation of the debug log.")
    public static final Setting<Long> store_internal_log_rotation_threshold = SettingImpl.newBuilder("dbms.logs.debug.rotation.size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)20L)).addConstraint(SettingConstraints.range(0L, Long.MAX_VALUE)).build();
    @Description(value="Debug log level threshold.")
    public static final Setting<Level> store_internal_log_level = SettingImpl.newBuilder("dbms.logs.debug.level", SettingValueParsers.ofEnum(Level.class), Level.INFO).dynamic().build();
    @Description(value="Database timezone. Among other things, this setting influences which timezone the logs and monitoring procedures use.")
    public static final Setting<LogTimeZone> db_timezone = SettingImpl.newBuilder("dbms.db.timezone", SettingValueParsers.ofEnum(LogTimeZone.class), LogTimeZone.UTC).build();
    @Description(value="Database timezone for temporal functions. All Time and DateTime values that are created without an explicit timezone will use this configured default timezone.")
    public static final Setting<ZoneId> db_temporal_timezone = SettingImpl.newBuilder("db.temporal.timezone", SettingValueParsers.TIMEZONE, ZoneOffset.UTC).build();
    @Deprecated(since="4.2.0", forRemoval=true)
    @Description(value="Minimum time interval after last rotation of the user log (_neo4j.log_) before it may be rotated again. Note that if dbms.logs.user.stdout_enabled is enabled this setting will be ignored.")
    public static final Setting<Duration> store_user_log_rotation_delay = SettingImpl.newBuilder("dbms.logs.user.rotation.delay", SettingValueParsers.DURATION, Duration.ofSeconds(300L)).build();
    @Deprecated(since="4.2.0", forRemoval=true)
    @Description(value="Minimum time interval after last rotation of the debug log before it may be rotated again.")
    public static final Setting<Duration> store_internal_log_rotation_delay = SettingImpl.newBuilder("dbms.logs.debug.rotation.delay", SettingValueParsers.DURATION, Duration.ofSeconds(300L)).build();
    @Description(value="Maximum number of history files for the user log (_neo4j.log_). Note that if dbms.logs.user.stdout_enabled is enabled this setting will be ignored.")
    public static final Setting<Integer> store_user_log_max_archives = SettingImpl.newBuilder("dbms.logs.user.rotation.keep_number", SettingValueParsers.INT, 7).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="Maximum number of history files for the debug log.")
    public static final Setting<Integer> store_internal_log_max_archives = SettingImpl.newBuilder("dbms.logs.debug.rotation.keep_number", SettingValueParsers.INT, 7).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="Configures the general policy for when check-points should occur. The default policy is the 'periodic' check-point policy, as specified by the 'dbms.checkpoint.interval.tx' and 'dbms.checkpoint.interval.time' settings. The Neo4j Enterprise Edition provides two alternative policies: The first is the 'continuous' check-point policy, which will ignore those settings and run the check-point process all the time. The second is the 'volumetric' check-point policy, which makes a best-effort at check-pointing often enough so that the database doesn't get too far behind on deleting old transaction logs in accordance with the 'dbms.tx_log.rotation.retention_policy' setting.")
    public static final Setting<CheckpointPolicy> check_point_policy = SettingImpl.newBuilder("dbms.checkpoint", SettingValueParsers.ofEnum(CheckpointPolicy.class), CheckpointPolicy.PERIODIC).build();
    @Description(value="Configures the transaction interval between check-points. The database will not check-point more often  than this (unless check pointing is triggered by a different event), but might check-point less often than this interval, if performing a check-point takes longer time than the configured interval. A check-point is a point in the transaction logs, which recovery would start from. Longer check-point intervals typically mean that recovery will take longer to complete in case of a crash. On the other hand, a longer check-point interval can also reduce the I/O load that the database places on the system, as each check-point implies a flushing and forcing of all the store files.  The default is '100000' for a check-point every 100000 transactions.")
    public static final Setting<Integer> check_point_interval_tx = SettingImpl.newBuilder("dbms.checkpoint.interval.tx", SettingValueParsers.INT, 100000).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="Configures the time interval between check-points. The database will not check-point more often than this (unless check pointing is triggered by a different event), but might check-point less often than this interval, if performing a check-point takes longer time than the configured interval. A check-point is a point in the transaction logs, which recovery would start from. Longer check-point intervals typically mean that recovery will take longer to complete in case of a crash. On the other hand, a longer check-point interval can also reduce the I/O load that the database places on the system, as each check-point implies a flushing and forcing of all the store files.")
    public static final Setting<Duration> check_point_interval_time = SettingImpl.newBuilder("dbms.checkpoint.interval.time", SettingValueParsers.DURATION, Duration.ofMinutes(15L)).build();
    @Description(value="Configures the volume of transacton logs between check-points. The database will not check-point more often than this (unless check pointing is triggered by a different event), but might check-point less often than this interval, if performing a check-point takes longer time than the configured interval. A check-point is a point in the transaction logs, which recovery would start from. Longer check-point intervals typically mean that recovery will take longer to complete in case of a crash. On the other hand, a longer check-point interval can also reduce the I/O load that the database places on the system, as each check-point implies a flushing and forcing of all the store files.")
    public static final Setting<Long> check_point_interval_volume = SettingImpl.newBuilder("dbms.checkpoint.interval.volume", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)250L)).addConstraint(SettingConstraints.min(ByteUnit.kibiBytes((long)1L))).build();
    @Description(value="Limit the number of IOs the background checkpoint process will consume per second. This setting is advisory, is ignored in Neo4j Community Edition, and is followed to best effort in Enterprise Edition. An IO is in this case a 8 KiB (mostly sequential) write. Limiting the write IO in this way will leave more bandwidth in the IO subsystem to service random-read IOs, which is important for the response time of queries when the database cannot fit entirely in memory. The only drawback of this setting is that longer checkpoint times may lead to slightly longer recovery times in case of a database or system crash. A lower number means lower IO pressure, and consequently longer checkpoint times. Set this to -1 to disable the IOPS limit and remove the limitation entirely; this will let the checkpointer flush data as fast as the hardware will go. Removing the setting, or commenting it out, will set the default value of 600.")
    public static final Setting<Integer> check_point_iops_limit = SettingImpl.newBuilder("dbms.checkpoint.iops.limit", SettingValueParsers.INT, 600).dynamic().build();
    @Description(value="Enable or disable background index sampling")
    public static final Setting<Boolean> index_background_sampling_enabled = SettingImpl.newBuilder("dbms.index_sampling.background_enabled", SettingValueParsers.BOOL, true).build();
    @Description(value="Index sampling chunk size limit")
    public static final Setting<Integer> index_sample_size_limit = SettingImpl.newBuilder("dbms.index_sampling.sample_size_limit", SettingValueParsers.INT, (int)ByteUnit.mebiBytes((long)8L)).addConstraint(SettingConstraints.range((int)ByteUnit.mebiBytes((long)1L), Integer.MAX_VALUE)).build();
    @Description(value="Percentage of index updates of total index size required before sampling of a given index is triggered")
    public static final Setting<Integer> index_sampling_update_percentage = SettingImpl.newBuilder("dbms.index_sampling.update_percentage", SettingValueParsers.INT, 5).addConstraint(SettingConstraints.min(0)).build();
    @Deprecated(since="4.0.0", forRemoval=true)
    @Description(value="The maximum number of open Lucene index searchers.")
    public static final Setting<Integer> lucene_searcher_cache_size = SettingImpl.newBuilder("dbms.index_searcher_cache_size", SettingValueParsers.INT, Integer.MAX_VALUE).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="Index provider to use for newly created schema indexes. An index provider may store different value types in separate physical indexes. native-btree-1.0: All value types and arrays of all value types, even composite keys, are stored in one native index. lucene+native-3.0: Like native-btree-1.0 but single property strings are stored in Lucene. A native index has faster updates, less heap and CPU usage compared to a Lucene index. A native index has some limitations around key size and slower execution of CONTAINS and ENDS WITH string index queries, compared to a Lucene index.\nDeprecated: Which index provider to use will be a fully internal concern.")
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final Setting<String> default_schema_provider = SettingImpl.newBuilder("dbms.index.default_schema_provider", SettingValueParsers.STRING, SchemaIndex.NATIVE_BTREE10.toString()).build();
    @Description(value="Tell Neo4j how long logical transaction logs should be kept to backup the database.For example, \"10 days\" will prune logical logs that only contain transactions older than 10 days.Alternatively, \"100k txs\" will keep the 100k latest transactions from each database and prune any older transactions.")
    public static final Setting<String> keep_logical_logs = SettingImpl.newBuilder("dbms.tx_log.rotation.retention_policy", SettingValueParsers.STRING, "7 days").dynamic().addConstraint(SettingConstraints.matches("^(true|keep_all|false|keep_none|(\\d+[KkMmGg]?( (files|size|txs|entries|hours|days))))$", "Must be `true` or `keep_all`, `false` or `keep_none`, or of format `<number><optional unit> <type>`. Valid units are `K`, `M` and `G`. Valid types are `files`, `size`, `txs`, `entries`, `hours` and `days`. For example, `100M size` will limit logical log space on disk to 100MB per database,and `200K txs` will limit the number of transactions kept to 200 000 per database.")).build();
    @Description(value="Specifies at which file size the logical log will auto-rotate. Minimum accepted value is 128 KiB. ")
    public static final Setting<Long> logical_log_rotation_threshold = SettingImpl.newBuilder("dbms.tx_log.rotation.size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)250L)).addConstraint(SettingConstraints.min(ByteUnit.kibiBytes((long)128L))).dynamic().build();
    @Description(value="On serialization of transaction logs, they will be temporary stored in the byte buffer that will be flushed at the end of the transaction or at any moment when buffer will be full.")
    @DocumentedDefaultValue(value="By default the size of byte buffer is based on number of available cpu's with minimal buffer size of 512KB. Every another 4 cpu's will add another 512KB into the buffer size. Maximal buffer size in this default scheme is 4MB taking into account that we can have one transaction log writer per database in multi-database env.For example, runtime with 4 cpus will have buffer size of 1MB; runtime with 8 cpus will have buffer size of 1MB 512KB; runtime with 12 cpus will have buffer size of 2MB.")
    public static final Setting<Long> transaction_log_buffer_size = SettingImpl.newBuilder("dbms.tx_log.buffer.size", SettingValueParsers.LONG, ByteUnit.kibiBytes((long)((long)Math.min(Runtime.getRuntime().availableProcessors() / 4 + 1, 8) * 512L))).addConstraint(SettingConstraints.min(ByteUnit.kibiBytes((long)128L))).build();
    @Description(value="Specify if Neo4j should try to preallocate logical log file in advance.")
    public static final Setting<Boolean> preallocate_logical_logs = SettingImpl.newBuilder("dbms.tx_log.preallocate", SettingValueParsers.BOOL, true).dynamic().build();
    @Description(value="Specify if Neo4j should try to preallocate store files as they grow.")
    public static final Setting<Boolean> preallocate_store_files = SettingImpl.newBuilder("dbms.store.files.preallocate", SettingValueParsers.BOOL, true).build();
    @Description(value="If `true`, Neo4j will abort recovery if transaction log files are missing. Setting this to `false` will allow Neo4j to create new empty missing files for the already existing  database, but the integrity of the database might be compromised.")
    public static final Setting<Boolean> fail_on_missing_files = SettingImpl.newBuilder("dbms.recovery.fail_on_missing_files", SettingValueParsers.BOOL, true).build();
    @Description(value="The amount of memory to use for mapping the store files, in bytes (or kilobytes with the 'k' suffix, megabytes with 'm' and gigabytes with 'g'). If Neo4j is running on a dedicated server, then it is generally recommended to leave about 2-4 gigabytes for the operating system, give the JVM enough heap to hold all your transaction state and query context, and then leave the rest for the page cache. If no page cache memory is configured, then a heuristic setting is computed based on available system resources.")
    public static final Setting<String> pagecache_memory = SettingImpl.newBuilder("dbms.memory.pagecache.size", SettingValueParsers.STRING, null).build();
    @Description(value="This setting is not used anymore.")
    @Deprecated
    public static final Setting<String> pagecache_swapper = SettingImpl.newBuilder("dbms.memory.pagecache.swapper", SettingValueParsers.STRING, null).build();
    @Description(value="The maximum number of worker threads to use for pre-fetching data when doing sequential scans. Set to '0' to disable pre-fetching for scans.")
    public static final Setting<Integer> pagecache_scan_prefetch = SettingImpl.newBuilder("dbms.memory.pagecache.scan.prefetchers", SettingValueParsers.INT, 4).addConstraint(SettingConstraints.range(0, 255)).build();
    @Description(value="Page cache can be configured to use a temporal buffer for flushing purposes. It is used to combine, if possible, sequence of several cache pages into one bigger buffer to minimize the number of individual IOPS performed and better utilization of available I/O resources, especially when those are restricted.")
    public static final Setting<Boolean> pagecache_buffered_flush_enabled = SettingImpl.newBuilder("dbms.memory.pagecache.flush.buffer.enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Page cache can be configured to use a temporal buffer for flushing purposes. It is used to combine, if possible, sequence of several cache pages into one bigger buffer to minimize the number of individual IOPS performed and better utilization of available I/O resources, especially when those are restricted. Use this setting to configure individual file flush buffer size in pages (8KiB). To be able to utilize this buffer during page cache flushing, buffered flush should be enabled.")
    public static final Setting<Integer> pagecache_flush_buffer_size_in_pages = SettingImpl.newBuilder("dbms.memory.pagecache.flush.buffer.size_in_pages", SettingValueParsers.INT, 128).addConstraint(SettingConstraints.range(1, 512)).dynamic().build();
    @Description(value="The profiling frequency for the page cache. Accurate profiles allow the page cache to do active warmup after a restart, reducing the mean time to performance.\nThis feature is available in Neo4j Enterprise Edition.")
    public static final Setting<Duration> pagecache_warmup_profiling_interval = SettingImpl.newBuilder("dbms.memory.pagecache.warmup.profile.interval", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).build();
    @Description(value="Page cache can be configured to perform usage sampling of loaded pages that can be used to construct active load profile. According to that profile pages can be reloaded on the restart, replication, etc. This setting allows disabling that behavior.\nThis feature is available in Neo4j Enterprise Edition.")
    public static final Setting<Boolean> pagecache_warmup_enabled = SettingImpl.newBuilder("dbms.memory.pagecache.warmup.enable", SettingValueParsers.BOOL, true).build();
    @Description(value="Page cache warmup can be configured to prefetch files, preferably when cache size is bigger than store size. Files to be prefetched can be filtered by 'dbms.memory.pagecache.warmup.preload.allowlist'. Enabling this disables warmup by profile ")
    public static final Setting<Boolean> pagecache_warmup_prefetch = SettingImpl.newBuilder("dbms.memory.pagecache.warmup.preload", SettingValueParsers.BOOL, false).build();
    @Deprecated(since="4.2.0", forRemoval=true)
    @Description(value="Page cache warmup prefetch file whitelist regex. By default matches all files.\nDeprecated, use 'dbms.memory.pagecache.warmup.preload.allowlist'.")
    public static final Setting<String> pagecache_warmup_prefetch_whitelist = SettingImpl.newBuilder("dbms.memory.pagecache.warmup.preload.whitelist", SettingValueParsers.STRING, ".*").build();
    @Description(value="Page cache warmup prefetch file allowlist regex. By default matches all files.")
    public static final Setting<String> pagecache_warmup_prefetch_allowlist = SettingImpl.newBuilder("dbms.memory.pagecache.warmup.preload.allowlist", SettingValueParsers.STRING, ".*").build();
    @Description(value="Use direct I/O for page cache. Setting is supported only on Linux and only for a subset of record formats that use platform aligned page size.")
    public static final Setting<Boolean> pagecache_direct_io = SettingImpl.newBuilder("dbms.memory.pagecache.directio", SettingValueParsers.BOOL, false).build();
    @Description(value="Allows the enabling or disabling of the file watcher service. This is an auxiliary service but should be left enabled in almost all cases.")
    public static final Setting<Boolean> filewatcher_enabled = SettingImpl.newBuilder("dbms.filewatcher.enabled", SettingValueParsers.BOOL, true).build();
    @Description(value="Relationship count threshold for considering a node to be dense.")
    public static final Setting<Integer> dense_node_threshold = SettingImpl.newBuilder("dbms.relationship_grouping_threshold", SettingValueParsers.INT, 50).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="Log executed queries. Valid values are `OFF`, `INFO`, or `VERBOSE`.\n\n`OFF`::  no logging.\n`INFO`:: log queries at the end of execution, that take longer than the configured threshold, `dbms.logs.query.threshold`.\n`VERBOSE`:: log queries at the start and end of execution, regardless of `dbms.logs.query.threshold`.\n\nLog entries are written to the query log (dbms.logs.query.path).\n\nThis feature is available in the Neo4j Enterprise Edition.")
    public static final Setting<LogQueryLevel> log_queries = SettingImpl.newBuilder("dbms.logs.query.enabled", SettingValueParsers.ofEnum(LogQueryLevel.class), LogQueryLevel.VERBOSE).dynamic().build();
    @Description(value="Log format to use for the query log.")
    public static final Setting<FormattedLogFormat> log_query_format = SettingImpl.newBuilder("dbms.logs.query.format", SettingValueParsers.ofEnum(FormattedLogFormat.class), null).setDependency(default_log_format).build();
    @Description(value="Log transaction ID for the executed queries.")
    public static final Setting<Boolean> log_queries_transaction_id = SettingImpl.newBuilder("dbms.logs.query.transaction_id.enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Log the start and end of a transaction. Valid values are 'OFF', 'INFO', or 'VERBOSE'.\nOFF:  no logging.\nINFO: log start and end of transactions that take longer than the configured threshold, dbms.logs.query.transaction.threshold.\nVERBOSE: log start and end of all transactions.\nLog entries are written to the query log (dbms.logs.query.path).\nThis feature is available in the Neo4j Enterprise Edition.")
    public static final Setting<LogQueryLevel> log_queries_transactions_level = SettingImpl.newBuilder("dbms.logs.query.transaction.enabled", SettingValueParsers.ofEnum(LogQueryLevel.class), LogQueryLevel.OFF).dynamic().build();
    @Description(value="Send user logs to the process stdout. If this is disabled then logs will instead be sent to the file _neo4j.log_ located in the logs directory.")
    public static final Setting<Boolean> store_user_log_to_stdout = SettingImpl.newBuilder("dbms.logs.user.stdout_enabled", SettingValueParsers.BOOL, true).build();
    @Description(value="Path of the logs directory.")
    public static final Setting<Path> logs_directory = SettingImpl.newBuilder("dbms.directories.logs", SettingValueParsers.PATH, Path.of("logs", new String[0])).setDependency(neo4j_home).immutable().build();
    @Description(value="Path to the query log file.")
    public static final Setting<Path> log_queries_filename = SettingImpl.newBuilder("dbms.logs.query.path", SettingValueParsers.PATH, Path.of("query.log", new String[0])).setDependency(logs_directory).immutable().build();
    @Description(value="Path to the user log file. Note that if dbms.logs.user.stdout_enabled is enabled this setting will be ignored.")
    public static final Setting<Path> store_user_log_path = SettingImpl.newBuilder("dbms.logs.user.path", SettingValueParsers.PATH, Path.of("neo4j.log", new String[0])).setDependency(logs_directory).immutable().build();
    @Description(value="Log format to use for debug log.")
    public static final Setting<FormattedLogFormat> store_internal_log_format = SettingImpl.newBuilder("dbms.logs.debug.format", SettingValueParsers.ofEnum(FormattedLogFormat.class), null).setDependency(default_log_format).build();
    @Description(value="Path to the debug log file.")
    public static final Setting<Path> store_internal_log_path = SettingImpl.newBuilder("dbms.logs.debug.path", SettingValueParsers.PATH, Path.of("debug.log", new String[0])).setDependency(logs_directory).immutable().build();
    @Description(value="Path of the licenses directory.")
    public static final Setting<Path> licenses_directory = SettingImpl.newBuilder("dbms.directories.licenses", SettingValueParsers.PATH, Path.of("licenses", new String[0])).setDependency(neo4j_home).immutable().build();
    @Description(value="Log parameters for the executed queries being logged.")
    public static final Setting<Boolean> log_queries_parameter_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.parameter_logging_enabled", SettingValueParsers.BOOL, true).dynamic().build();
    @Description(value="Sets a maximum character length use for each parameter in the log. This only takes effect if `dbms.logs.query.parameter_logging_enabled = true`.")
    public static final Setting<Integer> query_log_max_parameter_length = SettingImpl.newBuilder("dbms.logs.query.max_parameter_length", SettingValueParsers.INT, Integer.MAX_VALUE).dynamic().build();
    @Description(value="Log complete parameter entities including id, labels or relationship type, and properties. If false, only the entity id will be logged. This only takes effect if `dbms.logs.query.parameter_logging_enabled = true`.")
    public static final Setting<Boolean> log_queries_parameter_full_entities = SettingImpl.newBuilder("dbms.logs.query.parameter_full_entities", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Log detailed time information for the executed queries being logged, such as `(planning: 92, waiting: 0)`.")
    public static final Setting<Boolean> log_queries_detailed_time_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.time_logging_enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Log allocated bytes for the executed queries being logged. The logged number is cumulative over the duration of the query, i.e. for memory intense or long-running queries the value may be larger than the current memory allocation. Requires `dbms.track_query_allocation=true`")
    public static final Setting<Boolean> log_queries_allocation_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.allocation_logging_enabled", SettingValueParsers.BOOL, true).dynamic().build();
    @Description(value="Logs which runtime that was used to run the query.")
    public static final Setting<Boolean> log_queries_runtime_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.runtime_logging_enabled", SettingValueParsers.BOOL, true).dynamic().build();
    @Description(value="Log page hits and page faults for the executed queries being logged.")
    public static final Setting<Boolean> log_queries_page_detail_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.page_logging_enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Log query text and parameters without obfuscating passwords. This allows queries to be logged earlier before parsing starts.")
    public static final Setting<Boolean> log_queries_early_raw_logging_enabled = SettingImpl.newBuilder("dbms.logs.query.early_raw_logging_enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="If the execution of query takes more time than this threshold, the query is logged once completed - provided query logging is set to INFO. Defaults to 0 seconds, that is all queries are logged.")
    public static final Setting<Duration> log_queries_threshold = SettingImpl.newBuilder("dbms.logs.query.threshold", SettingValueParsers.DURATION, Duration.ZERO).dynamic().build();
    @Description(value="If the transaction is open for more time than this threshold, the transaction is logged once completed - provided transaction logging (dbms.logs.query.transaction.enabled) is set to `INFO`. Defaults to 0 seconds (all transactions are logged).")
    public static final Setting<Duration> log_queries_transaction_threshold = SettingImpl.newBuilder("dbms.logs.query.transaction.threshold", SettingValueParsers.DURATION, Duration.ZERO).dynamic().build();
    @Description(value="The file size in bytes at which the query log will auto-rotate. If set to zero then no rotation will occur. Accepts a binary suffix `k`, `m` or `g`.")
    public static final Setting<Long> log_queries_rotation_threshold = SettingImpl.newBuilder("dbms.logs.query.rotation.size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)20L)).addConstraint(SettingConstraints.range(0L, Long.MAX_VALUE)).dynamic().build();
    @Description(value="Maximum number of history files for the query log.")
    public static final Setting<Integer> log_queries_max_archives = SettingImpl.newBuilder("dbms.logs.query.rotation.keep_number", SettingValueParsers.INT, 7).addConstraint(SettingConstraints.min(1)).dynamic().build();
    @Description(value="Obfuscates all literals of the query before writing to the log. Note that node labels, relationship types and map property keys are still shown. Changing the setting will not affect queries that are cached. So, if you want the switch to have immediate effect, you must also call `CALL db.clearQueryCaches()`.")
    public static final Setting<Boolean> log_queries_obfuscate_literals = SettingImpl.newBuilder("dbms.logs.query.obfuscate_literals", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Log query plan description table, useful for debugging purposes.")
    @DocumentedDefaultValue(value="false")
    public static final Setting<Boolean> log_queries_query_plan = SettingImpl.newBuilder("dbms.logs.query.plan_description_enabled", SettingValueParsers.BOOL, false).dynamic().build();
    @Description(value="Enable auth requirement to access Neo4j.")
    @DocumentedDefaultValue(value="true")
    public static final Setting<Boolean> auth_enabled = SettingImpl.newBuilder("dbms.security.auth_enabled", SettingValueParsers.BOOL, false).build();
    @Description(value="The maximum number of unsuccessful authentication attempts before imposing a user lock for  the configured amount of time, as defined by `dbms.security.auth_lock_time`.The locked out user will not be able to log in until the lock period expires, even if correct  credentials are provided. Setting this configuration option to values less than 3 is not recommended because it might make  it easier for an attacker to brute force the password.")
    public static final Setting<Integer> auth_max_failed_attempts = SettingImpl.newBuilder("dbms.security.auth_max_failed_attempts", SettingValueParsers.INT, 3).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="The amount of time user account should be locked after a configured number of unsuccessful authentication attempts. The locked out user will not be able to log in until the lock period expires, even if correct credentials are provided. Setting this configuration option to a low value is not recommended because it might make it easier for an attacker to brute force the password.")
    public static final Setting<Duration> auth_lock_time = SettingImpl.newBuilder("dbms.security.auth_lock_time", SettingValueParsers.DURATION, Duration.ofSeconds(5L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(0L))).build();
    @Description(value="A list of procedures and user defined functions (comma separated) that are allowed full access to the database. The list may contain both fully-qualified procedure names, and partial names with the wildcard '*'. Note that this enables these procedures to bypass security. Use with caution.")
    public static final Setting<List<String>> procedure_unrestricted = SettingImpl.newBuilder("dbms.security.procedures.unrestricted", SettingValueParsers.listOf(SettingValueParsers.STRING), Collections.emptyList()).build();
    @Deprecated(since="4.2.0", forRemoval=true)
    @Description(value="A list of procedures (comma separated) that are to be loaded. The list may contain both fully-qualified procedure names, and partial names with the wildcard '*'. If this setting is left empty no procedures will be loaded. Deprecated, use dbms.security.procedures.allowlist")
    public static final Setting<List<String>> procedure_whitelist = SettingImpl.newBuilder("dbms.security.procedures.whitelist", SettingValueParsers.listOf(SettingValueParsers.STRING), List.of("*")).build();
    @Description(value="A list of procedures (comma separated) that are to be loaded. The list may contain both fully-qualified procedure names, and partial names with the wildcard '*'. If this setting is left empty no procedures will be loaded.")
    public static final Setting<List<String>> procedure_allowlist = SettingImpl.newBuilder("dbms.security.procedures.allowlist", SettingValueParsers.listOf(SettingValueParsers.STRING), List.of("*")).build();
    @Deprecated(since="4.2.0", forRemoval=true)
    @Description(value="The default role that can execute all procedures and user-defined functions that are not covered by the `dbms.security.procedures.roles` setting. This setting (if not empty string) will be translated to 'GRANT EXECUTE BOOSTED PROCEDURE *' and 'GRANT EXECUTE BOOSTED FUNCTION *' for that role. If `dbms.security.procedures.roles`is not empty, any procedure or function that this role is not mapped to will result in a 'DENY EXECUTE BOOSTED PROCEDURE name' and 'DENY EXECUTE BOOSTED FUNCTION name' for this role. Any privilege mapped in this way cannot be revoked, instead the config must be changed and will take effect after a restart.Deprecated: Replaced by EXECUTE PROCEDURE, EXECUTE BOOSTED PROCEDURE, EXECUTE FUNCTION and EXECUTE BOOSTED FUNCTION privileges.")
    public static final Setting<String> default_allowed = SettingImpl.newBuilder("dbms.security.procedures.default_allowed", SettingValueParsers.STRING, "").build();
    @Deprecated(since="4.2.0", forRemoval=true)
    @Description(value="This provides a finer level of control over which roles can execute procedures than the `dbms.security.procedures.default_allowed` setting. For example: `+dbms.security.procedures.roles=apoc.convert.*:reader;apoc.load.json*:writer;apoc.trigger.add:TriggerHappy+` will allow the role `reader` to execute all procedures in the `apoc.convert` namespace, the role `writer` to execute all procedures in the `apoc.load` namespace that starts with `json` and the role `TriggerHappy` to execute the specific procedure `apoc.trigger.add`. Procedures not matching any of these patterns will be subject to the `dbms.security.procedures.default_allowed` setting. This setting (if not empty string) will be translated to 'GRANT EXECUTE BOOSTED PROCEDURE name' and 'GRANT EXECUTE BOOSTED FUNCTION name' privileges for the mapped roles. Any privilege mapped in this way cannot be revoked, instead the config must be changed and will take effect after a restart.Deprecated: Replaced by EXECUTE PROCEDURE, EXECUTE BOOSTED PROCEDURE, EXECUTE FUNCTION and EXECUTE BOOSTED FUNCTION privileges.")
    public static final Setting<String> procedure_roles = SettingImpl.newBuilder("dbms.security.procedures.roles", SettingValueParsers.STRING, "").build();
    @Description(value="Default network interface to listen for incoming connections. To listen for connections on all interfaces, use \"0.0.0.0\". ")
    public static final Setting<SocketAddress> default_listen_address = SettingImpl.newBuilder("dbms.default_listen_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress("localhost")).addConstraint(SettingConstraints.HOSTNAME_ONLY).immutable().build();
    @Description(value="Default hostname or IP address the server uses to advertise itself.")
    public static final Setting<SocketAddress> default_advertised_address = SettingImpl.newBuilder("dbms.default_advertised_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress("localhost")).addConstraint(SettingConstraints.HOSTNAME_ONLY).immutable().build();
    @Description(value="The maximum amount of time to wait for the database state represented by the bookmark.")
    public static final Setting<Duration> bookmark_ready_timeout = SettingImpl.newBuilder("dbms.transaction.bookmark_ready_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(30L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).dynamic().build();
    @Description(value="How long callers should cache the response of the routing procedure `dbms.routing.getRoutingTable()`")
    public static final Setting<Duration> routing_ttl = SettingImpl.newBuilder("dbms.routing_ttl", SettingValueParsers.DURATION, Duration.ofSeconds(300L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="Limit the amount of memory that all of the running transactions can consume, in bytes (or kilobytes with the 'k' suffix, megabytes with 'm' and gigabytes with 'g'). Zero means 'unlimited'.")
    public static final Setting<Long> memory_transaction_global_max_size = SettingImpl.newBuilder("dbms.memory.transaction.global_max_size", SettingValueParsers.BYTES, 0L).addConstraint(SettingConstraints.any(SettingConstraints.min(ByteUnit.mebiBytes((long)10L)), SettingConstraints.is(0L))).dynamic().build();
    @Description(value="Limit the amount of memory that all transactions in one database can consume, in bytes (or kilobytes with the 'k' suffix, megabytes with 'm' and gigabytes with 'g'). Zero means 'unlimited'.")
    public static final Setting<Long> memory_transaction_database_max_size = SettingImpl.newBuilder("dbms.memory.transaction.database_max_size", SettingValueParsers.BYTES, 0L).addConstraint(SettingConstraints.any(SettingConstraints.min(ByteUnit.mebiBytes((long)10L)), SettingConstraints.is(0L))).dynamic().build();
    @Description(value="Limit the amount of memory that a single transaction can consume, in bytes (or kilobytes with the 'k' suffix, megabytes with 'm' and gigabytes with 'g'). Zero means 'largest possible value'. When `dbms.mode=CORE` or `dbms.mode=SINGLE` and `dbms.clustering.enable=true` this is '2G', in other cases this is 'unlimited'.")
    public static final Setting<Long> memory_transaction_max_size = SettingImpl.newBuilder("dbms.memory.transaction.max_size", SettingValueParsers.BYTES, 0L).addConstraint(SettingConstraints.any(SettingConstraints.min(ByteUnit.mebiBytes((long)1L)), SettingConstraints.is(0L))).addConstraint(SettingConstraints.ifPrimary(SettingConstraints.max(ByteUnit.gibiBytes((long)2L)))).dynamic().build();
    @Description(value="Enable off heap and on heap memory tracking. Should not be set to `false` for clusters.")
    public static final Setting<Boolean> memory_tracking = SettingImpl.newBuilder("dbms.memory.tracking.enable", SettingValueParsers.BOOL, true).build();
    @Description(value="Defines whether memory for transaction state should be allocated on- or off-heap. Note that for small transactions you can gain up to 25% write speed by setting it to `ON_HEAP`.")
    public static final Setting<TransactionStateMemoryAllocation> tx_state_memory_allocation = SettingImpl.newBuilder("dbms.tx_state.memory_allocation", SettingValueParsers.ofEnum(TransactionStateMemoryAllocation.class), TransactionStateMemoryAllocation.OFF_HEAP).build();
    @Description(value="The maximum amount of off-heap memory that can be used to store transaction state data; it's a total amount of memory shared across all active transactions. Zero means 'unlimited'. Used when dbms.tx_state.memory_allocation is set to 'OFF_HEAP'.")
    public static final Setting<Long> tx_state_max_off_heap_memory = SettingImpl.newBuilder("dbms.memory.off_heap.max_size", SettingValueParsers.BYTES, SettingValueParsers.BYTES.parse("2G")).addConstraint(SettingConstraints.min(0L)).build();
    @Description(value="Defines the maximum size of an off-heap memory block that can be cached to speed up allocations. The value must be a power of 2.")
    public static final Setting<Long> tx_state_off_heap_max_cacheable_block_size = SettingImpl.newBuilder("dbms.memory.off_heap.max_cacheable_block_size", SettingValueParsers.BYTES, ByteUnit.kibiBytes((long)512L)).addConstraint(SettingConstraints.min(ByteUnit.kibiBytes((long)4L))).addConstraint(SettingConstraints.POWER_OF_2).build();
    @Description(value="Defines the size of the off-heap memory blocks cache. The cache will contain this number of blocks for each block size that is power of two. Thus, maximum amount of memory used by blocks cache can be calculated as 2 * dbms.memory.off_heap.max_cacheable_block_size * dbms.memory.off_heap.block_cache_size")
    public static final Setting<Integer> tx_state_off_heap_block_cache_size = SettingImpl.newBuilder("dbms.memory.off_heap.block_cache_size", SettingValueParsers.INT, 128).addConstraint(SettingConstraints.min(16)).build();
    @Description(value="Defines whether the dbms may retry reconciling a database to its desired state.")
    public static final Setting<Boolean> reconciler_may_retry = SettingImpl.newBuilder("dbms.reconciler.may_retry", SettingValueParsers.BOOL, false).build();
    @Description(value="Defines the maximum amount of time to wait before retrying after the dbms fails to reconcile a database to its desired state.")
    public static final Setting<Duration> reconciler_maximum_backoff = SettingImpl.newBuilder("dbms.reconciler.max_backoff", SettingValueParsers.DURATION, Duration.ofHours(1L)).addConstraint(SettingConstraints.min(Duration.ofMinutes(1L))).build();
    @Description(value="Defines the minimum amount of time to wait before retrying after the dbms fails to reconcile a database to its desired state.")
    public static final Setting<Duration> reconciler_minimum_backoff = SettingImpl.newBuilder("dbms.reconciler.min_backoff", SettingValueParsers.DURATION, Duration.ofSeconds(2L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="Defines the level of parallelism employed by the reconciler. By default the parallelism equals the number of available processors or 8 (whichever is smaller). If configured as 0, the parallelism of the reconciler will be unbounded.")
    public static final Setting<Integer> reconciler_maximum_parallelism = SettingImpl.newBuilder("dbms.reconciler.max_parallelism", SettingValueParsers.INT, Math.min(Runtime.getRuntime().availableProcessors(), 8)).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="Enable server-side routing in clusters using an additional bolt connector.\nWhen configured, this allows requests to be forwarded from one cluster member to another, if the requests can't be satisfied by the first member (e.g. write requests received by a non-leader).")
    public static final Setting<Boolean> routing_enabled = SettingImpl.newBuilder("dbms.routing.enabled", SettingValueParsers.BOOL, false).build();
    @Description(value="The address the routing connector should bind to")
    public static final Setting<SocketAddress> routing_listen_address = SettingImpl.newBuilder("dbms.routing.listen_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress(7688)).setDependency(default_listen_address).build();
    @Description(value="Sets level for driver internal logging.")
    @DocumentedDefaultValue(value="Value of dbms.logs.debug.level")
    public static final Setting<Level> routing_driver_logging_level = SettingImpl.newBuilder("dbms.routing.driver.logging.level", SettingValueParsers.ofEnum(Level.class), null).build();
    @Description(value="Maximum total number of connections to be managed by a connection pool.\nThe limit is enforced for a combination of a host and user. Negative values are allowed and result in unlimited pool. Value of 0is not allowed.")
    @DocumentedDefaultValue(value="Unlimited")
    public static final Setting<Integer> routing_driver_max_connection_pool_size = SettingImpl.newBuilder("dbms.routing.driver.connection.pool.max_size", SettingValueParsers.INT, -1).build();
    @Description(value="Pooled connections that have been idle in the pool for longer than this timeout will be tested before they are used again, to ensure they are still alive.\nIf this option is set too low, an additional network call will be incurred when acquiring a connection, which causes a performance hit.\nIf this is set high, no longer live connections might be used which might lead to errors.\nHence, this parameter tunes a balance between the likelihood of experiencing connection problems and performance\nNormally, this parameter should not need tuning.\nValue 0 means connections will always be tested for validity")
    @DocumentedDefaultValue(value="No connection liveliness check is done by default.")
    public static final Setting<Duration> routing_driver_idle_time_before_connection_test = SettingImpl.newBuilder("dbms.routing.driver.connection.pool.idle_test", SettingValueParsers.DURATION, null).build();
    @Description(value="Pooled connections older than this threshold will be closed and removed from the pool.\nSetting this option to a low value will cause a high connection churn and might result in a performance hit.\nIt is recommended to set maximum lifetime to a slightly smaller value than the one configured in network\nequipment (load balancer, proxy, firewall, etc. can also limit maximum connection lifetime).\nZero and negative values result in lifetime not being checked.")
    public static final Setting<Duration> routing_driver_max_connection_lifetime = SettingImpl.newBuilder("dbms.routing.driver.connection.max_lifetime", SettingValueParsers.DURATION, Duration.ofHours(1L)).build();
    @Description(value="Maximum amount of time spent attempting to acquire a connection from the connection pool.\nThis timeout only kicks in when all existing connections are being used and no new connections can be created because maximum connection pool size has been reached.\nError is raised when connection can't be acquired within configured time.\nNegative values are allowed and result in unlimited acquisition timeout. Value of 0 is allowed and results in no timeout and immediate failure when connection is unavailable")
    public static final Setting<Duration> routing_driver_connection_acquisition_timeout = SettingImpl.newBuilder("dbms.routing.driver.connection.pool.acquisition_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(60L)).build();
    @Description(value="Socket connection timeout.\nA timeout of zero is treated as an infinite timeout and will be bound by the timeout configured on the\noperating system level.")
    public static final Setting<Duration> routing_driver_connect_timeout = SettingImpl.newBuilder("dbms.routing.driver.connection.connect_timeout", SettingValueParsers.DURATION, Duration.ofSeconds(5L)).build();
    @Description(value="Determines which driver API will be used. ASYNC must be used when the remote instance is 3.5")
    public static final Setting<DriverApi> routing_driver_api = SettingImpl.newBuilder("dbms.routing.driver.api", SettingValueParsers.ofEnum(DriverApi.class), DriverApi.RX).build();
    public static final Map<Setting<?>, Object> SERVER_DEFAULTS = Maps.mutable.withMap(ConnectorDefaults.SERVER_CONNECTOR_DEFAULTS).withKeyValue(auth_enabled, (Object)true);

    public static enum RoutingMode {
        SERVER,
        CLIENT;

    }

    public static enum DriverApi {
        RX,
        ASYNC;

    }

    public static enum Mode {
        SINGLE,
        CORE,
        READ_REPLICA;

    }

    public static enum TransactionStateMemoryAllocation {
        ON_HEAP,
        OFF_HEAP;

    }

    public static enum LogQueryLevel {
        OFF,
        INFO,
        VERBOSE;

    }

    @Deprecated(since="4.4.0", forRemoval=true)
    public static enum SchemaIndex {
        NATIVE_BTREE10("native-btree", "1.0", false),
        NATIVE30("lucene+native", "3.0", false);

        private final String providerKey;
        private final String providerVersion;
        private final boolean deprecated;
        private final String providerName;

        private SchemaIndex(String providerKey, String providerVersion, boolean deprecated) {
            this.providerKey = providerKey;
            this.providerVersion = providerVersion;
            this.deprecated = deprecated;
            this.providerName = SchemaIndex.toProviderName(providerKey, providerVersion);
        }

        public String providerName() {
            return this.providerName;
        }

        public String providerKey() {
            return this.providerKey;
        }

        public String providerVersion() {
            return this.providerVersion;
        }

        public boolean deprecated() {
            return this.deprecated;
        }

        public String toString() {
            return this.providerName;
        }

        private static String toProviderName(String providerName, String providerVersion) {
            return providerName + "-" + providerVersion;
        }
    }

    public static enum CheckpointPolicy {
        PERIODIC,
        CONTINUOUS,
        VOLUME,
        VOLUMETRIC;

    }

    public static enum TransactionTracingLevel {
        DISABLED,
        SAMPLE,
        ALL;

    }

    public static enum CypherPlanner {
        DEFAULT,
        COST;

    }

    public static enum CypherParserVersion {
        DEFAULT("default"),
        V_35("3.5"),
        V_43("4.3"),
        V_44("4.4");

        private final String name;

        private CypherParserVersion(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

