/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.database.readonly;

import java.util.Set;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;

public final class ConfigBasedLookupFactory
implements ReadOnlyDatabases.LookupFactory {
    private final Config config;
    private final DatabaseIdRepository databaseIdRepository;

    public ConfigBasedLookupFactory(Config config, DatabaseIdRepository databaseIdRepository) {
        this.config = config;
        this.databaseIdRepository = databaseIdRepository;
    }

    public ReadOnlyDatabases.Lookup lookupReadOnlyDatabases() {
        return new ConfigLookup(this.databaseIdRepository, this.config.get(GraphDatabaseSettings.read_only_database_default), this.config.get(GraphDatabaseSettings.read_only_databases), this.config.get(GraphDatabaseSettings.writable_databases));
    }

    private static class ConfigLookup
    implements ReadOnlyDatabases.Lookup {
        private final DatabaseIdRepository databaseIdRepository;
        private final boolean readOnlyDefault;
        private final Set<String> readOnlyDatabaseNames;
        private final Set<String> writableDatabaseNames;

        ConfigLookup(DatabaseIdRepository databaseIdRepository, boolean readOnlyDefault, Set<String> readOnlyDatabaseNames, Set<String> writableDatabaseNames) {
            this.databaseIdRepository = databaseIdRepository;
            this.readOnlyDefault = readOnlyDefault;
            this.readOnlyDatabaseNames = readOnlyDatabaseNames;
            this.writableDatabaseNames = writableDatabaseNames;
        }

        public boolean databaseIsReadOnly(NamedDatabaseId databaseId) {
            return this.explicitlyReadOnly(databaseId) || this.implicitlyReadOnly(databaseId);
        }

        private boolean explicitlyReadOnly(NamedDatabaseId databaseId) {
            return this.containsDatabaseId(this.readOnlyDatabaseNames, databaseId);
        }

        private boolean implicitlyReadOnly(NamedDatabaseId databaseId) {
            return this.readOnlyDefault && !this.containsDatabaseId(this.writableDatabaseNames, databaseId);
        }

        private boolean containsDatabaseId(Set<String> names, NamedDatabaseId databaseId) {
            return names.stream().flatMap(name -> this.databaseIdRepository.getByName(name).stream()).anyMatch(arg_0 -> ((NamedDatabaseId)databaseId).equals(arg_0));
        }
    }
}

