/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.neo4j.configuration.helpers.ConfigPatternBuilder;
import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class DatabaseNamePattern {
    private final Optional<Pattern> regexPattern;
    private final String databaseName;
    private final String normalizedDatabaseName;

    public DatabaseNamePattern(String name) {
        DatabaseNameValidator.validateDatabaseNamePattern(name);
        this.regexPattern = ConfigPatternBuilder.optionalPatternFromConfigString(name.toLowerCase(Locale.ROOT), 2);
        this.databaseName = name;
        this.normalizedDatabaseName = new NormalizedDatabaseName(name).name();
    }

    public boolean matches(String value) {
        return this.regexPattern.map(p -> p.matcher(value).matches()).orElse(this.normalizedDatabaseName.equals(value));
    }

    public boolean containsPattern() {
        return this.regexPattern.isPresent();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getNormalizedDatabaseName() {
        return this.normalizedDatabaseName;
    }

    public String toString() {
        if (this.containsPattern()) {
            return "Database name pattern=" + this.databaseName;
        }
        return "Database name=" + this.databaseName;
    }

    public static Optional<Set<String>> exactNames(List<DatabaseNamePattern> patterns) {
        HashSet<String> exact = new HashSet<String>();
        for (DatabaseNamePattern pattern : patterns) {
            if (pattern.containsPattern()) {
                return Optional.empty();
            }
            exact.add(pattern.getDatabaseName());
        }
        return Optional.of(exact);
    }

    public static Predicate<String> matchAny(List<DatabaseNamePattern> patterns) {
        return string -> patterns.stream().anyMatch(pattern -> pattern.matches((String)string));
    }

    public static List<DatabaseNamePattern> patternsOf(String ... patterns) {
        return Arrays.stream(patterns).map(DatabaseNamePattern::new).toList();
    }
}

