/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency.checking;

import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.legacy.consistency.checking.CheckerEngine;
import org.neo4j.legacy.consistency.checking.ComparativeRecordChecker;
import org.neo4j.legacy.consistency.checking.RecordCheck;
import org.neo4j.legacy.consistency.report.ConsistencyReport;
import org.neo4j.legacy.consistency.store.DiffRecordAccess;
import org.neo4j.legacy.consistency.store.RecordAccess;
import org.neo4j.legacy.consistency.store.RecordReference;

abstract class TokenRecordCheck<RECORD extends TokenRecord, REPORT extends ConsistencyReport>
implements RecordCheck<RECORD, REPORT>,
ComparativeRecordChecker<RECORD, DynamicRecord, REPORT> {
    TokenRecordCheck() {
    }

    @Override
    public void checkChange(RECORD oldRecord, RECORD newRecord, CheckerEngine<RECORD, REPORT> engine, DiffRecordAccess records) {
        this.check(newRecord, engine, (RecordAccess)records);
    }

    @Override
    public void check(RECORD record, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        if (!record.inUse()) {
            return;
        }
        if (!Record.NO_NEXT_BLOCK.is((long)record.getNameId())) {
            engine.comparativeCheck(this.name(records, record.getNameId()), this);
        }
    }

    @Override
    public void checkReference(RECORD record, DynamicRecord name, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        if (!name.inUse()) {
            this.nameNotInUse(engine.report(), name);
        } else if (name.getLength() <= 0) {
            this.emptyName(engine.report(), name);
        }
    }

    abstract RecordReference<DynamicRecord> name(RecordAccess var1, int var2);

    abstract void nameNotInUse(REPORT var1, DynamicRecord var2);

    abstract void emptyName(REPORT var1, DynamicRecord var2);
}

