/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency.checking.full;

import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.legacy.consistency.checking.CheckerEngine;
import org.neo4j.legacy.consistency.checking.RecordCheck;
import org.neo4j.legacy.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.legacy.consistency.report.ConsistencyReport;
import org.neo4j.legacy.consistency.store.DiffRecordAccess;
import org.neo4j.legacy.consistency.store.RecordAccess;
import org.neo4j.legacy.consistency.store.synthetic.IndexEntry;

public class IndexCheck
implements RecordCheck<IndexEntry, ConsistencyReport.IndexConsistencyReport> {
    private final IndexRule indexRule;

    public IndexCheck(IndexRule indexRule) {
        this.indexRule = indexRule;
    }

    @Override
    public void check(IndexEntry record, CheckerEngine<IndexEntry, ConsistencyReport.IndexConsistencyReport> engine, RecordAccess records) {
        engine.comparativeCheck(records.node(record.getId()), new NodeInUseWithCorrectLabelsCheck(new long[]{this.indexRule.getLabel()}));
    }

    @Override
    public void checkChange(IndexEntry oldRecord, IndexEntry newRecord, CheckerEngine<IndexEntry, ConsistencyReport.IndexConsistencyReport> engine, DiffRecordAccess records) {
        this.check(newRecord, engine, (RecordAccess)records);
    }
}

