/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency.checking.full;

import org.neo4j.kernel.api.labelscan.LabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.legacy.consistency.checking.RecordCheck;
import org.neo4j.legacy.consistency.checking.full.LabelsMatchCheck;
import org.neo4j.legacy.consistency.checking.full.RecordProcessor;
import org.neo4j.legacy.consistency.report.ConsistencyReport;
import org.neo4j.legacy.consistency.report.ConsistencyReporter;

public class NodeToLabelScanRecordProcessor
implements RecordProcessor<NodeRecord> {
    private final ConsistencyReporter reporter;
    private final RecordCheck<NodeRecord, ConsistencyReport.LabelsMatchReport> nodeLabelCheck;
    private final LabelScanReader reader;

    public NodeToLabelScanRecordProcessor(ConsistencyReporter reporter, LabelScanStore labelScanStore) {
        this.reporter = reporter;
        this.reader = labelScanStore.newReader();
        this.nodeLabelCheck = new LabelsMatchCheck(this.reader);
    }

    @Override
    public void process(NodeRecord nodeRecord) {
        this.reporter.forNodeLabelMatch(nodeRecord, this.nodeLabelCheck);
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

