/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.ConsistencyReportLog;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.consistency.statistics.AccessStatsKeepingStoreAccess;
import org.neo4j.consistency.statistics.DefaultCounts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.statistics.VerboseStatistics;
import org.neo4j.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.index.lucene.LuceneLabelScanStoreBuilder;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ConsistencyCheckService {
    private final Date timestamp;

    public ConsistencyCheckService() {
        this(new Date());
    }

    public ConsistencyCheckService(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, boolean verbose) throws ConsistencyCheckIncompleteException, IOException {
        return this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), verbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, boolean verbose) throws ConsistencyCheckIncompleteException, IOException {
        Log log = logProvider.getLog(this.getClass());
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, tuningConfiguration, PageCacheTracer.NULL, logProvider.getLog(PageCache.class));
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        try {
            Result result = this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache, verbose);
            return result;
        }
        finally {
            try {
                pageCache.close();
            }
            catch (IOException e) {
                log.error("Failure during shutdown of the page cache", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, final FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary;
        Log log = logProvider.getLog(this.getClass());
        Config consistencyCheckerConfig = tuningConfiguration.with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
        StoreFactory factory = new StoreFactory(storeDir, consistencyCheckerConfig, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem), pageCache, fileSystem, logProvider);
        final File reportFile = this.chooseReportPath(storeDir, tuningConfiguration);
        ConsistencyReportLog reportLog = new ConsistencyReportLog((Supplier<PrintWriter>)Suppliers.lazySingleton((Supplier)new Supplier<PrintWriter>(){

            public PrintWriter get() {
                try {
                    return new PrintWriter(Files.createOrOpenAsOuputStream((FileSystemAbstraction)fileSystem, (File)reportFile, (boolean)true));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
        try (NeoStores neoStores = factory.openAllNeoStores();){
            LabelScanStore labelScanStore = null;
            try {
                StoreAccess storeAccess;
                Statistics statistics;
                labelScanStore = new LuceneLabelScanStoreBuilder(storeDir, neoStores, fileSystem, logProvider).build();
                LuceneSchemaIndexProvider indexes = new LuceneSchemaIndexProvider(fileSystem, DirectoryFactory.PERSISTENT, storeDir);
                int numberOfThreads = ConsistencyCheckService.defaultConsistencyCheckThreadsNumber();
                AccessStatistics stats = new AccessStatistics();
                if (verbose) {
                    statistics = new VerboseStatistics(stats, new DefaultCounts(numberOfThreads), log);
                    storeAccess = new AccessStatsKeepingStoreAccess(neoStores, stats);
                } else {
                    statistics = Statistics.NONE;
                    storeAccess = new StoreAccess(neoStores);
                }
                storeAccess.initialize();
                DirectStoreAccess stores = new DirectStoreAccess(storeAccess, labelScanStore, (SchemaIndexProvider)indexes);
                FullCheck check = new FullCheck(tuningConfiguration, progressFactory, statistics, numberOfThreads);
                summary = check.execute(stores, (Log)new DuplicatingLog(new Log[]{log, reportLog}));
            }
            finally {
                try {
                    if (null != labelScanStore) {
                        labelScanStore.shutdown();
                    }
                }
                catch (IOException e) {
                    log.error("Failure during shutdown of label scan store", (Throwable)e);
                }
            }
        }
        if (!summary.isConsistent()) {
            log.warn("See '%s' for a detailed consistency report.", new Object[]{reportFile.getPath()});
            return Result.FAILURE;
        }
        return Result.SUCCESS;
    }

    private File chooseReportPath(File storeDir, Config tuningConfiguration) {
        File reportPath = (File)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_report_file);
        if (reportPath == null) {
            return new File(storeDir, ConsistencyCheckService.defaultLogFileName(this.timestamp));
        }
        if (reportPath.isDirectory()) {
            return new File(reportPath, ConsistencyCheckService.defaultLogFileName(this.timestamp));
        }
        return reportPath;
    }

    public static String defaultLogFileName(Date date) {
        String formattedDate = new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(date);
        return String.format("inconsistencies-%s.report", formattedDate);
    }

    public static int defaultConsistencyCheckThreadsNumber() {
        return Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
    }

    public static enum Result {
        FAILURE(false),
        SUCCESS(true);

        private final boolean successful;

        private Result(boolean successful) {
            this.successful = successful;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

