/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.PrintWriter;
import org.neo4j.consistency.ConsistencyReportLogger;
import org.neo4j.function.Consumer;
import org.neo4j.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogger;

public class ConsistencyReportLog
extends AbstractLog {
    private final Supplier<PrintWriter> writerSupplier;
    private final Object lock;
    private final Logger infoLogger;
    private final Logger warnLogger;
    private final Logger errorLogger;

    public ConsistencyReportLog(Supplier<PrintWriter> writerSupplier) {
        this(writerSupplier, null, true);
    }

    private ConsistencyReportLog(Supplier<PrintWriter> writerSupplier, Object maybeLock, boolean autoFlush) {
        this.writerSupplier = writerSupplier;
        this.lock = maybeLock != null ? maybeLock : this;
        this.infoLogger = new ConsistencyReportLogger(writerSupplier, this.lock, "INFO ", autoFlush);
        this.warnLogger = new ConsistencyReportLogger(writerSupplier, this.lock, "WARN ", autoFlush);
        this.errorLogger = new ConsistencyReportLogger(writerSupplier, this.lock, "ERROR", autoFlush);
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public Logger debugLogger() {
        return NullLogger.getInstance();
    }

    public Logger infoLogger() {
        return this.infoLogger;
    }

    public Logger warnLogger() {
        return this.warnLogger;
    }

    public Logger errorLogger() {
        return this.errorLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulk(Consumer<Log> consumer) {
        ConsistencyReportLog consistencyReportLog = this;
        synchronized (consistencyReportLog) {
            PrintWriter writer = (PrintWriter)this.writerSupplier.get();
            consumer.accept((Object)new ConsistencyReportLog((Supplier<PrintWriter>)Suppliers.singleton((Object)writer), this.lock, false));
        }
    }
}

