/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import org.neo4j.io.ByteUnit;

class ConsistencyCheckMemoryCalculation {
    static final long MIN_SIZE = ByteUnit.mebiBytes((long)8L);

    ConsistencyCheckMemoryCalculation() {
    }

    static MemoryDistribution calculate(long maxOffHeapMemory, long desiredPageCacheMemory, long desiredOffHeapCachingMemory) {
        long pageCacheMemory = desiredPageCacheMemory;
        if (desiredPageCacheMemory + desiredOffHeapCachingMemory > maxOffHeapMemory) {
            long maxPageCacheSizeForOptimalCachingSize = Math.max(maxOffHeapMemory - desiredOffHeapCachingMemory, 0L);
            pageCacheMemory = Long.min(Long.max(maxPageCacheSizeForOptimalCachingSize, (long)((double)maxOffHeapMemory * 0.75)), desiredPageCacheMemory);
        }
        long offHeapCachingMemory = Math.min(maxOffHeapMemory - pageCacheMemory, desiredOffHeapCachingMemory);
        assert (pageCacheMemory + offHeapCachingMemory <= maxOffHeapMemory) : "Too much memory being used pageCacheMemory:" + pageCacheMemory + " offHeapCachingMemory:" + offHeapCachingMemory;
        return new MemoryDistribution(Math.max(pageCacheMemory, MIN_SIZE), Math.max(offHeapCachingMemory, MIN_SIZE));
    }

    record MemoryDistribution(long pageCacheMemory, long offHeapCachingMemory) {
    }
}

