/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.NodeField;
import org.neo4j.consistency.checking.PrimitiveRecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public class RelationshipRecordCheck
extends PrimitiveRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> {
    public RelationshipRecordCheck() {
        this(new RecordField[]{RelationshipTypeField.RELATIONSHIP_TYPE, NodeField.SOURCE, RelationshipField.SOURCE_PREV, RelationshipField.SOURCE_NEXT, NodeField.TARGET, RelationshipField.TARGET_PREV, RelationshipField.TARGET_NEXT});
    }

    @SafeVarargs
    RelationshipRecordCheck(RecordField<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> ... fields) {
        super(fields);
    }

    public static RelationshipRecordCheck relationshipRecordCheckForwardPass() {
        return new RelationshipRecordCheck(new RecordField[]{RelationshipTypeField.RELATIONSHIP_TYPE});
    }

    @SafeVarargs
    public static RelationshipRecordCheck relationshipRecordCheckBackwardPass(RecordField<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> ... additional) {
        return new RelationshipRecordCheck((RecordField[])ArrayUtil.union((Object[])ArrayUtil.array((Object[])new RecordField[]{NodeField.SOURCE, NodeField.TARGET}), (Object[])additional));
    }

    public static RelationshipRecordCheck relationshipRecordCheckSourceChain() {
        return new RelationshipRecordCheck(new RecordField[]{RelationshipField.SOURCE_NEXT, RelationshipField.SOURCE_PREV, RelationshipField.TARGET_NEXT, RelationshipField.TARGET_PREV, RelationshipField.CACHE_VALUES});
    }

    static enum RelationshipField implements RecordField<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>,
    ComparativeRecordChecker<RelationshipRecord, RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>
    {
        SOURCE_PREV(NodeField.SOURCE){

            @Override
            public long valueFrom(RelationshipRecord relationship) {
                return relationship.getFirstPrevRel();
            }

            @Override
            long other(NodeField field, RelationshipRecord relationship) {
                return field.next(relationship);
            }

            @Override
            void otherNode(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.sourcePrevReferencesOtherNodes(relationship);
            }

            @Override
            void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.sourcePrevDoesNotReferenceBack(relationship);
            }

            @Override
            boolean endOfChain(RelationshipRecord record) {
                return this.NODE.isFirst(record);
            }

            @Override
            RelationshipRecord populateRelationshipFromCache(long nodeId, RelationshipRecord rel, CacheAccess.Client cacheAccess) {
                if (cacheAccess.getFromCache(nodeId, 0) == 0L) {
                    rel.setFirstNextRel(cacheAccess.getFromCache(nodeId, 3));
                } else {
                    rel.setSecondNextRel(cacheAccess.getFromCache(nodeId, 3));
                }
                rel.setInUse(cacheAccess.getBooleanFromCache(nodeId, 4));
                return rel;
            }

            @Override
            void linkChecked(CacheAccess.Client cacheAccess) {
                cacheAccess.incAndGetCount(Counts.Type.relSourcePrevCheck);
            }
        }
        ,
        SOURCE_NEXT(NodeField.SOURCE){

            @Override
            public long valueFrom(RelationshipRecord relationship) {
                return relationship.getFirstNextRel();
            }

            @Override
            long other(NodeField field, RelationshipRecord relationship) {
                return field.prev(relationship);
            }

            @Override
            void otherNode(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.sourceNextReferencesOtherNodes(relationship);
            }

            @Override
            void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.sourceNextDoesNotReferenceBack(relationship);
            }

            @Override
            boolean endOfChain(RelationshipRecord record) {
                return this.NODE.next(record) == (long)Record.NO_NEXT_RELATIONSHIP.intValue();
            }

            @Override
            RelationshipRecord populateRelationshipFromCache(long nodeId, RelationshipRecord rel, CacheAccess.Client cacheAccess) {
                if (cacheAccess.getFromCache(nodeId, 0) == 0L) {
                    rel.setFirstPrevRel(cacheAccess.getFromCache(nodeId, 3));
                } else {
                    rel.setSecondPrevRel(cacheAccess.getFromCache(nodeId, 3));
                }
                rel.setInUse(cacheAccess.getBooleanFromCache(nodeId, 4));
                return rel;
            }

            @Override
            void linkChecked(CacheAccess.Client cacheAccess) {
                cacheAccess.incAndGetCount(Counts.Type.relSourceNextCheck);
            }
        }
        ,
        TARGET_PREV(NodeField.TARGET){

            @Override
            public long valueFrom(RelationshipRecord relationship) {
                return relationship.getSecondPrevRel();
            }

            @Override
            long other(NodeField field, RelationshipRecord relationship) {
                return field.next(relationship);
            }

            @Override
            void otherNode(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.targetPrevReferencesOtherNodes(relationship);
            }

            @Override
            void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.targetPrevDoesNotReferenceBack(relationship);
            }

            @Override
            boolean endOfChain(RelationshipRecord record) {
                return this.NODE.isFirst(record);
            }

            @Override
            RelationshipRecord populateRelationshipFromCache(long nodeId, RelationshipRecord rel, CacheAccess.Client cacheAccess) {
                if (cacheAccess.getFromCache(nodeId, 0) == 0L) {
                    rel.setFirstNextRel(cacheAccess.getFromCache(nodeId, 3));
                } else {
                    rel.setSecondNextRel(cacheAccess.getFromCache(nodeId, 3));
                }
                rel.setInUse(cacheAccess.getBooleanFromCache(nodeId, 4));
                return rel;
            }

            @Override
            void linkChecked(CacheAccess.Client cacheAccess) {
                cacheAccess.incAndGetCount(Counts.Type.relTargetPrevCheck);
            }
        }
        ,
        TARGET_NEXT(NodeField.TARGET){

            @Override
            public long valueFrom(RelationshipRecord relationship) {
                return relationship.getSecondNextRel();
            }

            @Override
            long other(NodeField field, RelationshipRecord relationship) {
                return field.prev(relationship);
            }

            @Override
            void otherNode(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.targetNextReferencesOtherNodes(relationship);
            }

            @Override
            void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
                report.targetNextDoesNotReferenceBack(relationship);
            }

            @Override
            boolean endOfChain(RelationshipRecord record) {
                return this.NODE.next(record) == (long)Record.NO_NEXT_RELATIONSHIP.intValue();
            }

            @Override
            RelationshipRecord populateRelationshipFromCache(long nodeId, RelationshipRecord rel, CacheAccess.Client cacheAccess) {
                if (cacheAccess.getFromCache(nodeId, 0) == 0L) {
                    rel.setFirstPrevRel(cacheAccess.getFromCache(nodeId, 3));
                } else {
                    rel.setSecondPrevRel(cacheAccess.getFromCache(nodeId, 3));
                }
                rel.setInUse(cacheAccess.getBooleanFromCache(nodeId, 4));
                return rel;
            }

            @Override
            void linkChecked(CacheAccess.Client cacheAccess) {
                cacheAccess.incAndGetCount(Counts.Type.relTargetNextCheck);
            }
        }
        ,
        CACHE_VALUES(null){

            @Override
            public long valueFrom(RelationshipRecord record) {
                return 0L;
            }

            @Override
            boolean endOfChain(RelationshipRecord record) {
                return false;
            }

            @Override
            long other(NodeField field, RelationshipRecord relationship) {
                return 0L;
            }

            @Override
            void otherNode(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
            }

            @Override
            void noBackReference(ConsistencyReport.RelationshipConsistencyReport report, RelationshipRecord relationship) {
            }

            @Override
            RelationshipRecord populateRelationshipFromCache(long nodeId, RelationshipRecord rel, CacheAccess.Client cacheAccess) {
                return null;
            }

            @Override
            public void checkConsistency(RelationshipRecord relationship, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records) {
                boolean cache2Free;
                if (!relationship.inUse()) {
                    return;
                }
                CacheAccess.Client cacheAccess = records.cacheAccess().client();
                boolean cache1Free = cacheAccess.getFromCache(relationship.getFirstNode(), 2) == -1L;
                boolean bl = cache2Free = cacheAccess.getFromCache(relationship.getSecondNode(), 2) == -1L;
                if (records.cacheAccess().isForward()) {
                    if (cacheAccess.withinBounds(relationship.getFirstNode())) {
                        cacheAccess.putToCache(relationship.getFirstNode(), 0L, 0L, relationship.getId(), relationship.getFirstPrevRel(), 1L);
                        this.updateCacheCounts(cache1Free, cacheAccess);
                    }
                    if (cacheAccess.withinBounds(relationship.getSecondNode())) {
                        cacheAccess.putToCache(relationship.getSecondNode(), -1L, 0L, relationship.getId(), relationship.getSecondPrevRel(), 1L);
                        this.updateCacheCounts(cache2Free, cacheAccess);
                    }
                } else {
                    if (cacheAccess.withinBounds(relationship.getFirstNode())) {
                        cacheAccess.putToCache(relationship.getFirstNode(), 0L, -1L, relationship.getId(), relationship.getFirstNextRel(), 1L);
                        this.updateCacheCounts(cache1Free, cacheAccess);
                    }
                    if (cacheAccess.withinBounds(relationship.getSecondNode())) {
                        cacheAccess.putToCache(relationship.getSecondNode(), -1L, -1L, relationship.getId(), relationship.getSecondNextRel(), 1L);
                        this.updateCacheCounts(cache2Free, cacheAccess);
                    }
                }
            }

            private void updateCacheCounts(boolean free, CacheAccess.Client cacheAccess) {
                if (!free) {
                    cacheAccess.incAndGetCount(Counts.Type.overwrite);
                } else {
                    cacheAccess.incAndGetCount(Counts.Type.activeCache);
                }
            }

            @Override
            void linkChecked(CacheAccess.Client cacheAccess) {
                cacheAccess.incAndGetCount(Counts.Type.relCacheCheck);
            }
        };

        protected final NodeField NODE;

        private RelationshipField(NodeField node) {
            this.NODE = node;
        }

        private RecordReference<RelationshipRecord> buildFromCache(RelationshipRecord relationship, long reference, long nodeId, RecordAccess records) {
            CacheAccess.Client cacheAccess = records.cacheAccess().client();
            if (!cacheAccess.withinBounds(nodeId)) {
                cacheAccess.incAndGetCount(Counts.Type.correctSkipCheck);
                return RecordReference.SkippingReference.skipReference();
            }
            if (reference != cacheAccess.getFromCache(nodeId, 2)) {
                if (this.referenceShouldBeSkipped(relationship, reference, records)) {
                    cacheAccess.incAndGetCount(Counts.Type.correctSkipCheck);
                    return RecordReference.SkippingReference.skipReference();
                }
                cacheAccess.incAndGetCount(Counts.Type.missCheck);
                return records.relationship(reference);
            }
            RelationshipRecord rel = new RelationshipRecord(reference);
            rel.setCreated();
            if (cacheAccess.getFromCache(nodeId, 0) == 0L) {
                rel.setFirstNode(nodeId);
            } else {
                rel.setSecondNode(nodeId);
            }
            rel = this.populateRelationshipFromCache(nodeId, rel, cacheAccess);
            return new DirectRecordReference<RelationshipRecord>(rel, records);
        }

        private boolean referenceShouldBeSkipped(RelationshipRecord relationship, long reference, RecordAccess records) {
            return records.cacheAccess().isForward() && reference > relationship.getId() || !records.cacheAccess().isForward() && reference < relationship.getId();
        }

        @Override
        public void checkConsistency(RelationshipRecord relationship, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records) {
            CacheAccess.Client cacheAccess = records.cacheAccess().client();
            if (!this.endOfChain(relationship)) {
                RecordReference<Object> referred = null;
                long reference = this.valueFrom(relationship);
                long nodeId = -1L;
                if (records.shouldCheck(reference, MultiPassStore.RELATIONSHIPS)) {
                    long l = nodeId = this.NODE == NodeField.SOURCE ? relationship.getFirstNode() : relationship.getSecondNode();
                    if (Record.NO_NEXT_RELATIONSHIP.is(cacheAccess.getFromCache(nodeId, 2))) {
                        referred = RecordReference.SkippingReference.skipReference();
                        cacheAccess.incAndGetCount(Counts.Type.noCacheSkip);
                    } else {
                        referred = this.buildFromCache(relationship, reference, nodeId, records);
                        if (referred == RecordReference.SkippingReference.skipReference()) {
                            cacheAccess.incAndGetCount(Counts.Type.skipCheck);
                        }
                    }
                } else if (this.referenceShouldBeSkipped(relationship, reference, records)) {
                    referred = RecordReference.SkippingReference.skipReference();
                }
                engine.comparativeCheck(referred, this);
                if (referred != RecordReference.SkippingReference.skipReference()) {
                    cacheAccess.incAndGetCount(Counts.Type.checked);
                    this.linkChecked(cacheAccess);
                }
            } else {
                cacheAccess.incAndGetCount(Counts.Type.checked);
                this.linkChecked(cacheAccess);
            }
        }

        @Override
        public void checkReference(RelationshipRecord record, RelationshipRecord referred, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records) {
            NodeField field = NodeField.select(referred, this.node(record));
            if (field == null) {
                this.otherNode(engine.report(), referred);
            } else {
                CacheAccess.Client cacheAccess = records.cacheAccess().client();
                if (this.other(field, referred) != record.getId()) {
                    if (referred.isCreated()) {
                        RecordReference<RelationshipRecord> refRel = records.relationship(referred.getId());
                        referred = (RelationshipRecord)((DirectRecordReference)refRel).record();
                        this.checkReference(record, referred, engine, records);
                        cacheAccess.incAndGetCount(Counts.Type.skipBackup);
                    } else {
                        cacheAccess.incAndGetCount(Counts.Type.checkErrors);
                        this.noBackReference(engine == null ? null : engine.report(), referred);
                    }
                } else {
                    if (!this.referenceShouldBeSkipped(record, referred.getId(), records) && !referred.inUse()) {
                        engine.report().notUsedRelationshipReferencedInChain(referred);
                    }
                    if (referred.isCreated()) {
                        cacheAccess.clearCache(this.node(record));
                    }
                }
            }
        }

        abstract boolean endOfChain(RelationshipRecord var1);

        abstract long other(NodeField var1, RelationshipRecord var2);

        abstract void otherNode(ConsistencyReport.RelationshipConsistencyReport var1, RelationshipRecord var2);

        abstract void noBackReference(ConsistencyReport.RelationshipConsistencyReport var1, RelationshipRecord var2);

        abstract RelationshipRecord populateRelationshipFromCache(long var1, RelationshipRecord var3, CacheAccess.Client var4);

        abstract void linkChecked(CacheAccess.Client var1);

        private long node(RelationshipRecord relationship) {
            return this.NODE.valueFrom(relationship);
        }
    }

    static enum RelationshipTypeField implements RecordField<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>,
    ComparativeRecordChecker<RelationshipRecord, RelationshipTypeTokenRecord, ConsistencyReport.RelationshipConsistencyReport>
    {
        RELATIONSHIP_TYPE;


        @Override
        public void checkConsistency(RelationshipRecord record, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records) {
            if (record.getType() < 0) {
                engine.report().illegalRelationshipType();
            } else {
                engine.comparativeCheck(records.relationshipType(record.getType()), this);
            }
        }

        @Override
        public long valueFrom(RelationshipRecord record) {
            return record.getType();
        }

        @Override
        public void checkReference(RelationshipRecord record, RelationshipTypeTokenRecord referred, CheckerEngine<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> engine, RecordAccess records) {
            if (!referred.inUse()) {
                engine.report().relationshipTypeNotInUse(referred);
            }
        }
    }
}

