/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import java.util.Iterator;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public class DirectRecordAccess
implements RecordAccess {
    final StoreAccess access;
    final CacheAccess cacheAccess;

    public DirectRecordAccess(StoreAccess access, CacheAccess cacheAccess) {
        this.access = access;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public RecordReference<DynamicRecord> schema(long id) {
        return this.referenceTo(this.access.getSchemaStore(), id);
    }

    @Override
    public RecordReference<NodeRecord> node(long id) {
        return this.referenceTo(this.access.getNodeStore(), id);
    }

    @Override
    public RecordReference<RelationshipRecord> relationship(long id) {
        return this.referenceTo(this.access.getRelationshipStore(), id);
    }

    @Override
    public RecordReference<RelationshipGroupRecord> relationshipGroup(long id) {
        return this.referenceTo(this.access.getRelationshipGroupStore(), id);
    }

    @Override
    public RecordReference<PropertyRecord> property(long id) {
        return this.referenceTo(this.access.getPropertyStore(), id);
    }

    @Override
    public Iterator<PropertyRecord> rawPropertyChain(final long firstId) {
        return new PrefetchingIterator<PropertyRecord>(){
            private long next;
            {
                this.next = firstId;
            }

            protected PropertyRecord fetchNextOrNull() {
                if (Record.NO_NEXT_PROPERTY.is(this.next)) {
                    return null;
                }
                PropertyRecord record = (PropertyRecord)DirectRecordAccess.this.referenceTo(DirectRecordAccess.this.access.getPropertyStore(), this.next).record();
                this.next = record.getNextProp();
                return record;
            }
        };
    }

    @Override
    public RecordReference<RelationshipTypeTokenRecord> relationshipType(int id) {
        return this.referenceTo(this.access.getRelationshipTypeTokenStore(), id);
    }

    @Override
    public RecordReference<PropertyKeyTokenRecord> propertyKey(int id) {
        return this.referenceTo(this.access.getPropertyKeyTokenStore(), id);
    }

    @Override
    public RecordReference<DynamicRecord> string(long id) {
        return this.referenceTo(this.access.getStringStore(), id);
    }

    @Override
    public RecordReference<DynamicRecord> array(long id) {
        return this.referenceTo(this.access.getArrayStore(), id);
    }

    @Override
    public RecordReference<DynamicRecord> relationshipTypeName(int id) {
        return this.referenceTo(this.access.getRelationshipTypeNameStore(), id);
    }

    @Override
    public RecordReference<DynamicRecord> nodeLabels(long id) {
        return this.referenceTo(this.access.getNodeDynamicLabelStore(), id);
    }

    @Override
    public RecordReference<LabelTokenRecord> label(int id) {
        return this.referenceTo(this.access.getLabelTokenStore(), id);
    }

    @Override
    public RecordReference<DynamicRecord> labelName(int id) {
        return this.referenceTo(this.access.getLabelNameStore(), id);
    }

    @Override
    public RecordReference<DynamicRecord> propertyKeyName(int id) {
        return this.referenceTo(this.access.getPropertyKeyNameStore(), id);
    }

    @Override
    public RecordReference<NeoStoreRecord> graph() {
        return new DirectRecordReference<NeoStoreRecord>(this.access.getRawNeoStores().getMetaDataStore().graphPropertyRecord(), this);
    }

    @Override
    public boolean shouldCheck(long id, MultiPassStore store) {
        return true;
    }

    <RECORD extends AbstractBaseRecord> DirectRecordReference<RECORD> referenceTo(RecordStore<RECORD> store, long id) {
        return new DirectRecordReference<AbstractBaseRecord>(store.getRecord(id, store.newRecord(), RecordLoad.FORCE), this);
    }

    @Override
    public CacheAccess cacheAccess() {
        return this.cacheAccess;
    }
}

