/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.consistency.CheckConsistencyCommand;

public class CheckConsistencyCommandProvider
extends AdminCommand.Provider {
    public CheckConsistencyCommandProvider() {
        super("check-consistency", new String[0]);
    }

    @Nonnull
    public Arguments allArguments() {
        return CheckConsistencyCommand.arguments();
    }

    @Nonnull
    public String description() {
        return String.format("This command allows for checking the consistency of a database or a backup thereof. It cannot be used with a database which is currently in use.%n%nAll checks except 'check-graph' can be quite expensive so it may be useful to turn them off for very large databases. Increasing the heap size can also be a good idea. See 'neo4j-admin help' for details.", new Object[0]);
    }

    @Nonnull
    public String summary() {
        return "Check the consistency of a database.";
    }

    @Nonnull
    public AdminCommandSection commandSection() {
        return AdminCommandSection.general();
    }

    @Nonnull
    public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        return new CheckConsistencyCommand(homeDir, configDir);
    }
}

