/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Arrays;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.OwningRecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public abstract class PrimitiveRecordCheck<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
implements OwningRecordCheck<RECORD, REPORT> {
    private final RecordField<RECORD, REPORT>[] fields;
    private final ComparativeRecordChecker<RECORD, PrimitiveRecord, REPORT> ownerCheck = (record, other, engine, records) -> {
        if (record.getId() == other.getId() && record.getClass() == other.getClass()) {
            return;
        }
        if (other instanceof NodeRecord) {
            ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).multipleOwners((NodeRecord)other);
        } else if (other instanceof RelationshipRecord) {
            ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).multipleOwners((RelationshipRecord)other);
        } else if (other instanceof NeoStoreRecord) {
            ((ConsistencyReport.PrimitiveConsistencyReport)engine.report()).multipleOwners((NeoStoreRecord)other);
        }
    };

    @SafeVarargs
    PrimitiveRecordCheck(RecordField<RECORD, REPORT> ... fields) {
        this.fields = Arrays.copyOf(fields, fields.length);
    }

    @Override
    public void check(RECORD record, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
        if (!record.inUse()) {
            return;
        }
        for (RecordField<RECORD, REPORT> field : this.fields) {
            field.checkConsistency(record, engine, records);
        }
    }

    @Override
    public ComparativeRecordChecker<RECORD, PrimitiveRecord, REPORT> ownerCheck() {
        return this.ownerCheck;
    }
}

