/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.NodeRecordCheck;
import org.neo4j.consistency.checking.RelationshipRecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.store.FilteringRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;

public enum MultiPassStore {
    NODES{

        @Override
        RecordStore<?> getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getNodeStore();
        }
    }
    ,
    RELATIONSHIPS{

        @Override
        RecordStore<?> getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getRelationshipStore();
        }
    }
    ,
    PROPERTIES{

        @Override
        RecordStore<?> getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getPropertyStore();
        }
    }
    ,
    PROPERTY_KEYS{

        @Override
        RecordStore<?> getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getPropertyKeyTokenStore();
        }
    }
    ,
    STRINGS{

        @Override
        RecordStore<?> getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getNodeStore();
        }
    }
    ,
    ARRAYS{

        @Override
        RecordStore<?> getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getNodeStore();
        }
    }
    ,
    LABELS{

        @Override
        RecordStore<?> getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getLabelTokenStore();
        }
    }
    ,
    RELATIONSHIP_GROUPS{

        @Override
        RecordStore<?> getRecordStore(StoreAccess storeAccess) {
            return storeAccess.getRelationshipGroupStore();
        }
    };


    public List<RecordAccess> multiPassFilters(RecordAccess recordAccess, MultiPassStore[] stores) {
        ArrayList<RecordAccess> filteringStores = new ArrayList<RecordAccess>();
        filteringStores.add(new FilteringRecordAccess(recordAccess, this, stores));
        return filteringStores;
    }

    public RecordAccess multiPassFilter(RecordAccess recordAccess, MultiPassStore ... stores) {
        return new FilteringRecordAccess(recordAccess, this, stores);
    }

    abstract RecordStore<?> getRecordStore(StoreAccess var1);

    static class Factory {
        private final CheckDecorator decorator;
        private final RecordAccess recordAccess;
        private final InconsistencyReport report;
        private final CacheAccess cacheAccess;
        private final ConsistencyReporter.Monitor monitor;

        Factory(CheckDecorator decorator, RecordAccess recordAccess, CacheAccess cacheAccess, InconsistencyReport report, ConsistencyReporter.Monitor monitor) {
            this.decorator = decorator;
            this.recordAccess = recordAccess;
            this.cacheAccess = cacheAccess;
            this.report = report;
            this.monitor = monitor;
        }

        ConsistencyReporter[] reporters(MultiPassStore ... stores) {
            ArrayList<ConsistencyReporter> result = new ArrayList<ConsistencyReporter>();
            for (MultiPassStore store : stores) {
                List<RecordAccess> filters = store.multiPassFilters(this.recordAccess, stores);
                for (RecordAccess filter : filters) {
                    result.add(new ConsistencyReporter(filter, this.report));
                }
            }
            return result.toArray(new ConsistencyReporter[0]);
        }

        ConsistencyReporter reporter(MultiPassStore store) {
            RecordAccess filter = store.multiPassFilter(this.recordAccess, store);
            return new ConsistencyReporter(filter, this.report, this.monitor);
        }

        StoreProcessor processor(Stage stage, MultiPassStore store) {
            return new StoreProcessor(this.decorator, this.reporter(store), stage, this.cacheAccess);
        }

        public void reDecorateNode(StoreProcessor processer, NodeRecordCheck newChecker, boolean sparseNode) {
            processer.reDecorateNode(this.decorator, newChecker, sparseNode);
        }

        public void reDecorateRelationship(StoreProcessor processer, RelationshipRecordCheck newChecker) {
            processer.reDecorateRelationship(this.decorator, newChecker);
        }
    }
}

