/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.IterableStore;
import org.neo4j.consistency.checking.full.QueueDistribution;
import org.neo4j.consistency.checking.full.RecordDistributor;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.full.RecordScanner;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

public class ParallelRecordScanner<RECORD>
extends RecordScanner<RECORD> {
    private final CacheAccess cacheAccess;
    private final QueueDistribution distribution;

    public ParallelRecordScanner(String name, Statistics statistics, int threads, BoundedIterable<RECORD> store, ProgressMonitorFactory.MultiPartBuilder builder, RecordProcessor<RECORD> processor, CacheAccess cacheAccess, QueueDistribution distribution, IterableStore ... warmUpStores) {
        super(name, statistics, threads, store, builder, processor, warmUpStores);
        this.cacheAccess = cacheAccess;
        this.distribution = distribution;
    }

    @Override
    protected void scan() {
        long recordsPerCPU = RecordDistributor.calculateRecordsPerCpu(this.store.maxCount(), this.numberOfThreads);
        this.cacheAccess.prepareForProcessingOfSingleStore(recordsPerCPU);
        QueueDistribution.QueueDistributor distributor = this.distribution.distributor(recordsPerCPU, this.numberOfThreads);
        RecordDistributor.distributeRecords(this.numberOfThreads, this.getClass().getSimpleName() + "-" + this.name, 1000, this.store.iterator(), this.progress, this.processor, distributor);
    }
}

