/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.newchecker.ParallelExecution;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.values.storable.ValueCategory;

class IndexSizes {
    private static final double SMALL_INDEX_FACTOR_THRESHOLD = 0.05;
    private final ParallelExecution execution;
    private final IndexAccessors indexAccessors;
    private final ConcurrentMap<IndexDescriptor, Long> nodeIndexSizes = new ConcurrentHashMap<IndexDescriptor, Long>();
    private final ConcurrentMap<IndexDescriptor, Long> relationshipIndexSizes = new ConcurrentHashMap<IndexDescriptor, Long>();
    private final long highNodeId;

    IndexSizes(ParallelExecution execution, IndexAccessors indexAccessors, long highNodeId) {
        this.execution = execution;
        this.indexAccessors = indexAccessors;
        this.highNodeId = highNodeId;
    }

    void initialize() throws Exception {
        this.calculateSizes(this.execution, this.indexAccessors, EntityType.NODE, this.nodeIndexSizes);
        this.calculateSizes(this.execution, this.indexAccessors, EntityType.RELATIONSHIP, this.relationshipIndexSizes);
    }

    private void calculateSizes(ParallelExecution execution, IndexAccessors indexAccessors, EntityType entityType, ConcurrentMap<IndexDescriptor, Long> indexSizes) throws Exception {
        List<IndexDescriptor> indexes = indexAccessors.onlineRules(entityType);
        execution.run("Estimate index sizes", (ParallelExecution.ThrowingRunnable[])indexes.stream().map(index -> () -> {
            IndexAccessor accessor = indexAccessors.accessorFor((IndexDescriptor)index);
            indexSizes.put((IndexDescriptor)index, accessor.estimateNumberOfEntries());
        }).toArray(ParallelExecution.ThrowingRunnable[]::new));
    }

    private List<IndexDescriptor> getAllIndexes(EntityType entityType) {
        return new ArrayList<IndexDescriptor>(this.indexAccessors.onlineRules(entityType));
    }

    List<IndexDescriptor> smallIndexes(EntityType entityType) {
        List<IndexDescriptor> smallIndexes = this.getAllIndexes(entityType);
        smallIndexes.removeAll(this.largeIndexes(entityType));
        return smallIndexes;
    }

    List<IndexDescriptor> largeIndexes(EntityType entityType) {
        List<IndexDescriptor> indexes = this.getAllIndexes(entityType);
        indexes.sort(Comparator.comparingLong(this::getEstimatedIndexSize).reversed());
        int threshold = 0;
        for (IndexDescriptor index : indexes) {
            if (!IndexSizes.hasValues(index) || !(this.getSizeFactor(index) > 0.05) && threshold % 5 == 0) continue;
            ++threshold;
        }
        return indexes.subList(0, threshold);
    }

    static boolean hasValues(IndexDescriptor index) {
        IndexCapability capabilities = index.getCapability();
        Object[] categories = new ValueCategory[index.schema().getPropertyIds().length];
        Arrays.fill(categories, ValueCategory.UNKNOWN);
        return capabilities.valueCapability((ValueCategory[])categories) == IndexValueCapability.YES && !index.schema().isFulltextSchemaDescriptor();
    }

    private double getSizeFactor(IndexDescriptor index) {
        return (double)this.getEstimatedIndexSize(index) / (double)this.highNodeId;
    }

    long getEstimatedIndexSize(IndexDescriptor index) {
        EntityType entityType = index.schema().entityType();
        ConcurrentMap<IndexDescriptor, Long> map = entityType == EntityType.NODE ? this.nodeIndexSizes : this.relationshipIndexSizes;
        return (Long)map.get(index);
    }
}

