/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.index;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.consistency.checking.full.IndexCheck;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.internal.schema.IndexDescriptor;

public class IndexEntryProcessor
extends RecordProcessor.Adapter<Long> {
    private final ConsistencyReporter reporter;
    private final IndexCheck indexCheck;
    private final IndexDescriptor indexDescriptor;
    private final TokenNameLookup tokenNameLookup;

    public IndexEntryProcessor(ConsistencyReporter reporter, IndexCheck indexCheck, IndexDescriptor indexDescriptor, TokenNameLookup tokenNameLookup) {
        this.reporter = reporter;
        this.indexCheck = indexCheck;
        this.indexDescriptor = indexDescriptor;
        this.tokenNameLookup = tokenNameLookup;
    }

    @Override
    public void process(Long nodeId) {
        this.reporter.forIndexEntry(new IndexEntry(this.indexDescriptor, this.tokenNameLookup, nodeId), this.indexCheck);
    }
}

