/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class PropertyReader
implements NodePropertyAccessor {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;

    PropertyReader(StoreAccess storeAccess) {
        this.propertyStore = storeAccess.getRawNeoStores().getPropertyStore();
        this.nodeStore = storeAccess.getRawNeoStores().getNodeStore();
    }

    Collection<PropertyRecord> getPropertyRecordChain(long firstPropertyRecordId, PageCursorTracer cursorTracer) throws CircularPropertyRecordChainException {
        ArrayList<PropertyRecord> records = new ArrayList<PropertyRecord>();
        this.visitPropertyRecordChain(firstPropertyRecordId, (Visitor<PropertyRecord, RuntimeException>)((Visitor)record -> {
            records.add((PropertyRecord)record);
            return false;
        }), cursorTracer);
        return records;
    }

    private boolean visitPropertyRecordChain(long firstPropertyRecordId, Visitor<PropertyRecord, RuntimeException> visitor, PageCursorTracer cursorTracer) throws CircularPropertyRecordChainException {
        if (Record.NO_NEXT_PROPERTY.is(firstPropertyRecordId)) {
            return false;
        }
        LongHashSet visitedPropertyRecordIds = new LongHashSet(8);
        visitedPropertyRecordIds.add(firstPropertyRecordId);
        long nextProp = firstPropertyRecordId;
        while (!Record.NO_NEXT_PROPERTY.is(nextProp)) {
            PropertyRecord propRecord = (PropertyRecord)this.propertyStore.getRecord(nextProp, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.FORCE, cursorTracer);
            if (!Record.NO_NEXT_PROPERTY.is(nextProp = propRecord.getNextProp()) && !visitedPropertyRecordIds.add(nextProp)) {
                throw new CircularPropertyRecordChainException(propRecord);
            }
            if (!visitor.visit((Object)propRecord)) continue;
            return true;
        }
        return false;
    }

    public Value propertyValue(PropertyBlock block, PageCursorTracer cursorTracer) {
        return block.getType().value(block, this.propertyStore, cursorTracer);
    }

    public Value getNodePropertyValue(long nodeId, int propertyKeyId, PageCursorTracer cursorTracer) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        if (((NodeRecord)this.nodeStore.getRecord(nodeId, (AbstractBaseRecord)nodeRecord, RecordLoad.FORCE, cursorTracer)).inUse()) {
            SpecificValueVisitor visitor = new SpecificValueVisitor(propertyKeyId, cursorTracer);
            try {
                if (this.visitPropertyRecordChain(nodeRecord.getNextProp(), visitor, cursorTracer)) {
                    return visitor.foundPropertyValue;
                }
            }
            catch (CircularPropertyRecordChainException circularPropertyRecordChainException) {
                // empty catch block
            }
        }
        return Values.NO_VALUE;
    }

    static class CircularPropertyRecordChainException
    extends Exception {
        private final PropertyRecord propertyRecord;

        CircularPropertyRecordChainException(PropertyRecord propertyRecord) {
            this.propertyRecord = propertyRecord;
        }

        PropertyRecord propertyRecordClosingTheCircle() {
            return this.propertyRecord;
        }
    }

    private class SpecificValueVisitor
    implements Visitor<PropertyRecord, RuntimeException> {
        private final int propertyKeyId;
        private final PageCursorTracer cursorTracer;
        private Value foundPropertyValue;

        SpecificValueVisitor(int propertyKeyId, PageCursorTracer cursorTracer) {
            this.propertyKeyId = propertyKeyId;
            this.cursorTracer = cursorTracer;
        }

        public boolean visit(PropertyRecord element) throws RuntimeException {
            for (PropertyBlock block : element) {
                if (block.getKeyIndexId() != this.propertyKeyId) continue;
                this.foundPropertyValue = PropertyReader.this.propertyValue(block, this.cursorTracer);
                return true;
            }
            return false;
        }
    }
}

