/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.report.InconsistencyLogger;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.logging.Log;

public class InconsistencyMessageLogger
implements InconsistencyLogger {
    private final Log log;

    public InconsistencyMessageLogger(Log log) {
        this.log = log;
    }

    @Override
    public void error(RecordType recordType, AbstractBaseRecord record, String message, Object ... args) {
        this.log.error(InconsistencyMessageLogger.buildMessage(message, record, args));
    }

    @Override
    public void error(RecordType recordType, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord, String message, Object ... args) {
        this.log.error(InconsistencyMessageLogger.buildMessage(message, oldRecord, newRecord, args));
    }

    @Override
    public void error(String message) {
        this.log.error(InconsistencyMessageLogger.buildMessage(message));
    }

    @Override
    public void warning(RecordType recordType, AbstractBaseRecord record, String message, Object ... args) {
        this.log.warn(InconsistencyMessageLogger.buildMessage(message, record, args));
    }

    @Override
    public void warning(RecordType recordType, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord, String message, Object ... args) {
        this.log.warn(InconsistencyMessageLogger.buildMessage(message, oldRecord, newRecord, args));
    }

    @Override
    public void warning(String message) {
        this.log.warn(InconsistencyMessageLogger.buildMessage(message));
    }

    private static String buildMessage(String message) {
        StringBuilder builder = InconsistencyMessageLogger.tabAfterLinebreak(message);
        return builder.toString();
    }

    private static String buildMessage(String message, AbstractBaseRecord record, Object[] args) {
        StringBuilder builder = InconsistencyMessageLogger.joinLines(message).append(System.lineSeparator()).append("\t").append(InconsistencyMessageLogger.safeToString(record));
        InconsistencyMessageLogger.appendArgs(builder, args);
        return builder.toString();
    }

    private static String safeToString(AbstractBaseRecord record) {
        try {
            return record.toString();
        }
        catch (Exception e) {
            return String.format("%s[%d,Error generating toString: %s]", record.getClass().getSimpleName(), record.getId(), e);
        }
    }

    private static String buildMessage(String message, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord, Object[] args) {
        StringBuilder builder = InconsistencyMessageLogger.joinLines(message);
        builder.append(System.lineSeparator()).append("\t").append("- ").append(oldRecord);
        builder.append(System.lineSeparator()).append("\t").append("+ ").append(newRecord);
        InconsistencyMessageLogger.appendArgs(builder, args);
        return builder.toString();
    }

    private static StringBuilder tabAfterLinebreak(String message) {
        String[] lines = message.split("\n");
        StringBuilder builder = new StringBuilder(lines[0].trim());
        for (int i = 1; i < lines.length; ++i) {
            builder.append(System.lineSeparator()).append("\t").append(lines[i].trim());
        }
        return builder;
    }

    private static StringBuilder joinLines(String message) {
        String[] lines = message.split("\n");
        StringBuilder builder = new StringBuilder(lines[0].trim());
        for (int i = 1; i < lines.length; ++i) {
            builder.append(' ').append(lines[i].trim());
        }
        return builder;
    }

    private static StringBuilder appendArgs(StringBuilder builder, Object[] args) {
        if (args == null || args.length == 0) {
            return builder;
        }
        builder.append(System.lineSeparator()).append("\t").append("Inconsistent with:");
        for (Object arg : args) {
            builder.append(' ').append(Strings.prettyPrint((Object)arg));
        }
        return builder;
    }
}

