/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.function.Predicate;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.CheckStage;
import org.neo4j.consistency.checking.full.ConsistencyCheckerTask;
import org.neo4j.consistency.checking.full.QueueDistribution;
import org.neo4j.consistency.checking.full.RecordDistributor;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class StoreProcessorTask<R extends AbstractBaseRecord>
extends ConsistencyCheckerTask {
    private final RecordStore<R> store;
    private final StoreProcessor processor;
    private final ProgressListener progressListener;
    private final StoreAccess storeAccess;
    private final CacheAccess cacheAccess;
    private final QueueDistribution distribution;
    private final PageCacheTracer pageCacheTracer;

    StoreProcessorTask(String name, Statistics statistics, int threads, RecordStore<R> store, StoreAccess storeAccess, String builderPrefix, ProgressMonitorFactory.MultiPartBuilder builder, CacheAccess cacheAccess, StoreProcessor processor, QueueDistribution distribution, PageCacheTracer pageCacheTracer) {
        super(name, statistics, threads);
        this.store = store;
        this.storeAccess = storeAccess;
        this.cacheAccess = cacheAccess;
        this.processor = processor;
        this.distribution = distribution;
        this.pageCacheTracer = pageCacheTracer;
        this.progressListener = builder.progressForPart(name + this.indexedPartName(store.getStorageFile().getName(), builderPrefix), store.getHighId());
    }

    private String indexedPartName(String storeFileName, String prefix) {
        return prefix.isEmpty() ? String.format("%s_pass_%s", storeFileName, prefix) : "_";
    }

    @Override
    public void run() {
        this.statistics.reset();
        this.beforeProcessing(this.processor);
        try {
            if (this.processor.getStage().getCacheSlotSizes().length > 0) {
                this.cacheAccess.setCacheSlotSizes(this.processor.getStage().getCacheSlotSizes());
            }
            this.cacheAccess.setForward(this.processor.getStage().isForward());
            if (this.processor.getStage().isParallel()) {
                long highId = this.processor.getStage() == CheckStage.Stage1_NS_PropsLabels ? this.storeAccess.getNodeStore().getHighId() : (this.processor.getStage() == CheckStage.Stage8_PS_Props ? this.storeAccess.getPropertyStore().getHighId() : this.storeAccess.getNodeStore().getHighId());
                long recordsPerCPU = RecordDistributor.calculateRecordsPerCpu(highId, this.numberOfThreads);
                QueueDistribution.QueueDistributor distributor = this.distribution.distributor(recordsPerCPU, this.numberOfThreads);
                this.processor.applyFilteredParallel(this.store, this.progressListener, this.numberOfThreads, recordsPerCPU, distributor, this.pageCacheTracer);
            } else {
                this.processor.applyFiltered(this.store, this.progressListener, this.pageCacheTracer, new Predicate[0]);
            }
            this.cacheAccess.setForward(true);
        }
        catch (Throwable e) {
            this.progressListener.failed(e);
            throw new RuntimeException(e);
        }
        finally {
            this.afterProcessing(this.processor);
        }
        this.statistics.print(this.name);
    }

    protected void beforeProcessing(StoreProcessor processor) {
    }

    protected void afterProcessing(StoreProcessor processor) {
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + " @ " + this.processor.getStage() + ", " + this.store + ":" + this.store.getHighId() + "]";
    }
}

