/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutablePrimitiveObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.RecordReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.function.ThrowingIntFunction;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class RecordLoading {
    static final BiConsumer<Long, DynamicRecord> NO_DYNAMIC_HANDLER = (id, r) -> {};
    private final NeoStores neoStores;

    RecordLoading(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    static long[] safeGetNodeLabels(CheckerContext context, long nodeId, long labelField, RecordReader<DynamicRecord> labelReader, PageCursorTracer cursorTracer) {
        if (!NodeLabelsField.fieldPointsToDynamicRecordOfLabels((long)labelField)) {
            return InlineNodeLabels.parseInlined((long)labelField);
        }
        ArrayList records = new ArrayList();
        LongHashSet seenRecordIds = new LongHashSet();
        ConsistencyReport.Reporter reporter = context.reporter;
        RecordLoading recordLoader = context.recordLoader;
        int nodeLabelBlockSize = context.neoStores.getNodeStore().getDynamicLabelStore().getRecordDataSize();
        if (RecordLoading.safeLoadDynamicRecordChain(record -> records.add(record.copy()), labelReader, (MutableLongSet)seenRecordIds, NodeLabelsField.firstDynamicLabelRecordId((long)labelField), nodeLabelBlockSize, (id, labelRecord) -> reporter.forNode(recordLoader.node(nodeId, cursorTracer)).dynamicRecordChainCycle((DynamicRecord)labelRecord), (id, labelRecord) -> reporter.forNode(recordLoader.node(nodeId, cursorTracer)).dynamicLabelRecordNotInUse((DynamicRecord)labelRecord), (id, labelRecord) -> reporter.forNode(recordLoader.node(nodeId, cursorTracer)).dynamicLabelRecordNotInUse((DynamicRecord)labelRecord), (id, labelRecord) -> reporter.forDynamicBlock(RecordType.NODE_DYNAMIC_LABEL, (DynamicRecord)labelRecord).emptyBlock(), labelRecord -> reporter.forDynamicBlock(RecordType.NODE_DYNAMIC_LABEL, (DynamicRecord)labelRecord).recordNotFullReferencesNext(), labelRecord -> reporter.forDynamicBlock(RecordType.NODE_DYNAMIC_LABEL, (DynamicRecord)labelRecord).invalidLength())) {
            return DynamicNodeLabels.getDynamicLabelsArray(records, (AbstractDynamicStore)((AbstractDynamicStore)labelReader.store()), (PageCursorTracer)cursorTracer);
        }
        return null;
    }

    private static Value[] matchAllProperties(IntObjectMap<Value> values, int[] propertyKeyIds) {
        Value[] array = new Value[propertyKeyIds.length];
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            int propertyKeyId = propertyKeyIds[i];
            Value value = (Value)values.get(propertyKeyId);
            if (value == null) {
                return null;
            }
            array[i] = value;
        }
        return array;
    }

    private static Value[] matchAnyProperty(IntObjectMap<Value> values, int[] propertyKeyIds) {
        Value[] array = new Value[propertyKeyIds.length];
        boolean anyFound = false;
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            Value value = (Value)values.get(propertyKeyIds[i]);
            if (value != null) {
                anyFound = true;
            } else {
                value = Values.NO_VALUE;
            }
            array[i] = value;
        }
        return anyFound ? array : null;
    }

    static Value[] entityIntersectionWithSchema(long[] entityTokens, IntObjectMap<Value> values, SchemaDescriptor schema) {
        Value[] valueArray = null;
        if (schema.isAffected(entityTokens)) {
            boolean requireAllTokens = schema.propertySchemaType() == PropertySchemaType.COMPLETE_ALL_TOKENS;
            valueArray = requireAllTokens ? RecordLoading.matchAllProperties(values, schema.getPropertyIds()) : RecordLoading.matchAnyProperty(values, schema.getPropertyIds());
        }
        return valueArray;
    }

    NodeRecord node(long id, PageCursorTracer cursorTracer) {
        return (NodeRecord)this.loadRecord((RecordStore)this.neoStores.getNodeStore(), id, cursorTracer);
    }

    PropertyRecord property(long id, PageCursorTracer cursorTracer) {
        return (PropertyRecord)this.loadRecord((RecordStore)this.neoStores.getPropertyStore(), id, cursorTracer);
    }

    RelationshipRecord relationship(long id, PageCursorTracer cursorTracer) {
        return (RelationshipRecord)this.loadRecord((RecordStore)this.neoStores.getRelationshipStore(), id, cursorTracer);
    }

    RelationshipRecord relationship(RelationshipRecord into, long id, PageCursorTracer cursorTracer) {
        return this.loadRecord((RecordStore)this.neoStores.getRelationshipStore(), (AbstractBaseRecord)into, id, cursorTracer);
    }

    RelationshipGroupRecord relationshipGroup(long id, PageCursorTracer cursorTracer) {
        return (RelationshipGroupRecord)this.loadRecord((RecordStore)this.neoStores.getRelationshipGroupStore(), id, cursorTracer);
    }

    <RECORD extends AbstractBaseRecord> RECORD loadRecord(RecordStore<RECORD> store, long id, PageCursorTracer cursorTracer) {
        return (RECORD)this.loadRecord(store, store.newRecord(), id, cursorTracer);
    }

    <RECORD extends AbstractBaseRecord> RECORD loadRecord(RecordStore<RECORD> store, RECORD record, long id, PageCursorTracer cursorTracer) {
        return (RECORD)store.getRecord(id, record, RecordLoad.FORCE, cursorTracer);
    }

    static <RECORD extends TokenRecord> List<NamedToken> safeLoadTokens(TokenStore<RECORD> tokenStore, PageCursorTracer cursorTracer) {
        long highId = tokenStore.getHighId();
        ArrayList<NamedToken> tokens = new ArrayList<NamedToken>();
        DynamicStringStore nameStore = tokenStore.getNameStore();
        ArrayList nameRecords = new ArrayList();
        LongHashSet seenRecordIds = new LongHashSet();
        int nameBlockSize = nameStore.getRecordDataSize();
        try (RecordReader tokenReader = new RecordReader(tokenStore, cursorTracer);
             RecordReader<DynamicRecord> nameReader = new RecordReader<DynamicRecord>((CommonAbstractStore<DynamicRecord, ?>)nameStore, cursorTracer);){
            for (long id = 0L; id < highId; ++id) {
                String name;
                TokenRecord record = (TokenRecord)tokenReader.read(id);
                nameRecords.clear();
                if (!record.inUse()) continue;
                if (!Record.NULL_REFERENCE.is((long)record.getNameId()) && RecordLoading.safeLoadDynamicRecordChain(r -> nameRecords.add(r.copy()), nameReader, (MutableLongSet)seenRecordIds, record.getNameId(), nameBlockSize)) {
                    record.addNameRecords(nameRecords);
                    name = tokenStore.getStringFor(record, cursorTracer);
                } else {
                    name = String.format("<name not loaded due to token(%d) referencing unused name record>", id);
                }
                tokens.add(new NamedToken(name, Math.toIntExact(id), record.isInternal()));
            }
        }
        return tokens;
    }

    static boolean safeLoadDynamicRecordChain(Consumer<DynamicRecord> target, RecordReader<DynamicRecord> reader, MutableLongSet seenRecordIds, long recordId, int blockSize) {
        return RecordLoading.safeLoadDynamicRecordChain(target, reader, seenRecordIds, recordId, blockSize, NO_DYNAMIC_HANDLER, NO_DYNAMIC_HANDLER, NO_DYNAMIC_HANDLER, NO_DYNAMIC_HANDLER, r -> {}, r -> {});
    }

    static boolean safeLoadDynamicRecordChain(Consumer<DynamicRecord> target, RecordReader<DynamicRecord> reader, MutableLongSet seenRecordIds, long recordId, int blockSize, BiConsumer<Long, DynamicRecord> circularReferenceReport, BiConsumer<Long, DynamicRecord> unusedChainReport, BiConsumer<Long, DynamicRecord> brokenChainReport, BiConsumer<Long, DynamicRecord> emptyRecordReport, Consumer<DynamicRecord> notFullReferencesNextReport, Consumer<DynamicRecord> invalidLengthReport) {
        long firstRecordId = recordId;
        RecordLoading.lightClear((MutableLongCollection)seenRecordIds);
        long prevRecordId = Record.NULL_REFERENCE.longValue();
        boolean chainIsOk = true;
        while (!Record.NULL_REFERENCE.is(recordId)) {
            if (!seenRecordIds.add(recordId)) {
                circularReferenceReport.accept(firstRecordId, reader.record());
                return false;
            }
            DynamicRecord record = reader.read(recordId);
            if (!record.inUse()) {
                BiConsumer<Long, DynamicRecord> reporter = recordId == firstRecordId ? unusedChainReport : brokenChainReport;
                reporter.accept(prevRecordId, record);
                return false;
            }
            if (record.getLength() == 0) {
                emptyRecordReport.accept(firstRecordId, record);
                chainIsOk = false;
            }
            if (record.getLength() < blockSize && !Record.NULL_REFERENCE.is(record.getNextBlock())) {
                notFullReferencesNextReport.accept(record);
                chainIsOk = false;
            }
            if (record.getLength() > blockSize) {
                invalidLengthReport.accept(record);
                chainIsOk = false;
            }
            target.accept(record);
            prevRecordId = recordId;
            recordId = record.getNextBlock();
        }
        return chainIsOk;
    }

    static <RECORD extends AbstractBaseRecord, TOKEN extends TokenRecord> boolean checkValidInternalToken(RECORD entity, int token, TokenHolder tokens, TokenStore<TOKEN> tokenStore, BiConsumer<RECORD, Integer> illegalTokenReport, BiConsumer<RECORD, TOKEN> unusedReporter, PageCursorTracer cursorTracer) {
        return RecordLoading.checkValidToken(entity, token, tokens, tokenStore, illegalTokenReport, unusedReporter, (ThrowingIntFunction<NamedToken, TokenNotFoundException>)((ThrowingIntFunction)arg_0 -> ((TokenHolder)tokens).getInternalTokenById(arg_0)), cursorTracer);
    }

    static <RECORD extends AbstractBaseRecord, TOKEN extends TokenRecord> boolean checkValidToken(RECORD entity, int token, TokenHolder tokens, TokenStore<TOKEN> tokenStore, BiConsumer<RECORD, Integer> illegalTokenReport, BiConsumer<RECORD, TOKEN> unusedReporter, PageCursorTracer cursorTracer) {
        return RecordLoading.checkValidToken(entity, token, tokens, tokenStore, illegalTokenReport, unusedReporter, (ThrowingIntFunction<NamedToken, TokenNotFoundException>)((ThrowingIntFunction)arg_0 -> ((TokenHolder)tokens).getTokenById(arg_0)), cursorTracer);
    }

    private static <RECORD extends AbstractBaseRecord, TOKEN extends TokenRecord> boolean checkValidToken(RECORD entity, int token, TokenHolder tokens, TokenStore<TOKEN> tokenStore, BiConsumer<RECORD, Integer> illegalTokenReport, BiConsumer<RECORD, TOKEN> unusedReporter, ThrowingIntFunction<NamedToken, TokenNotFoundException> tokenGetter, PageCursorTracer cursorTracer) {
        if (token < 0) {
            illegalTokenReport.accept(entity, token);
            return false;
        }
        try {
            tokens.getTokenById(token);
        }
        catch (TokenNotFoundException tnfe) {
            TokenRecord tokenRecord = (TokenRecord)tokenStore.getRecord((long)token, (AbstractBaseRecord)((TokenRecord)tokenStore.newRecord()), RecordLoad.FORCE, cursorTracer);
            unusedReporter.accept(entity, tokenRecord);
            return false;
        }
        return true;
    }

    static void lightClear(MutableLongCollection collection) {
        if (!collection.isEmpty()) {
            collection.clear();
        }
    }

    static void lightClear(MutableIntCollection collection) {
        if (!collection.isEmpty()) {
            collection.clear();
        }
    }

    static void lightClear(MutablePrimitiveObjectMap<?> collection) {
        if (!collection.isEmpty()) {
            collection.clear();
        }
    }
}

