/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

class RecordReader<RECORD extends AbstractBaseRecord>
implements AutoCloseable {
    private final CommonAbstractStore<RECORD, ?> store;
    private final RECORD record;
    private final PageCursor cursor;

    RecordReader(CommonAbstractStore<RECORD, ?> store, PageCursorTracer cursorTracer) {
        this.store = store;
        this.record = store.newRecord();
        this.cursor = store.openPageCursorForReading(0L, cursorTracer);
    }

    RECORD read(long id) {
        this.store.getRecordByCursor(id, this.record, RecordLoad.FORCE, this.cursor);
        return this.record;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    RECORD record() {
        return this.record;
    }

    <STORE> STORE store() {
        return (STORE)this.store;
    }
}

