/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class DynamicRecordCheck
implements RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport>,
ComparativeRecordChecker<DynamicRecord, DynamicRecord, ConsistencyReport.DynamicConsistencyReport> {
    private final int blockSize;
    private final DynamicStore dereference;

    public DynamicRecordCheck(RecordStore<DynamicRecord> store, DynamicStore dereference) {
        this.blockSize = store.getRecordDataSize();
        this.dereference = dereference;
    }

    @Override
    public void check(DynamicRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        if (!record.inUse()) {
            return;
        }
        if (record.getLength() == 0) {
            engine.report().emptyBlock();
        }
        if (!Record.NO_NEXT_BLOCK.is(record.getNextBlock())) {
            if (record.getNextBlock() == record.getId()) {
                engine.report().circularReferenceNext(record);
            } else {
                engine.comparativeCheck(this.dereference.lookup(records, record.getNextBlock(), cursorTracer), this);
            }
            if (record.getLength() < this.blockSize) {
                engine.report().recordNotFullReferencesNext();
            }
        }
    }

    @Override
    public void checkReference(DynamicRecord record, DynamicRecord next, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        if (!next.inUse()) {
            engine.report().nextNotInUse(next);
        } else if (next.getLength() <= 0) {
            engine.report().emptyNextBlock(next);
        }
    }
}

