/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Arrays;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.LabelChainWalker;
import org.neo4j.consistency.checking.NodeField;
import org.neo4j.consistency.checking.PrimitiveRecordCheck;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class NodeRecordCheck
extends PrimitiveRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
    @SafeVarargs
    static NodeRecordCheck forSparseNodes(RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport> ... additional) {
        Object[] basic = (RecordField[])ArrayUtil.array((Object[])new RecordField[]{LabelsField.LABELS});
        return new NodeRecordCheck((RecordField[])ArrayUtil.union((Object[])basic, (Object[])additional));
    }

    @SafeVarargs
    static NodeRecordCheck forDenseNodes(RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport> ... additional) {
        Object[] basic = (RecordField[])ArrayUtil.array((Object[])new RecordField[]{RelationshipGroupField.NEXT_GROUP, LabelsField.LABELS});
        return new NodeRecordCheck((RecordField[])ArrayUtil.union((Object[])basic, (Object[])additional));
    }

    public static NodeRecordCheck toCheckNextRel() {
        return new NodeRecordCheck(new RecordField[]{RelationshipField.NEXT_REL});
    }

    public static NodeRecordCheck toCheckNextRelationshipGroup() {
        return new NodeRecordCheck(new RecordField[]{RelationshipGroupField.NEXT_GROUP});
    }

    @SafeVarargs
    NodeRecordCheck(RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport> ... fields) {
        super(fields);
    }

    public NodeRecordCheck() {
        this(new RecordField[]{RelationshipField.NEXT_REL, LabelsField.LABELS});
    }

    static enum LabelsField implements RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport>,
    ComparativeRecordChecker<NodeRecord, LabelTokenRecord, ConsistencyReport.NodeConsistencyReport>
    {
        LABELS{

            @Override
            public void checkConsistency(NodeRecord node, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
                NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
                if (nodeLabels instanceof DynamicNodeLabels) {
                    DynamicNodeLabels dynamicNodeLabels = (DynamicNodeLabels)nodeLabels;
                    long firstRecordId = dynamicNodeLabels.getFirstDynamicRecordId();
                    RecordReference<DynamicRecord> firstRecordReference = records.nodeLabels(firstRecordId, cursorTracer);
                    engine.comparativeCheck(firstRecordReference, new LabelChainWalker<NodeRecord, ConsistencyReport.NodeConsistencyReport>(new NodeLabelsComparativeRecordChecker()));
                } else {
                    this.validateLabelIds(nodeLabels.get(null, cursorTracer), engine, records, cursorTracer);
                }
            }

            private void validateLabelIds(long[] labelIds, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
                int i;
                for (long labelId : labelIds) {
                    engine.comparativeCheck(records.label((int)labelId, cursorTracer), this);
                }
                boolean outOfOrder = false;
                for (i = 1; i < labelIds.length; ++i) {
                    if (labelIds[i - 1] <= labelIds[i]) continue;
                    engine.report().labelsOutOfOrder(labelIds[i - 1], labelIds[i]);
                    outOfOrder = true;
                }
                if (outOfOrder) {
                    Arrays.sort(labelIds);
                }
                for (i = 1; i < labelIds.length; ++i) {
                    if (labelIds[i - 1] != labelIds[i]) continue;
                    engine.report().labelDuplicate(labelIds[i]);
                }
            }

            @Override
            public void checkReference(NodeRecord node, LabelTokenRecord labelTokenRecord, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
                if (!labelTokenRecord.inUse()) {
                    engine.report().labelNotInUse(labelTokenRecord);
                }
            }

            @Override
            public long valueFrom(NodeRecord record) {
                return record.getLabelField();
            }

            class NodeLabelsComparativeRecordChecker
            implements LabelChainWalker.Validator<NodeRecord, ConsistencyReport.NodeConsistencyReport> {
                NodeLabelsComparativeRecordChecker() {
                }

                @Override
                public void onRecordNotInUse(DynamicRecord dynamicRecord, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine) {
                    engine.report().dynamicLabelRecordNotInUse(dynamicRecord);
                }

                @Override
                public void onRecordChainCycle(DynamicRecord record, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine) {
                    engine.report().dynamicRecordChainCycle(record);
                }

                @Override
                public void onWellFormedChain(long[] labelIds, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
                    this.validateLabelIds(labelIds, engine, records, cursorTracer);
                }
            }
        };

    }

    static enum RelationshipField implements RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport>,
    ComparativeRecordChecker<NodeRecord, RelationshipRecord, ConsistencyReport.NodeConsistencyReport>
    {
        NEXT_REL{

            @Override
            public void checkConsistency(NodeRecord node, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
                if (!Record.NO_NEXT_RELATIONSHIP.is(node.getNextRel())) {
                    engine.comparativeCheck(records.relationship(node.getNextRel(), cursorTracer), this);
                }
            }

            @Override
            public void checkReference(NodeRecord node, RelationshipRecord relationship, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
                if (!relationship.inUse()) {
                    engine.report().relationshipNotInUse(relationship);
                } else {
                    NodeField selectedField = NodeField.select(relationship, node);
                    if (selectedField == null) {
                        engine.report().relationshipForOtherNode(relationship);
                    } else {
                        NodeField[] fields = relationship.getFirstNode() == relationship.getSecondNode() ? NodeField.values() : new NodeField[]{selectedField};
                        for (NodeField field : fields) {
                            if (field.isFirst(relationship)) continue;
                            field.notFirstInChain(engine.report(), relationship);
                        }
                    }
                }
            }

            @Override
            public long valueFrom(NodeRecord record) {
                return record.getNextRel();
            }
        };

    }

    static enum RelationshipGroupField implements RecordField<NodeRecord, ConsistencyReport.NodeConsistencyReport>,
    ComparativeRecordChecker<NodeRecord, RelationshipGroupRecord, ConsistencyReport.NodeConsistencyReport>
    {
        NEXT_GROUP{

            @Override
            public void checkConsistency(NodeRecord node, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
                if (!Record.NO_NEXT_RELATIONSHIP.is(node.getNextRel())) {
                    engine.comparativeCheck(records.relationshipGroup(node.getNextRel(), cursorTracer), this);
                }
            }

            @Override
            public long valueFrom(NodeRecord node) {
                return node.getNextRel();
            }

            @Override
            public void checkReference(NodeRecord record, RelationshipGroupRecord group, CheckerEngine<NodeRecord, ConsistencyReport.NodeConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
                if (!group.inUse()) {
                    engine.report().relationshipGroupNotInUse(group);
                } else if (group.getOwningNode() != record.getId()) {
                    engine.report().relationshipGroupHasOtherOwner(group);
                }
            }
        };

    }
}

