/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class RelationshipInUseWithCorrectRelationshipTypeCheck<RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport.RelationshipInUseWithCorrectRelationshipTypeReport>
implements ComparativeRecordChecker<RECORD, RelationshipRecord, REPORT> {
    private final PropertySchemaType propertySchemaType;
    private final long[] indexRelationshipTypes;
    private final boolean checkStoreToIndex;

    public RelationshipInUseWithCorrectRelationshipTypeCheck(long[] expectedEntityTokenIds, PropertySchemaType propertySchemaType, boolean checkStoreToIndex) {
        this.propertySchemaType = propertySchemaType;
        this.checkStoreToIndex = checkStoreToIndex;
        this.indexRelationshipTypes = NodeInUseWithCorrectLabelsCheck.sortAndDeduplicate(expectedEntityTokenIds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkReference(RECORD record, RelationshipRecord relationshipRecord, CheckerEngine<RECORD, REPORT> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        if (relationshipRecord.inUse()) {
            if (this.propertySchemaType == PropertySchemaType.PARTIAL_ANY_TOKEN) {
                long type = relationshipRecord.getType();
                if (Arrays.binarySearch(this.indexRelationshipTypes, type) >= 0) return;
                for (long indexRelationshipType : this.indexRelationshipTypes) {
                    ((ConsistencyReport.RelationshipInUseWithCorrectRelationshipTypeReport)engine.report()).relationshipDoesNotHaveExpectedRelationshipType(relationshipRecord, indexRelationshipType);
                }
                return;
            } else {
                if (this.propertySchemaType != PropertySchemaType.COMPLETE_ALL_TOKENS) throw new IllegalStateException("Unknown property schema type '" + this.propertySchemaType + "'.");
                long storeType = relationshipRecord.getType();
                boolean foundType = false;
                for (long indexRelationshipType : this.indexRelationshipTypes) {
                    if (indexRelationshipType == storeType) {
                        foundType = true;
                        continue;
                    }
                    ((ConsistencyReport.RelationshipInUseWithCorrectRelationshipTypeReport)engine.report()).relationshipDoesNotHaveExpectedRelationshipType(relationshipRecord, indexRelationshipType);
                }
                if (foundType) return;
                this.reportRelationshipTypeNotInIndex((ConsistencyReport.RelationshipInUseWithCorrectRelationshipTypeReport)engine.report(), relationshipRecord, storeType);
            }
            return;
        } else {
            if (this.indexRelationshipTypes.length == 0) return;
            ((ConsistencyReport.RelationshipInUseWithCorrectRelationshipTypeReport)engine.report()).relationshipNotInUse(relationshipRecord);
        }
    }

    private void reportRelationshipTypeNotInIndex(REPORT report, RelationshipRecord relationshipRecord, long storeType) {
        if (this.checkStoreToIndex) {
            report.relationshipTypeNotInIndex(relationshipRecord, storeType);
        }
    }
}

