/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.statistics;

import java.util.concurrent.TimeUnit;
import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.internal.helpers.Format;
import org.neo4j.io.ByteUnit;
import org.neo4j.logging.Log;
import org.neo4j.time.Stopwatch;

public class VerboseStatistics
implements Statistics {
    private final AccessStatistics accessStatistics;
    private final Counts counts;
    private final Log logger;
    private Stopwatch startTime;

    public VerboseStatistics(AccessStatistics accessStatistics, Counts counts, Log logger) {
        this.accessStatistics = accessStatistics;
        this.counts = counts;
        this.logger = logger;
    }

    @Override
    public void print(String name) {
        String accessStr = this.accessStatistics.getAccessStatSummary();
        this.logger.info(String.format("=== %s ===", name));
        this.logger.info(String.format("I/Os%n%s", accessStr));
        this.logger.info(this.counts.toString());
        this.logger.info(VerboseStatistics.memoryStats());
        this.logger.info("Done in  " + Format.duration((long)this.startTime.elapsed(TimeUnit.MILLISECONDS)));
    }

    @Override
    public void reset() {
        this.accessStatistics.reset();
        this.counts.reset();
        this.startTime = Stopwatch.start();
    }

    private static String memoryStats() {
        Runtime runtime = Runtime.getRuntime();
        return String.format("Memory[used:%s, free:%s, total:%s, max:%s]", ByteUnit.bytesToString((long)(runtime.totalMemory() - runtime.freeMemory())), ByteUnit.bytesToString((long)runtime.freeMemory()), ByteUnit.bytesToString((long)runtime.totalMemory()), ByteUnit.bytesToString((long)runtime.maxMemory()));
    }

    @Override
    public Counts getCounts() {
        return this.counts;
    }
}

