/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.common.EntityType;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.NodeInUseWithCorrectLabelsCheck;
import org.neo4j.consistency.checking.full.RelationshipInUseWithCorrectRelationshipTypeCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class IndexCheck
implements RecordCheck<IndexEntry, ConsistencyReport.IndexConsistencyReport> {
    private final EntityType entityType;
    private final IndexDescriptor indexRule;
    private NodeInUseWithCorrectLabelsCheck<IndexEntry, ConsistencyReport.IndexConsistencyReport> nodeChecker;
    private RelationshipInUseWithCorrectRelationshipTypeCheck<IndexEntry, ConsistencyReport.IndexConsistencyReport> relationshipChecker;

    IndexCheck(IndexDescriptor indexRule) {
        this.indexRule = indexRule;
        SchemaDescriptor schema = indexRule.schema();
        int[] entityTokenIntIds = schema.getEntityTokenIds();
        long[] entityTokenLongIds = new long[entityTokenIntIds.length];
        for (int i = 0; i < entityTokenIntIds.length; ++i) {
            entityTokenLongIds[i] = entityTokenIntIds[i];
        }
        PropertySchemaType propertySchemaType = schema.propertySchemaType();
        this.entityType = schema.entityType();
        if (this.entityType == EntityType.NODE) {
            this.nodeChecker = new NodeInUseWithCorrectLabelsCheck(entityTokenLongIds, propertySchemaType, false);
        }
        if (this.entityType == EntityType.RELATIONSHIP) {
            this.relationshipChecker = new RelationshipInUseWithCorrectRelationshipTypeCheck(entityTokenLongIds, propertySchemaType, false);
        }
    }

    @Override
    public void check(IndexEntry record, CheckerEngine<IndexEntry, ConsistencyReport.IndexConsistencyReport> engine, RecordAccess records, PageCursorTracer cursorTracer) {
        long id = record.getId();
        switch (this.entityType) {
            case NODE: {
                engine.comparativeCheck(records.node(id, cursorTracer), this.nodeChecker);
                break;
            }
            case RELATIONSHIP: {
                if (this.indexRule.isUnique()) {
                    engine.report().relationshipConstraintIndex();
                }
                engine.comparativeCheck(records.relationship(id, cursorTracer), this.relationshipChecker);
                break;
            }
            default: {
                throw new IllegalStateException("Don't know how to check index entry of entity type " + this.entityType);
            }
        }
    }
}

