/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.RecordLoading;
import org.neo4j.consistency.newchecker.RecordReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SafePropertyChainReader
implements AutoCloseable {
    private final int stringStoreBlockSize;
    private final int arrayStoreBlockSize;
    private final PropertyStore propertyStore;
    private final RecordReader<PropertyRecord> propertyReader;
    private final RecordReader<DynamicRecord> stringReader;
    private final RecordReader<DynamicRecord> arrayReader;
    private final MutableLongSet seenRecords;
    private final MutableLongSet seenDynamicRecordIds;
    private final List<DynamicRecord> dynamicRecords;
    private final ConsistencyReport.Reporter reporter;
    private final CheckerContext context;
    private final NeoStores neoStores;

    SafePropertyChainReader(CheckerContext context, PageCursorTracer cursorTracer) {
        this.context = context;
        this.neoStores = context.neoStores;
        this.reporter = context.reporter;
        this.stringStoreBlockSize = this.neoStores.getPropertyStore().getStringStore().getRecordDataSize();
        this.arrayStoreBlockSize = this.neoStores.getPropertyStore().getArrayStore().getRecordDataSize();
        this.propertyStore = this.neoStores.getPropertyStore();
        this.propertyReader = new RecordReader(this.neoStores.getPropertyStore(), cursorTracer);
        this.stringReader = new RecordReader(this.neoStores.getPropertyStore().getStringStore(), cursorTracer);
        this.arrayReader = new RecordReader(this.neoStores.getPropertyStore().getArrayStore(), cursorTracer);
        this.seenRecords = new LongHashSet();
        this.seenDynamicRecordIds = new LongHashSet();
        this.dynamicRecords = new ArrayList<DynamicRecord>();
    }

    <PRIMITIVE extends PrimitiveRecord> boolean read(MutableIntObjectMap<Value> intoValues, PRIMITIVE entity, Function<PRIMITIVE, ConsistencyReport.PrimitiveConsistencyReport> primitiveReporter, PageCursorTracer cursorTracer) {
        RecordLoading.lightClear((MutableLongCollection)this.seenRecords);
        long propertyRecordId = entity.getNextProp();
        long previousRecordId = Record.NULL_REFERENCE.longValue();
        boolean chainIsOk = true;
        while (!Record.NULL_REFERENCE.is(propertyRecordId) && !this.context.isCancelled()) {
            if (!this.seenRecords.add(propertyRecordId)) {
                primitiveReporter.apply(entity).propertyChainContainsCircularReference(this.propertyReader.record());
                chainIsOk = false;
                break;
            }
            PropertyRecord propertyRecord = this.propertyReader.read(propertyRecordId);
            if (!propertyRecord.inUse()) {
                primitiveReporter.apply(entity).propertyNotInUse(propertyRecord);
                this.reporter.forProperty(this.context.recordLoader.property(previousRecordId, cursorTracer)).nextNotInUse(propertyRecord);
                chainIsOk = false;
            } else {
                if (propertyRecord.getPrevProp() != previousRecordId) {
                    if (Record.NULL_REFERENCE.is(previousRecordId)) {
                        primitiveReporter.apply(entity).propertyNotFirstInChain(propertyRecord);
                    } else {
                        this.reporter.forProperty(this.context.recordLoader.property(previousRecordId, cursorTracer)).nextDoesNotReferenceBack(propertyRecord);
                    }
                    chainIsOk = false;
                }
                for (PropertyBlock block : propertyRecord) {
                    int propertyKeyId = block.getKeyIndexId();
                    if (!RecordLoading.checkValidToken(propertyRecord, propertyKeyId, this.context.tokenHolders.propertyKeyTokens(), this.neoStores.getPropertyKeyTokenStore(), (property, token) -> this.reporter.forProperty((PropertyRecord)property).invalidPropertyKey(block), (property, token) -> this.reporter.forProperty((PropertyRecord)property).keyNotInUse(block, (PropertyKeyTokenRecord)token), cursorTracer)) {
                        chainIsOk = false;
                    }
                    PropertyType type = block.forceGetType();
                    Value value = Values.NO_VALUE;
                    if (type == null) {
                        this.reporter.forProperty(propertyRecord).invalidPropertyType(block);
                    } else {
                        try {
                            switch (type) {
                                case STRING: {
                                    this.dynamicRecords.clear();
                                    if (RecordLoading.safeLoadDynamicRecordChain(record -> this.dynamicRecords.add(record.copy()), this.stringReader, this.seenDynamicRecordIds, block.getSingleValueLong(), this.stringStoreBlockSize, RecordLoading.NO_DYNAMIC_HANDLER, (id, record) -> this.reporter.forProperty(propertyRecord).stringNotInUse(block, (DynamicRecord)record), (id, record) -> this.reporter.forDynamicBlock(RecordType.STRING_PROPERTY, this.stringReader.record()).nextNotInUse((DynamicRecord)record), (id, record) -> this.reporter.forProperty(propertyRecord).stringEmpty(block, (DynamicRecord)record), record -> this.reporter.forDynamicBlock(RecordType.STRING_PROPERTY, (DynamicRecord)record).recordNotFullReferencesNext(), record -> this.reporter.forDynamicBlock(RecordType.STRING_PROPERTY, (DynamicRecord)record).invalidLength())) {
                                        value = this.propertyStore.getTextValueFor(this.dynamicRecords, cursorTracer);
                                    }
                                    break;
                                }
                                case ARRAY: {
                                    this.dynamicRecords.clear();
                                    if (RecordLoading.safeLoadDynamicRecordChain(record -> this.dynamicRecords.add(record.copy()), this.arrayReader, this.seenDynamicRecordIds, block.getSingleValueLong(), this.arrayStoreBlockSize, RecordLoading.NO_DYNAMIC_HANDLER, (id, record) -> this.reporter.forProperty(propertyRecord).arrayNotInUse(block, (DynamicRecord)record), (id, record) -> this.reporter.forDynamicBlock(RecordType.ARRAY_PROPERTY, this.arrayReader.record()).nextNotInUse((DynamicRecord)record), (id, record) -> this.reporter.forProperty(propertyRecord).arrayEmpty(block, (DynamicRecord)record), record -> this.reporter.forDynamicBlock(RecordType.ARRAY_PROPERTY, (DynamicRecord)record).recordNotFullReferencesNext(), record -> this.reporter.forDynamicBlock(RecordType.ARRAY_PROPERTY, (DynamicRecord)record).invalidLength())) {
                                        value = this.propertyStore.getArrayFor(this.dynamicRecords, cursorTracer);
                                    }
                                    break;
                                }
                                default: {
                                    value = type.value(block, null, cursorTracer);
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            this.reporter.forProperty(propertyRecord).invalidPropertyValue(propertyRecord.getId(), block.getKeyIndexId());
                        }
                    }
                    if (value == Values.NO_VALUE) {
                        chainIsOk = false;
                        continue;
                    }
                    if (propertyKeyId < 0 || intoValues.put(propertyKeyId, (Object)value) == null) continue;
                    primitiveReporter.apply(entity).propertyKeyNotUniqueInChain();
                    chainIsOk = false;
                }
            }
            previousRecordId = propertyRecordId;
            propertyRecordId = propertyRecord.getNextProp();
        }
        return chainIsOk;
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new RecordReader[]{this.propertyReader, this.stringReader, this.arrayReader});
    }
}

