/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.consistency.checker.Checker;
import org.neo4j.consistency.checker.CountsState;
import org.neo4j.consistency.checker.IndexSizes;
import org.neo4j.consistency.checker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.index.schema.TokenIndexAccessor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.time.Stopwatch;
import org.neo4j.token.TokenHolders;

class CheckerContext {
    final NeoStores neoStores;
    final IndexAccessors indexAccessors;
    final ConsistencyFlags consistencyFlags;
    final IndexSizes indexSizes;
    final ParallelExecution execution;
    final ConsistencyReport.Reporter reporter;
    final CacheAccess cacheAccess;
    final TokenHolders tokenHolders;
    final RecordLoading recordLoader;
    final CountsState observedCounts;
    final NodeBasedMemoryLimiter limiter;
    final ProgressMonitorFactory.MultiPartBuilder progress;
    final TokenNameLookup tokenNameLookup;
    final PageCache pageCache;
    final PageCacheTracer pageCacheTracer;
    final MemoryTracker memoryTracker;
    final long highNodeId;
    final TokenIndexAccessor nodeLabelIndex;
    final TokenIndexAccessor relationshipTypeIndex;
    private final boolean debug;
    private final AtomicBoolean cancelled;

    CheckerContext(NeoStores neoStores, IndexAccessors indexAccessors, ParallelExecution execution, ConsistencyReport.Reporter reporter, CacheAccess cacheAccess, TokenHolders tokenHolders, RecordLoading recordLoader, CountsState observedCounts, NodeBasedMemoryLimiter limiter, ProgressMonitorFactory.MultiPartBuilder progress, PageCache pageCache, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, boolean debug, ConsistencyFlags consistencyFlags) {
        this(neoStores, indexAccessors, execution, reporter, cacheAccess, tokenHolders, recordLoader, observedCounts, limiter, progress, pageCache, pageCacheTracer, memoryTracker, debug, new AtomicBoolean(), consistencyFlags);
    }

    private CheckerContext(NeoStores neoStores, IndexAccessors indexAccessors, ParallelExecution execution, ConsistencyReport.Reporter reporter, CacheAccess cacheAccess, TokenHolders tokenHolders, RecordLoading recordLoader, CountsState observedCounts, NodeBasedMemoryLimiter limiter, ProgressMonitorFactory.MultiPartBuilder progress, PageCache pageCache, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, boolean debug, AtomicBoolean cancelled, ConsistencyFlags consistencyFlags) {
        this.neoStores = neoStores;
        this.highNodeId = neoStores.getNodeStore().getHighId();
        this.indexAccessors = indexAccessors;
        this.nodeLabelIndex = indexAccessors.nodeLabelIndex();
        this.relationshipTypeIndex = indexAccessors.relationshipTypeIndex();
        this.debug = debug;
        this.consistencyFlags = consistencyFlags;
        this.indexSizes = new IndexSizes(execution, indexAccessors, neoStores.getNodeStore().getHighId(), pageCacheTracer);
        this.execution = execution;
        this.reporter = reporter;
        this.cacheAccess = cacheAccess;
        this.tokenHolders = tokenHolders;
        this.recordLoader = recordLoader;
        this.observedCounts = observedCounts;
        this.limiter = limiter;
        this.progress = progress;
        this.cancelled = cancelled;
        this.tokenNameLookup = tokenHolders.lookupWithIds();
        this.pageCache = pageCache;
        this.pageCacheTracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
    }

    CheckerContext withoutReporting() {
        return new CheckerContext(this.neoStores, this.indexAccessors, this.execution, ConsistencyReport.NO_REPORT, this.cacheAccess, this.tokenHolders, this.recordLoader, this.observedCounts, this.limiter, this.progress, this.pageCache, this.pageCacheTracer, this.memoryTracker, this.debug, this.cancelled, this.consistencyFlags);
    }

    void initialize() throws Exception {
        this.debug(this.limiter.toString(), new Object[0]);
        this.timeOperation("Initialize index sizes", this.indexSizes::initialize, false);
        if (this.debug) {
            this.debugPrintIndexes(this.indexSizes.largeIndexes(EntityType.NODE), "considered large node indexes");
            this.debugPrintIndexes(this.indexSizes.smallIndexes(EntityType.NODE), "considered small node indexes");
            this.debugPrintIndexes(this.indexAccessors.onlineRules(EntityType.RELATIONSHIP), "the relationship indexes");
        }
    }

    void initializeRange() {
        this.observedCounts.clearDynamicNodeLabelsCache();
    }

    private void debugPrintIndexes(List<IndexDescriptor> indexes, String description) {
        if (!indexes.isEmpty()) {
            this.debug("These are %s (%d):", description, indexes.size());
            indexes.forEach(index -> this.debug("  %s", index));
        }
    }

    private void timeOperation(String description, ParallelExecution.ThrowingRunnable action, boolean linePadding) throws Exception {
        Stopwatch stopwatch = Stopwatch.start();
        try {
            this.debug(linePadding, "STARTED %s", description);
            action.doRun();
            this.debug(linePadding, "COMPLETED %s, took %s", description, Format.duration((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        }
        catch (Exception e) {
            this.debug(linePadding, "FAILED %s after %s", description, Format.duration((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            throw e;
        }
    }

    boolean isCancelled() {
        return this.cancelled.get();
    }

    void cancel() {
        this.cancelled.set(true);
    }

    void runIfAllowed(Checker checker, LongRange range) throws Exception {
        if (!this.isCancelled() && checker.shouldBeChecked(this.consistencyFlags)) {
            this.timeOperation(checker.toString(), () -> checker.check(range, NodeBasedMemoryLimiter.isFirst(range), this.limiter.isLast(range)), true);
        }
    }

    void paddedDebug(String format, Object ... params) {
        this.debug(true, format, params);
    }

    void debug(String format, Object ... params) {
        this.debug(false, format, params);
    }

    private void debug(boolean linePadded, String format, Object ... params) {
        if (this.debug) {
            System.out.println(String.format((linePadded ? "%n" : "") + format, params));
        }
    }

    ProgressListener progressReporter(Checker checker, String name, long totalCount) {
        return this.roundInsensitiveProgressReporter(checker, name, totalCount * (long)this.limiter.numberOfRanges());
    }

    ProgressListener roundInsensitiveProgressReporter(Checker checker, String name, long totalCount) {
        if (!checker.shouldBeChecked(this.consistencyFlags)) {
            return ProgressListener.NONE;
        }
        return this.progress.progressForPart(name, totalCount);
    }
}

