/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checker.Checker;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.IndexSizes;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checker.RecordReader;
import org.neo4j.consistency.checker.SafePropertyChainReader;
import org.neo4j.consistency.checker.SchemaComplianceChecker;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexChecker
implements Checker {
    private static final String INDEX_CHECKER_TAG = "IndexChecker";
    private static final String CONSISTENCY_INDEX_ENTITY_CHECK_TAG = "consistencyIndexEntityCheck";
    private static final String CONSISTENCY_INDEX_CACHER_TAG = "consistencyIndexCacher";
    private static final int INDEX_CACHING_PROGRESS_FACTOR = 3;
    static final int NUM_INDEXES_IN_CACHE = 5;
    private static final int CHECKSUM_MASK = Short.MAX_VALUE;
    private static final int IN_USE_MASK = 32768;
    private static final int CHECKSUM_SIZE = 15;
    private static final int IN_USE_BIT = 1;
    private static final int TOTAL_SIZE = 16;
    private final EntityType entityType;
    private final ConsistencyReport.Reporter reporter;
    private final CheckerContext context;
    private final IndexAccessors indexAccessors;
    private final CacheAccess cacheAccess;
    private final ProgressListener cacheProgress;
    private final ProgressListener scanProgress;
    private final List<IndexDescriptor> indexes;

    IndexChecker(CheckerContext context, EntityType entityType) {
        this.indexAccessors = context.indexAccessors;
        this.context = context;
        this.entityType = entityType;
        this.reporter = context.reporter;
        this.cacheAccess = context.cacheAccess;
        this.indexes = context.indexSizes.largeIndexes(entityType);
        long totalSize = this.indexes.stream().mapToLong(context.indexSizes::getEstimatedIndexSize).sum();
        int rounds = (this.indexes.size() - 1) / 5 + 1;
        this.scanProgress = context.roundInsensitiveProgressReporter(this, "Node index checking", (long)rounds * context.neoStores.getNodeStore().getHighId());
        this.cacheProgress = context.roundInsensitiveProgressReporter(this, "Node index caching", totalSize / 3L);
    }

    @Override
    public void check(LongRange nodeIdRange, boolean firstRange, boolean lastRange) throws Exception {
        this.cacheAccess.setCacheSlotSizesAndClear(16, 16, 16, 16, 16);
        ArrayList<IndexContext> indexesToCheck = new ArrayList<IndexContext>();
        try (CursorContext indexChecker = new CursorContext(this.context.pageCacheTracer.createPageCursorTracer(INDEX_CHECKER_TAG));
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.context.neoStores, indexChecker);){
            for (int i = 0; i < this.indexes.size() && !this.context.isCancelled(); ++i) {
                boolean canFitMoreAndIsNotLast;
                IndexContext index = new IndexContext(this.indexes.get(i), i % 5);
                indexesToCheck.add(index);
                this.cacheIndex(index, nodeIdRange, firstRange, indexChecker, (StoreCursors)storeCursors);
                boolean isLastIndex = i == this.indexes.size() - 1;
                boolean bl = canFitMoreAndIsNotLast = !isLastIndex && index.cacheSlotOffset != 4;
                if (canFitMoreAndIsNotLast || this.context.isCancelled()) continue;
                this.checkVsEntities(indexesToCheck, nodeIdRange);
                indexesToCheck = new ArrayList();
                this.cacheAccess.clearCache();
            }
        }
    }

    @Override
    public boolean shouldBeChecked(ConsistencyFlags flags) {
        return flags.isCheckIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheIndex(IndexContext index, LongRange nodeIdRange, boolean firstRange, CursorContext cursorContext, StoreCursors storeCursors) throws Exception {
        IndexAccessor accessor = this.indexAccessors.accessorFor(index.descriptor);
        IndexEntriesReader[] partitions = accessor.newAllEntriesValueReader(this.context.execution.getNumberOfThreads(), cursorContext);
        try {
            int i;
            Value[][] firstValues = new Value[partitions.length][];
            Value[][] lastValues = new Value[partitions.length][];
            long[] firstEntityIds = new long[partitions.length];
            long[] lastEntityIds = new long[partitions.length];
            ParallelExecution.ThrowingRunnable[] workers = new ParallelExecution.ThrowingRunnable[partitions.length];
            for (i = 0; i < partitions.length; ++i) {
                IndexEntriesReader partition = partitions[i];
                int slot = i;
                workers[i] = () -> {
                    int lastChecksum = 0;
                    int progressPart = 0;
                    ProgressListener localCacheProgress = this.cacheProgress.threadLocalReporter();
                    CacheAccess.Client client = this.cacheAccess.client();
                    try (CursorContext context = new CursorContext(this.context.pageCacheTracer.createPageCursorTracer(CONSISTENCY_INDEX_CACHER_TAG));
                         CachedStoreCursors localStoreCursors = new CachedStoreCursors(this.context.neoStores, context);){
                        while (partition.hasNext() && !this.context.isCancelled()) {
                            long entityId = partition.next();
                            if (!nodeIdRange.isWithinRangeExclusiveTo(entityId)) {
                                if (firstRange && entityId >= this.context.highNodeId) {
                                    this.reporter.forIndexEntry(new IndexEntry(index.descriptor, this.context.tokenNameLookup, entityId)).nodeNotInUse(this.context.recordLoader.node(entityId, (StoreCursors)localStoreCursors));
                                    continue;
                                }
                                if (!firstRange || !index.descriptor.isUnique() || !index.hasValues) continue;
                                Value[] indexedValues = partition.values();
                                int checksum = IndexChecker.checksum(indexedValues);
                                assert (checksum <= Short.MAX_VALUE);
                                lastChecksum = this.verifyUniquenessInPartition(index, firstValues, lastValues, firstEntityIds, lastEntityIds, slot, lastChecksum, localStoreCursors, entityId, indexedValues, checksum);
                                continue;
                            }
                            int data = 32768;
                            if (index.hasValues) {
                                Value[] indexedValues = partition.values();
                                int checksum = IndexChecker.checksum(indexedValues);
                                assert (checksum <= Short.MAX_VALUE);
                                data |= checksum;
                                if (firstRange && index.descriptor.isUnique()) {
                                    lastChecksum = this.verifyUniquenessInPartition(index, firstValues, lastValues, firstEntityIds, lastEntityIds, slot, lastChecksum, localStoreCursors, entityId, indexedValues, checksum);
                                }
                            }
                            client.putToCacheSingle(entityId, index.cacheSlotOffset, data);
                            if (++progressPart != 3) continue;
                            localCacheProgress.add(1L);
                            progressPart = 0;
                        }
                    }
                    localCacheProgress.done();
                };
            }
            this.context.execution.run("Cache index", workers);
            if (firstRange && index.descriptor.isUnique() && !this.context.isCancelled()) {
                for (i = 0; i < partitions.length - 1; ++i) {
                    Object[] left = lastValues[i];
                    Object[] right = firstValues[i + 1];
                    if (left == null || right == null || !Arrays.equals(left, right)) continue;
                    long leftEntityId = lastEntityIds[i];
                    long rightEntityId = firstEntityIds[i + 1];
                    this.reporter.forNode(this.context.recordLoader.node(leftEntityId, storeCursors)).uniqueIndexNotUnique(index.descriptor, left, rightEntityId);
                }
            }
        }
        finally {
            IOUtils.closeAll((AutoCloseable[])partitions);
        }
    }

    private int verifyUniquenessInPartition(IndexContext index, Value[][] firstValues, Value[][] lastValues, long[] firstEntityIds, long[] lastEntityIds, int slot, int lastChecksum, CachedStoreCursors localStoreCursors, long entityId, Value[] indexedValues, int checksum) {
        if (firstValues[slot] == null) {
            firstValues[slot] = indexedValues;
            firstEntityIds[slot] = entityId;
        }
        if (lastValues[slot] != null && lastChecksum == checksum && Arrays.equals(lastValues[slot], indexedValues)) {
            this.reporter.forNode(this.context.recordLoader.node(entityId, (StoreCursors)localStoreCursors)).uniqueIndexNotUnique(index.descriptor, indexedValues, lastEntityIds[slot]);
        }
        lastValues[slot] = indexedValues;
        lastEntityIds[slot] = entityId;
        return checksum;
    }

    private void checkVsEntities(List<IndexContext> indexes, LongRange nodeIdRange) throws Exception {
        ParallelExecution execution = this.context.execution;
        execution.run(this.getClass().getSimpleName() + "-checkVsEntities", execution.partition(nodeIdRange, (from, to, last) -> () -> this.checkVsEntities(indexes, from, to)));
    }

    /*
     * Unable to fully structure code
     */
    private void checkVsEntities(List<IndexContext> indexes, long fromEntityId, long toEntityId) {
        noReportingContext = this.context.withoutReporting();
        cursorContext = new CursorContext(this.context.pageCacheTracer.createPageCursorTracer("consistencyIndexEntityCheck"));
        try {
            storeCursors = new CachedStoreCursors(this.context.neoStores, cursorContext);
            try {
                nodeReader = new RecordReader<RECORD>(this.context.neoStores.getNodeStore(), true, cursorContext);
                try {
                    labelReader = new RecordReader<DynamicRecord>((CommonAbstractStore<DynamicRecord, ?>)this.context.neoStores.getNodeStore().getDynamicLabelStore(), false, cursorContext);
                    try {
                        propertyReader = new SafePropertyChainReader(noReportingContext, cursorContext);
                        try {
                            localScanProgress = this.scanProgress.threadLocalReporter();
                            allValues = new IntObjectHashMap<Value>();
                            client = this.cacheAccess.client();
                            numberOfIndexes = indexes.size();
                            for (entityId = fromEntityId; entityId < toEntityId && !this.context.isCancelled(); ++entityId) {
                                block37: {
                                    block36: {
                                        nodeRecord = (NodeRecord)nodeReader.read(entityId);
                                        if (!nodeRecord.inUse()) break block36;
                                        entityTokens = RecordLoading.safeGetNodeLabels(noReportingContext, (StoreCursors)storeCursors, nodeRecord.getId(), nodeRecord.getLabelField(), labelReader);
                                        allValues = RecordLoading.lightReplace(allValues);
                                        if (entityTokens == null) ** GOTO lbl-1000
                                        if (propertyReader.read((MutableIntObjectMap<Value>)allValues, nodeRecord, (Function<NodeRecord, ConsistencyReport.PrimitiveConsistencyReport>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, forNode(org.neo4j.kernel.impl.store.record.NodeRecord ), (Lorg/neo4j/kernel/impl/store/record/NodeRecord;)Lorg/neo4j/consistency/report/ConsistencyReport$PrimitiveConsistencyReport;)((ConsistencyReport.Reporter)noReportingContext.reporter), (StoreCursors)storeCursors)) {
                                            v0 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v0 = propertyChainRead = false;
                                        }
                                        if (propertyChainRead) {
                                            for (i = 0; i < numberOfIndexes; ++i) {
                                                index = indexes.get(i);
                                                descriptor = index.descriptor;
                                                cachedValue = client.getFromCache(entityId, i);
                                                nodeIsInIndex = (cachedValue & 32768L) != 0L;
                                                values = RecordLoading.entityIntersectionWithSchema(entityTokens, allValues, descriptor.schema(), descriptor.getIndexType());
                                                if (index.descriptor.schema().isFulltextSchemaDescriptor()) {
                                                    nodePropertyKeys = allValues.keySet().toArray();
                                                    indexPropertyKeys = index.descriptor.schema().getPropertyIds();
                                                    v1 = nodeShouldBeInIndex = index.descriptor.schema().isAffected(entityTokens) != false && IndexChecker.containsAny(indexPropertyKeys, nodePropertyKeys) != false && SchemaComplianceChecker.areValuesSupportedByIndex(IndexType.FULLTEXT, values) != false;
                                                    if (nodeShouldBeInIndex && !nodeIsInIndex) {
                                                        this.getReporter((PrimitiveRecord)this.context.recordLoader.node(entityId, (StoreCursors)storeCursors)).notIndexed(descriptor, new Object[0]);
                                                        continue;
                                                    }
                                                    if (nodeShouldBeInIndex || !nodeIsInIndex) continue;
                                                    noValues = new Value[indexPropertyKeys.length];
                                                    Arrays.fill(noValues, Values.NO_VALUE);
                                                    docsWithNoneOfProperties = this.indexAccessors.readers().reader(descriptor).countIndexedEntities(entityId, cursorContext, indexPropertyKeys, (Value[])noValues);
                                                    if (docsWithNoneOfProperties == 1L) continue;
                                                    this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)).nodeIndexedWhenShouldNot(this.context.recordLoader.node(entityId, (StoreCursors)storeCursors));
                                                    continue;
                                                }
                                                if (values != null) {
                                                    if (!nodeIsInIndex) {
                                                        this.getReporter((PrimitiveRecord)this.context.recordLoader.node(entityId, (StoreCursors)storeCursors)).notIndexed(descriptor, Values.asObjects((Value[])values));
                                                        continue;
                                                    }
                                                    if (!index.hasValues || (cachedChecksum = (int)cachedValue & 32767) == (actualChecksum = IndexChecker.checksum(values))) continue;
                                                    this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)).nodeIndexedWithWrongValues(this.context.recordLoader.node(entityId, (StoreCursors)storeCursors), Values.asObjects((Value[])values));
                                                    continue;
                                                }
                                                if (!nodeIsInIndex) continue;
                                                this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)).nodeIndexedWhenShouldNot(this.context.recordLoader.node(entityId, (StoreCursors)storeCursors));
                                            }
                                        }
                                        break block37;
                                    }
                                    for (i = 0; i < numberOfIndexes; ++i) {
                                        v2 = isInIndex = (client.getFromCache(entityId, i) & 32768L) != 0L;
                                        if (!isInIndex) continue;
                                        this.reporter.forIndexEntry(new IndexEntry(indexes.get((int)i).descriptor, this.context.tokenNameLookup, entityId)).nodeNotInUse(this.context.recordLoader.node(entityId, (StoreCursors)storeCursors));
                                    }
                                }
                                localScanProgress.add(1L);
                            }
                            localScanProgress.done();
                        }
                        finally {
                            propertyReader.close();
                        }
                    }
                    finally {
                        labelReader.close();
                    }
                }
                finally {
                    nodeReader.close();
                }
            }
            finally {
                storeCursors.close();
            }
        }
        finally {
            cursorContext.close();
        }
    }

    private static boolean containsAny(int[] values, int[] toCheck) {
        for (int value : values) {
            for (int candidate : toCheck) {
                if (value != candidate) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("%s[entityType:%s,indexesToCheck:%d]", this.getClass().getSimpleName(), this.entityType, this.indexes.size());
    }

    private static int checksum(Value[] values) {
        int checksum = 0;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                checksum ^= values[i].hashCode() * (i + 1);
            }
        }
        int twoByteChecksum = checksum >>> 16 ^ checksum & 0xFF;
        return twoByteChecksum & Short.MAX_VALUE;
    }

    private ConsistencyReport.PrimitiveConsistencyReport getReporter(PrimitiveRecord cursor) {
        if (EntityType.NODE.equals((Object)this.entityType)) {
            return this.reporter.forNode((NodeRecord)cursor);
        }
        return this.reporter.forRelationship((RelationshipRecord)cursor);
    }

    private static class IndexContext {
        final IndexDescriptor descriptor;
        final int cacheSlotOffset;
        final boolean hasValues;

        IndexContext(IndexDescriptor descriptor, int cacheSlotOffset) {
            this.descriptor = descriptor;
            this.cacheSlotOffset = cacheSlotOffset;
            this.hasValues = IndexSizes.hasValues(descriptor);
        }
    }
}

