/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.consistency.checking.cache.CacheSlots;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.os.OsBeanUtil;

public class NodeBasedMemoryLimiter
extends PrefetchingIterator<LongRange> {
    public static final Factory DEFAULT = new DefaultFactory((Double)GraphDatabaseInternalSettings.consistency_check_memory_limit_factor.defaultValue());
    private final long pageCacheMemory;
    private final long jvmMemory;
    private final long machineMemory;
    private final long requiredMemoryPerNode;
    private final long effectiveJvmMemory;
    private final long occupiedMemory;
    private long effectiveMachineMemory;
    private final long highNodeId;
    private final long nodesPerRange;
    private long currentRangeStart;
    private long currentRangeEnd;

    public static Factory defaultWithLeeway(double leewayFactor) {
        return new DefaultFactory(leewayFactor);
    }

    public NodeBasedMemoryLimiter(long pageCacheMemory, long jvmMemory, long machineMemory, long requiredMemoryPerNode, long highNodeId, double leewayFactor) {
        this.pageCacheMemory = pageCacheMemory;
        this.jvmMemory = jvmMemory;
        this.machineMemory = machineMemory;
        this.requiredMemoryPerNode = requiredMemoryPerNode;
        this.effectiveJvmMemory = jvmMemory == Long.MAX_VALUE ? Runtime.getRuntime().totalMemory() : jvmMemory;
        this.occupiedMemory = pageCacheMemory + this.effectiveJvmMemory;
        this.effectiveMachineMemory = machineMemory == -1L ? Long.max(pageCacheMemory * 2L, ByteUnit.gibiBytes((long)2L)) : machineMemory;
        this.effectiveMachineMemory = Long.max((long)((double)this.effectiveMachineMemory * leewayFactor), this.occupiedMemory);
        long availableMemory = this.effectiveMachineMemory - this.occupiedMemory;
        assert (availableMemory > 0L);
        assert (requiredMemoryPerNode > 0L);
        this.highNodeId = highNodeId;
        this.nodesPerRange = Long.max(1L, Long.min(highNodeId, availableMemory / requiredMemoryPerNode));
        this.currentRangeStart = 0L;
        this.currentRangeEnd = Long.min(this.highNodeId, this.nodesPerRange);
    }

    int numberOfRanges() {
        return Math.toIntExact((long)(((double)this.highNodeId - 1.0) / (double)this.nodesPerRange + 1.0));
    }

    long rangeSize() {
        return this.nodesPerRange;
    }

    protected LongRange fetchNextOrNull() {
        if (this.currentRangeStart >= this.highNodeId) {
            return null;
        }
        LongRange range = LongRange.range((long)this.currentRangeStart, (long)this.currentRangeEnd);
        this.currentRangeStart = this.currentRangeEnd;
        this.currentRangeEnd = Long.min(this.highNodeId, this.currentRangeEnd + this.nodesPerRange);
        return range;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(((Object)((Object)this)).getClass().getSimpleName()).append(':');
        builder.append(String.format("%n  pageCacheMemory:%s", ByteUnit.bytesToString((long)this.pageCacheMemory)));
        builder.append(String.format("%n  jvmMemory:%s", ByteUnit.bytesToString((long)this.jvmMemory)));
        builder.append(String.format("%n  machineMemory:%s", ByteUnit.bytesToString((long)this.machineMemory)));
        builder.append(String.format("%n  perNodeMemory:%s", ByteUnit.bytesToString((long)this.requiredMemoryPerNode)));
        builder.append(String.format("%n  nodeHighId:%s", this.highNodeId));
        if (this.effectiveJvmMemory != this.jvmMemory) {
            builder.append(String.format("%n  effective jvmMemory:%s", ByteUnit.bytesToString((long)this.effectiveJvmMemory)));
        }
        if (this.effectiveMachineMemory != this.machineMemory) {
            builder.append(String.format("%n  effective machineMemory:%s", ByteUnit.bytesToString((long)this.effectiveMachineMemory)));
        }
        builder.append(String.format("%n  occupiedMemory:%s", ByteUnit.bytesToString((long)this.occupiedMemory)));
        builder.append(String.format("%n  ==> numberOfRanges:%d", this.numberOfRanges()));
        builder.append(String.format("%n  ==> numberOfNodesPerRange:%d", this.nodesPerRange));
        return builder.toString();
    }

    static boolean isFirst(LongRange range) {
        return range.from() == 0L;
    }

    boolean isLast(LongRange range) {
        return range.to() == this.highNodeId;
    }

    private static class DefaultFactory
    implements Factory {
        private final double memoryLeewayFactor;

        DefaultFactory(double memoryLeewayFactor) {
            this.memoryLeewayFactor = memoryLeewayFactor;
        }

        @Override
        public NodeBasedMemoryLimiter create(long pageCacheMemory, long highNodeId) {
            long jvmMemory = Runtime.getRuntime().maxMemory();
            long machineMemory = OsBeanUtil.getTotalPhysicalMemory();
            long perNodeMemory = CacheSlots.CACHE_LINE_SIZE_BYTES;
            return new NodeBasedMemoryLimiter(pageCacheMemory, jvmMemory, machineMemory, perNodeMemory, highNodeId, this.memoryLeewayFactor);
        }
    }

    public static interface Factory {
        public NodeBasedMemoryLimiter create(long var1, long var3);
    }
}

