/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Objects;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;

public abstract class SchemaRuleKey {
    private final boolean isUnique;
    private final SchemaDescriptor schema;
    private final IndexType indexType;

    protected SchemaRuleKey(SchemaDescriptor schema, boolean isUnique, IndexType indexType) {
        this.isUnique = isUnique;
        this.schema = schema;
        this.indexType = indexType;
    }

    public static SchemaRuleKey from(SchemaRule rule) {
        return rule instanceof ConstraintDescriptor ? new ConstraintKey((ConstraintDescriptor)rule) : new IndexKey((IndexDescriptor)rule);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRuleKey that = (SchemaRuleKey)o;
        return this.isUnique == that.isUnique && this.schema.equals(that.schema) && this.indexType == that.indexType;
    }

    public int hashCode() {
        return Objects.hash(this.indexType, this.isUnique ? 1 : 0, this.schema.hashCode());
    }

    static class ConstraintKey
    extends SchemaRuleKey {
        ConstraintKey(ConstraintDescriptor constraint) {
            super(constraint.schema(), constraint.enforcesUniqueness(), constraint.isIndexBackedConstraint() ? constraint.asIndexBackedConstraint().indexType() : null);
        }
    }

    static class IndexKey
    extends SchemaRuleKey {
        IndexKey(IndexDescriptor index) {
            super(index.schema(), index.isUnique(), index.getIndexType());
        }
    }
}

