/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.Vector;
import org.neo4j.values.storable.VectorValue;

public interface VectorExtractor<T>
extends Extractor<T> {
    public static final String COL_NAME = "VECTOR";

    public Extractor<T> getDimensionVerifyingExtractor(int var1);

    @Override
    default public boolean isEmpty(Object value) {
        VectorValue v;
        return value == null || value == Values.NO_VALUE || value instanceof VectorValue && (v = (VectorValue)value).dimensions() == 0;
    }

    public static VectorCSVHeaderInformation parseHeaderInformation(Map<String, String> options) {
        VectorCSVHeaderInformation fields = new VectorCSVHeaderInformation();
        options.forEach(fields::assign);
        return fields;
    }

    public static class VectorCSVHeaderInformation
    implements CSVHeaderInformation {
        private Vector.CoordinateType coordinateType;
        private Integer dimensions;

        public Vector.CoordinateType getCoordinateType() {
            if (this.coordinateType == null) {
                throw new IllegalArgumentException("vector must specify coordinate type, e.g.\"v:vector{dimensions:10, coordinateType:byte}\"");
            }
            return this.coordinateType;
        }

        public int getDimensions() {
            if (this.dimensions == null) {
                throw new IllegalArgumentException("vector must specify dimensions, e.g.\"v:vector{dimensions:10, coordinateType:byte}\"");
            }
            return this.dimensions;
        }

        public void assign(String key, Object value) {
            if (!(value instanceof String)) {
                throw new IllegalStateException("Provided non-String value, that is not supported: %s".formatted(String.valueOf(value)));
            }
            String strValue = (String)value;
            switch (key.toLowerCase(Locale.ROOT)) {
                case "coordinatetype": {
                    String normalized;
                    VectorCSVHeaderInformation.checkUnassigned("coordinateType", this.coordinateType);
                    this.coordinateType = switch (normalized = Value.QUOTES_PATTERN.matcher(strValue).replaceAll("").toLowerCase(Locale.ROOT)) {
                        case "byte" -> Vector.CoordinateType.INTEGER8;
                        case "short" -> Vector.CoordinateType.INTEGER16;
                        case "int" -> Vector.CoordinateType.INTEGER32;
                        case "long" -> Vector.CoordinateType.INTEGER64;
                        case "float" -> Vector.CoordinateType.FLOAT32;
                        case "double" -> Vector.CoordinateType.FLOAT64;
                        default -> throw new IllegalArgumentException("%s is not a valid coordinate type.".formatted(strValue));
                    };
                    break;
                }
                case "dimensions": {
                    int result;
                    VectorCSVHeaderInformation.checkUnassigned("dimensions", this.dimensions);
                    try {
                        result = Integer.parseInt(strValue);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("%s is not a valid value for dimensions.".formatted(strValue));
                    }
                    this.dimensions = result;
                    if (this.dimensions >= 1 && this.dimensions <= 4096) break;
                    throw new IllegalArgumentException("Invalid vector dimensions: " + this.dimensions);
                }
            }
        }

        private static void checkUnassigned(String key, Object value) {
            if (value != null) {
                throw new IllegalArgumentException("Duplicate field '%s'".formatted(key));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VectorCSVHeaderInformation that = (VectorCSVHeaderInformation)o;
            return Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.coordinateType, that.coordinateType);
        }

        public int hashCode() {
            return Objects.hash(this.dimensions, this.coordinateType);
        }
    }
}

