/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import org.neo4j.csv.reader.AutoReadingSource;
import org.neo4j.csv.reader.BufferedCharSeeker;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.ThreadAheadReadable;

public class CharSeekers {
    private CharSeekers() {
    }

    public static CharSeeker charSeeker(CharReadable reader, Configuration config, boolean readAhead) {
        if (readAhead) {
            reader = ThreadAheadReadable.threadAhead(reader, config.bufferSize());
        }
        return new BufferedCharSeeker(new AutoReadingSource(reader, config.bufferSize()), config);
    }

    public static CharSeeker charSeeker(CharReadable reader, int bufferSize, boolean readAhead, char quotationCharacter) {
        Configuration config = Configuration.newBuilder().withQuotationCharacter(quotationCharacter).withBufferSize(bufferSize).build();
        return CharSeekers.charSeeker(reader, config, readAhead);
    }
}

