/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.csv.reader.SourceTraceability;

public interface CharReadable
extends Closeable,
SourceTraceability {
    public static final CharReadable EMPTY = new Empty();

    public SectionedCharBuffer read(SectionedCharBuffer var1, int var2) throws IOException;

    public int read(char[] var1, int var2, int var3) throws IOException;

    public long length();

    public static class Empty
    extends SourceTraceability.Empty
    implements CharReadable {
        @Override
        public int read(char[] into, int offset, int length) {
            return -1;
        }

        @Override
        public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) {
            buffer.compact(buffer, from);
            return buffer;
        }

        @Override
        public long length() {
            return 0L;
        }

        @Override
        public void close() {
        }
    }

    public static abstract class Adapter
    extends SourceTraceability.Adapter
    implements CharReadable {
        @Override
        public void close() throws IOException {
        }

        @Override
        public float compressionRatio() {
            return 1.0f;
        }
    }
}

