/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.cypher.internal.cache.CacheTracer;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001\u0002\n\u0014\u0001yA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tW\u0001\u0011)\u0019!C\u0001Y!A\u0001\u0007\u0001B\u0001B\u0003%Q\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015i\u0004\u0001\"\u0001G\u0011\u001dI\u0005A1A\u0005\u0002)Ca\u0001\u0017\u0001!\u0002\u0013Y\u0005bB-\u0001\u0005\u0004%IA\u0017\u0005\u0007=\u0002\u0001\u000b\u0011B.\t\u000b}\u0003A\u0011\u00011\t\u000b!\u0004A\u0011A5\t\u000b9\u0004A\u0011A8\t\u000bY\u0004A\u0011A<\t\u000bm\u0004A\u0011\u0001?\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!1\u0011Q\u0003\u0001\u0005\u0002]\u0014\u0001\u0002\u0014$V\u0007\u0006\u001c\u0007.\u001a\u0006\u0003)U\tQaY1dQ\u0016T!AF\f\u0002\u0011%tG/\u001a:oC2T!\u0001G\r\u0002\r\rL\b\u000f[3s\u0015\tQ2$A\u0003oK>$$NC\u0001\u001d\u0003\ry'oZ\u0002\u0001+\ryr'Q\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017\u0001D2bG\",g)Y2u_JL\bC\u0001\u0015*\u001b\u0005\u0019\u0012B\u0001\u0016\u0014\u0005Q\u0019\u0015M\u001a4fS:,7)Y2iK\u001a\u000b7\r^8ss\u0006!1/\u001b>f+\u0005i\u0003CA\u0011/\u0013\ty#EA\u0002J]R\fQa]5{K\u0002\na\u0001\u001e:bG\u0016\u0014\bc\u0001\u00154k%\u0011Ag\u0005\u0002\f\u0007\u0006\u001c\u0007.\u001a+sC\u000e,'\u000f\u0005\u00027o1\u0001A!\u0002\u001d\u0001\u0005\u0004I$!A&\u0012\u0005i\u0002\u0003CA\u0011<\u0013\ta$EA\u0004O_RD\u0017N\\4\u0002\rqJg.\u001b;?)\u0011y4\tR#\u0011\t!\u0002Q\u0007\u0011\t\u0003m\u0005#QA\u0011\u0001C\u0002e\u0012\u0011A\u0016\u0005\u0006M\u0015\u0001\ra\n\u0005\u0006W\u0015\u0001\r!\f\u0005\u0006c\u0015\u0001\rA\r\u000b\u0004\u007f\u001dC\u0005\"\u0002\u0014\u0007\u0001\u00049\u0003\"B\u0016\u0007\u0001\u0004i\u0013a\u0004:f[>4\u0018\r\u001c'jgR,g.\u001a:\u0016\u0003-\u0003B\u0001\u0014,6\u00016\tQJ\u0003\u0002\u0015\u001d*\u0011q\nU\u0001\tG\u00064g-Z5oK*\u0011\u0011KU\u0001\tE\u0016tW.\u00198fg*\u00111\u000bV\u0001\u0007O&$\b.\u001e2\u000b\u0003U\u000b1aY8n\u0013\t9VJA\bSK6|g/\u00197MSN$XM\\3s\u0003A\u0011X-\\8wC2d\u0015n\u001d;f]\u0016\u0014\b%A\u0003j]:,'/F\u0001\\!\u0011aE,\u000e!\n\u0005uk%!B\"bG\",\u0017AB5o]\u0016\u0014\b%A\bd_6\u0004X\u000f^3JM\u0006\u00137/\u001a8u)\r\u0001\u0015m\u0019\u0005\u0006E.\u0001\r!N\u0001\u0004W\u0016L\bB\u00023\f\t\u0003\u0007Q-A\u0001g!\r\tc\rQ\u0005\u0003O\n\u0012\u0001\u0002\u00102z]\u0006lWMP\u0001\u0004O\u0016$HC\u00016n!\r\t3\u000eQ\u0005\u0003Y\n\u0012aa\u00149uS>t\u0007\"\u00022\r\u0001\u0004)\u0014a\u00019viR\u0019\u0001o\u001d;\u0011\u0005\u0005\n\u0018B\u0001:#\u0005\u0011)f.\u001b;\t\u000b\tl\u0001\u0019A\u001b\t\u000bUl\u0001\u0019\u0001!\u0002\u000bY\fG.^3\u0002\u001b\u0015\u001cH/[7bi\u0016$7+\u001b>f)\u0005A\bCA\u0011z\u0013\tQ(E\u0001\u0003M_:<\u0017!B1t\u001b\u0006\u0004H#A?\u0011\u000by\fY!\u000e!\u000e\u0003}TA!!\u0001\u0002\u0004\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\u0015\u0011qA\u0001\u0005kRLGN\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\r\tia \u0002\u000e\u0007>t7-\u001e:sK:$X*\u00199\u0002\u0015%tg/\u00197jI\u0006$X\rF\u0002q\u0003'AQA\u0019\tA\u0002U\nQa\u00197fCJ\u0004")
public class LFUCache<K, V> {
    private final int size;
    private final CacheTracer<K> tracer;
    private final RemovalListener<K, V> removalListener;
    private final Cache<K, V> inner;

    public int size() {
        return this.size;
    }

    public RemovalListener<K, V> removalListener() {
        return this.removalListener;
    }

    private Cache<K, V> inner() {
        return this.inner;
    }

    public V computeIfAbsent(K key, Function0<V> f) {
        BooleanRef hit = BooleanRef.create((boolean)true);
        Object result = this.inner().get(key, x$1 -> {
            hit$1.elem = false;
            return f.apply();
        });
        if (hit.elem) {
            this.tracer.cacheHit(key, "");
        } else {
            this.tracer.cacheMiss(key, "");
        }
        return (V)result;
    }

    public Option<V> get(K key) {
        Option res = Option$.MODULE$.apply(this.inner().getIfPresent(key));
        if (res.isEmpty()) {
            this.tracer.cacheMiss(key, "");
        } else {
            this.tracer.cacheHit(key, "");
        }
        return res;
    }

    public void put(K key, V value) {
        this.inner().put(key, value);
    }

    public long estimatedSize() {
        return this.inner().estimatedSize();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.inner().asMap();
    }

    public void invalidate(K key) {
        this.inner().invalidate(key);
    }

    public long clear() {
        long priorSize = this.inner().estimatedSize();
        this.inner().invalidateAll();
        this.inner().cleanUp();
        this.tracer.cacheFlush(priorSize);
        return priorSize;
    }

    public LFUCache(CaffeineCacheFactory cacheFactory, int size, CacheTracer<K> tracer) {
        this.size = size;
        this.tracer = tracer;
        this.removalListener = (key, value, cause) -> $this.tracer.discard(key, "");
        this.inner = cacheFactory.createCache(size, this.removalListener());
    }

    public LFUCache(CaffeineCacheFactory cacheFactory, int size) {
        this(cacheFactory, size, new CacheTracer<K>(){

            public void cacheHit(K key, String metaData) {
                CacheTracer.cacheHit$(this, key, metaData);
            }

            public void cacheMiss(K key, String metaData) {
                CacheTracer.cacheMiss$(this, key, metaData);
            }

            public void compute(K key, String metaData) {
                CacheTracer.compute$(this, key, metaData);
            }

            public void discard(K key, String metaData) {
                CacheTracer.discard$(this, key, metaData);
            }

            public void computeWithExpressionCodeGen(K key, String metaData) {
                CacheTracer.computeWithExpressionCodeGen$(this, key, metaData);
            }

            public void cacheStale(K key, int secondsSinceCompute, String metaData, Option<String> maybeReason) {
                CacheTracer.cacheStale$(this, key, secondsSinceCompute, metaData, maybeReason);
            }

            public void cacheFlush(long sizeOfCacheBeforeFlush) {
                CacheTracer.cacheFlush$(this, sizeOfCacheBeforeFlush);
            }
            {
                CacheTracer.$init$(this);
            }
        });
    }
}

