/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.commands.expressions;

import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Collection;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.ContainerIndex;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v2_3.spi.Operations;
import org.neo4j.cypher.internal.compiler.v2_3.spi.QueryContext;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.FakeExpression;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.SymbolTable;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.SymbolTable$;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.CypherType;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.package$;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001'\t\u00112i\u001c8uC&tWM]%oI\u0016DH+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0004\t\u0003\u00111(gX\u001a\u000b\u0005%Q\u0011\u0001C2p[BLG.\u001a:\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011QcG\u0007\u0002-)\u0011q\u0003G\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000feQ!A\u0007\u0006\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!\u0001\b\f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")a\u0004\u0001C\u0001?\u00051A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011A\u0001\u0005\bG\u0001\u0011\r\u0011\"\u0001%\u0003\r\tH\u000f_\u000b\u0002KA\u0011a%K\u0007\u0002O)\u0011\u0001FB\u0001\u0004gBL\u0017B\u0001\u0016(\u00051\tV/\u001a:z\u0007>tG/\u001a=u\u0011\u0019a\u0003\u0001)A\u0005K\u0005!\u0011\u000f\u001e=!\u0011\u001dq\u0003A1A\u0005\u0004=\nQa\u001d;bi\u0016,\u0012\u0001\r\t\u0003cQj\u0011A\r\u0006\u0003g\u0019\tQ\u0001]5qKNL!!\u000e\u001a\u0003\u0015E+XM]=Ti\u0006$X\r\u0003\u00048\u0001\u0001\u0006I\u0001M\u0001\u0007gR\fG/\u001a\u0011\t\u000fe\u0002!\u0019!C\u0001u\u0005\u00191\r\u001e=\u0016\u0003m\u0002\"\u0001P\u001f\u000e\u0003\u0019I!A\u0010\u0004\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bB\u0002!\u0001A\u0003%1(\u0001\u0003dib\u0004\u0003b\u0002\"\u0001\u0005\u0004%\taQ\u0001\rKb\u0004Xm\u0019;fI:+H\u000e\\\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n\u0019\u0011I\\=\t\r-\u0003\u0001\u0015!\u0003E\u00035)\u0007\u0010]3di\u0016$g*\u001e7mA!)Q\n\u0001C\u0005\u001d\u0006\u0019\u0011\u000e\u001a=\u0015\u0005=+FC\u0001#Q\u0011\u0015\tF\nq\u0001S\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\t\u0003CMK!\u0001\u0016\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0003W\u0019\u0002\u0007q+A\u0003wC2,X\r\u0005\u0002F1&\u0011\u0011L\u0012\u0002\u0004\u0013:$\b\"B'\u0001\t\u0013YFC\u0001/_)\t!U\fC\u0003R5\u0002\u000f!\u000bC\u0003W5\u0002\u0007q\f\u0005\u0002aG:\u0011Q)Y\u0005\u0003E\u001a\u000ba\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\u0019\u0019FO]5oO*\u0011!M\u0012")
public class ContainerIndexTest
extends CypherFunSuite {
    private final QueryContext qtx = (QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
    private final QueryState state = QueryStateHelper$.MODULE$.empty().withQueryContext(this.qtx());
    private final ExecutionContext ctx = ExecutionContext$.MODULE$.empty();
    private final Object expectedNull = null;

    public QueryContext qtx() {
        return this.qtx;
    }

    public QueryState state() {
        return this.state;
    }

    public ExecutionContext ctx() {
        return this.ctx;
    }

    public Object expectedNull() {
        return this.expectedNull;
    }

    public Object org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(int value, Expression collection) {
        return new ContainerIndex(collection, (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)value))).apply(this.ctx(), this.state());
    }

    public Object org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(String value, Expression collection) {
        return new ContainerIndex(collection, (Expression)new Literal((Object)value)).apply(this.ctx(), this.state());
    }

    public ContainerIndexTest() {
        this.test("handles collection lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal collection = new Literal((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(0, (Expression)collection)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(1, (Expression)collection)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(2, (Expression)collection)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)3)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(3, (Expression)collection)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)4)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(-1, (Expression)collection)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)4)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(100, (Expression)collection)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles empty collections", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Collection collection = new Collection((Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(0, (Expression)collection)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(-1, (Expression)collection)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(100, (Expression)collection)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles nulls", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal collection = new Literal(null);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx(0, (Expression)collection)).should(this.$outer.equal(this.$outer.expectedNull()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles scala map lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal expression = new Literal((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"foo")})));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx("a", (Expression)expression)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx("b", (Expression)expression)).should(this.$outer.equal("foo"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx("c", (Expression)expression)).should(this.$outer.equal(null), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles java map lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal expression = new Literal(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"foo")}))).asJava());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx("a", (Expression)expression)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx("b", (Expression)expression)).should(this.$outer.equal("foo"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx("c", (Expression)expression)).should(this.$outer.equal(null), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles node lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node2 = (Node)this.$outer.mock(ManifestFactory$.MODULE$.classType(Node.class));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
                Literal expression = new Literal((Object)node2);
                Mockito.when((Object)this.$outer.qtx().getOptPropertyKeyId("v")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                Mockito.when((Object)this.$outer.qtx().getOptPropertyKeyId("c")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Operations nodeOps = (Operations)this.$outer.mock(ManifestFactory$.MODULE$.classType(Operations.class, ManifestFactory$.MODULE$.classType(Node.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)nodeOps.getProperty(0L, 0)).thenAnswer((Answer)new Answer<Object>(this){

                    public int answer(InvocationOnMock invocation) {
                        return 1;
                    }
                });
                Mockito.when((Object)this.$outer.qtx().nodeOps()).thenReturn((Object)nodeOps);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx("v", (Expression)expression)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx("c", (Expression)expression)).should(this.$outer.equal(null), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles relationship lookup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship rel = (Relationship)this.$outer.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)rel.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
                Literal expression = new Literal((Object)rel);
                Mockito.when((Object)this.$outer.qtx().getOptPropertyKeyId("v")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
                Mockito.when((Object)this.$outer.qtx().getOptPropertyKeyId("c")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Operations relOps = (Operations)this.$outer.mock(ManifestFactory$.MODULE$.classType(Operations.class, ManifestFactory$.MODULE$.classType(Relationship.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)relOps.getProperty(0L, 0)).thenAnswer((Answer)new Answer<Object>(this){

                    public int answer(InvocationOnMock invocation) {
                        return 1;
                    }
                });
                Mockito.when((Object)this.$outer.qtx().relationshipOps()).thenReturn((Object)relOps);
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx("v", (Expression)expression)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ContainerIndexTest$$idx("c", (Expression)expression)).should(this.$outer.equal(null), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("when collection is a CTAny then type is a collection of CTAny", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContainerIndexTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                FakeExpression collection = new FakeExpression((CypherType)package$.MODULE$.CTAny());
                SymbolTable symbols = new SymbolTable(SymbolTable$.MODULE$.$lessinit$greater$default$1());
                CypherType result = new ContainerIndex((Expression)collection, (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2))).evaluateType((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), symbols);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(package$.MODULE$.CTAny()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

