/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.planDescription;

import java.util.Locale;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Identifier;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.LengthFunction;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Property;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Equals;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.HasLabel;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Not;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Predicate;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.PropertyExists;
import org.neo4j.cypher.internal.compiler.v2_3.commands.values.KeyToken;
import org.neo4j.cypher.internal.compiler.v2_3.commands.values.TokenType;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.ExpandAllPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.LazyLabel;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.LazyTypes$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.NodeByLabelScanPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.NodeHashJoinPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.SingleRowPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.VarLengthExpandPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.VarLengthExpandPipe$;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.Argument;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.Children;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.Id;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.NoChildren$;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.PlanDescriptionImpl;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.SingleChild;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.TwoChildren;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.renderAsTreeTable$;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticDirection;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001#\t\u0019\"+\u001a8eKJ$&/Z3UC\ndW\rV3ti*\u00111\u0001B\u0001\u0010a2\fg\u000eR3tGJL\u0007\u000f^5p]*\u0011QAB\u0001\u0005mJz6G\u0003\u0002\b\u0011\u0005A1m\\7qS2,'O\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u001c!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0006/)\u0011\u0001\u0004C\u0001\tMJ|g\u000e^3oI&\u0011!\u0004\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f!\tar$D\u0001\u001e\u0015\tqb\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0001%\b\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0007\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0003\u0011\u001d9\u0003A1A\u0005\n!\nQ\u0002Z3gCVdG\u000fT8dC2,W#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001B;uS2T\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t1Aj\\2bY\u0016DaA\r\u0001!\u0002\u0013I\u0013A\u00043fM\u0006,H\u000e\u001e'pG\u0006dW\r\t\u0005\u0006i\u0001!\t%N\u0001\nE\u00164wN]3BY2$\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0005+:LG\u000fC\u0003>\u0001\u0011\u0005S'\u0001\u0005bMR,'/\u00117m\u0011\u001dy\u0004A1A\u0005\u0002\u0001\u000bA\u0001]5qKV\t\u0011\t\u0005\u0002C\u000b6\t1I\u0003\u0002E\t\u0005)\u0001/\u001b9fg&\u0011ai\u0011\u0002\u000e'&tw\r\\3S_^\u0004\u0016\u000e]3\t\r!\u0003\u0001\u0015!\u0003B\u0003\u0015\u0001\u0018\u000e]3!\u0001")
public class RenderTreeTableTest
extends CypherFunSuite
implements BeforeAndAfterAll {
    private final Locale defaultLocale;
    private final SingleRowPipe pipe;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    private Locale defaultLocale() {
        return this.defaultLocale;
    }

    public void beforeAll() {
        Locale.setDefault(Locale.US);
    }

    public void afterAll() {
        Locale.setDefault(this.defaultLocale());
    }

    public SingleRowPipe pipe() {
        return this.pipe;
    }

    public RenderTreeTableTest() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        this.defaultLocale = Locale.getDefault();
        this.test("node feeding from other node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = leaf.andThen(new Id(), "ROOT", (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0]));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+\n        || Operator |\n        |+----------+\n        || +ROOT    |\n        || |        +\n        || +LEAF    |\n        |+----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("node feeding from two nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(new Id(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(new Id(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+\n        || Operator |\n        |+----------+\n        || +ROOT    |\n        || |\\       +\n        || | +LEAF2 |\n        || |        +\n        || +LEAF1   |\n        |+----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("node feeding of node that is feeding of node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate = new PlanDescriptionImpl(new Id(), "INTERMEDIATE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new SingleChild((InternalPlanDescription)intermediate), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+---------------+\n        || Operator      |\n        |+---------------+\n        || +ROOT         |\n        || |             +\n        || +INTERMEDIATE |\n        || |             +\n        || +LEAF         |\n        |+---------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("root with two leafs, one of which is deep", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(new Id(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(new Id(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(new Id(), "LEAF3", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate = new PlanDescriptionImpl(new Id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf3, (InternalPlanDescription)intermediate), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+\n        || Operator        |\n        |+-----------------+\n        || +ROOT           |\n        || |\\              +\n        || | +INTERMEDIATE |\n        || | |\\            +\n        || | | +LEAF2      |\n        || | |             +\n        || | +LEAF1        |\n        || |               +\n        || +LEAF3          |\n        |+-----------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("root with two intermediate nodes coming from four leaf nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})));
                PlanDescriptionImpl leaf4 = new PlanDescriptionImpl(new Id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
                PlanDescriptionImpl intermediate1 = new PlanDescriptionImpl(new Id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate2 = new PlanDescriptionImpl(new Id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf3, (InternalPlanDescription)leaf4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)intermediate1, (InternalPlanDescription)intermediate2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+-------------+\n        || Operator        | Identifiers |\n        |+-----------------+-------------+\n        || +ROOT           |             |\n        || |\\              +-------------+\n        || | +INTERMEDIATE |             |\n        || | |\\            +-------------+\n        || | | +LEAF       | d           |\n        || | |             +-------------+\n        || | +LEAF         | c           |\n        || |               +-------------+\n        || +INTERMEDIATE   |             |\n        || |\\              +-------------+\n        || | +LEAF         | b           |\n        || |               +-------------+\n        || +LEAF           | a           |\n        |+-----------------+-------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("complex tree", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(new Id(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(new Id(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(9L), new InternalPlanDescription.Arguments$.DbHits(2L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(new Id(), "LEAF3", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(9L), new InternalPlanDescription.Arguments$.DbHits(2L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl pass = new PlanDescriptionImpl(new Id(), "PASS", (Children)new SingleChild((InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(4L), new InternalPlanDescription.Arguments$.DbHits(0L), new InternalPlanDescription.Arguments$.EstimatedRows(4.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl inner = new PlanDescriptionImpl(new Id(), "INNER", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)pass), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(7L), new InternalPlanDescription.Arguments$.DbHits(42L), new InternalPlanDescription.Arguments$.EstimatedRows(6.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf3, (InternalPlanDescription)inner), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(3L), new InternalPlanDescription.Arguments$.DbHits(0L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl parent = new PlanDescriptionImpl(new Id(), "PARENT", (Children)new SingleChild((InternalPlanDescription)plan), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)parent)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------+----------------+------+---------+\n        || Operator   | Estimated Rows | Rows | DB Hits |\n        |+------------+----------------+------+---------+\n        || +PARENT    |                |      |         |\n        || |          +----------------+------+---------+\n        || +ROOT      |              1 |    3 |       0 |\n        || |\\         +----------------+------+---------+\n        || | +INNER   |              6 |    7 |      42 |\n        || | |\\       +----------------+------+---------+\n        || | | +PASS  |              4 |    4 |       0 |\n        || | | |      +----------------+------+---------+\n        || | | +LEAF2 |              1 |    9 |       2 |\n        || | |        +----------------+------+---------+\n        || | +LEAF1   |              1 |   42 |      33 |\n        || |          +----------------+------+---------+\n        || +LEAF3     |              1 |    9 |       2 |\n        |+------------+----------------+------+---------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.pipe = new SingleRowPipe((PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
        this.test("single node is represented nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers |\n        |+----------+----------------+------+---------+-------------+\n        || +NAME    |              1 |   42 |      33 | n           |\n        |+----------+----------------+------+---------+-------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("extra identifiers are not a problem", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers |\n        |+----------+----------------+------+---------+-------------+\n        || +NAME    |              1 |   42 |      33 | a, b, c     |\n        |+----------+----------------+------+---------+-------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("super many identifiers stretches the column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d", "e", "f"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers      |\n        |+----------+----------------+------+---------+------------------+\n        || +NAME    |              1 |   42 |      33 | a, b, c, d, e, f |\n        |+----------+----------------+------+---------+------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("execution plan without profiler stats are not shown", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.EstimatedRows[]{new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+-------------+\n        || Operator | Estimated Rows | Identifiers |\n        |+----------+----------------+-------------+\n        || +NAME    |              1 | n           |\n        |+----------+----------------+-------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plan information is rendered on the corresponding row to the tree", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq args1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                Seq args2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(2L), new InternalPlanDescription.Arguments$.DbHits(633L), new InternalPlanDescription.Arguments$.Index("Label", "Prop"), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan1 = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, args1, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl plan2 = new PlanDescriptionImpl(new Id(), "NAME", (Children)new SingleChild((InternalPlanDescription)plan1), args2, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan2)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+--------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers | Other        |\n        |+----------+----------------+------+---------+-------------+--------------+\n        || +NAME    |              1 |    2 |     633 | b           | :Label(Prop) |\n        || |        +----------------+------+---------+-------------+--------------+\n        || +NAME    |              1 |   42 |      33 | a           |              |\n        |+----------+----------------+------+---------+-------------+--------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Expand contains information about its relations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExpandAllPipe expandPipe = new ExpandAllPipe((Pipe)this.$outer.pipe(), "from", "rel", "to", (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, LazyTypes$.MODULE$.empty(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(expandPipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+----------------+-------------+---------------------+\n        || Operator     | Estimated Rows | Identifiers | Other               |\n        |+--------------+----------------+-------------+---------------------+\n        || +Expand(All) |              1 | rel, to     | (from)<-[rel:]-(to) |\n        |+--------------+----------------+-------------+---------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Label scan should be just as pretty as you would expect", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NodeByLabelScanPipe pipe = new NodeByLabelScanPipe("n", new LazyLabel("Foo"), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(pipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------------+----------------+-------------+-------+\n        || Operator         | Estimated Rows | Identifiers | Other |\n        |+------------------+----------------+-------------+-------+\n        || +NodeByLabelScan |              1 | n           | :Foo  |\n        |+------------------+----------------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Var length expand contains information about its relations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VarLengthExpandPipe expandPipe = new VarLengthExpandPipe((Pipe)this.$outer.pipe(), "from", "rel", "to", (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, LazyTypes$.MODULE$.empty(), 0, (Option)None$.MODULE$, false, VarLengthExpandPipe$.MODULE$.apply$default$11(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(expandPipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------------+----------------+-------------+----------------------+\n        || Operator              | Estimated Rows | Identifiers | Other                |\n        |+-----------------------+----------------+-------------+----------------------+\n        || +VarLengthExpand(All) |              1 | rel, to     | (from)-[rel:*]->(to) |\n        |+-----------------------+----------------+-------------+----------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("do not show unnamed identifiers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.ExpandExpression("  UNNAMED123", "R", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHOOP"})), "  UNNAMED24", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, InternalPlanDescription.Arguments$.ExpandExpression$.MODULE$.apply$default$6()), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n", "  UNNAMED123", "  FRESHID12", "  AGGREGATION255"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------------------------------+------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers                       | Other            |\n        |+----------+----------------+------+---------+-----------------------------------+------------------+\n        || +NAME    |              1 |   42 |      33 | anon[255], anon[12], anon[123], n | ()-[R:WHOOP]->() |\n        |+----------+----------------+------+---------+-----------------------------------+------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show multiple relationship types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.ExpandExpression("source", "through", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SOME", "OTHER", "THING"})), "target", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, InternalPlanDescription.Arguments$.ExpandExpression$.MODULE$.apply$default$6()), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+-------------------------------------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers | Other                                           |\n        |+----------+----------------+------+---------+-------------+-------------------------------------------------+\n        || +NAME    |              1 |   42 |      33 | n           | (source)-[through:SOME|:OTHER|:THING]->(target) |\n        |+----------+----------------+------+---------+-------------+-------------------------------------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show nicer output instead of unnamed identifiers in equals expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Not((Predicate)new Equals((Expression)new Identifier("  UNNAMED123"), (Expression)new Identifier("  UNNAMED321")))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+-----------------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers | Other                       |\n        |+----------+----------------+------+---------+-------------+-----------------------------+\n        || +NAME    |              1 |   42 |      33 | n           | NOT(anon[123] == anon[321]) |\n        |+----------+----------------+------+---------+-------------+-----------------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show hasLabels nicely without token id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new HasLabel((Expression)new Identifier("x"), (KeyToken)new KeyToken.Resolved("Artist", 5, (TokenType)TokenType.Label$.MODULE$))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers | Other    |\n        |+----------+----------------+------+---------+-------------+----------+\n        || +NAME    |              1 |   42 |      33 | n           | x:Artist |\n        |+----------+----------------+------+---------+-------------+----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("format length properly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new LengthFunction((Expression)new Identifier("n"))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+-----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers | Other     |\n        |+----------+----------------+------+---------+-------------+-----------+\n        || +NAME    |              1 |   42 |      33 | n           | length(n) |\n        |+----------+----------------+------+---------+-------------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't leak deduped names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Identifier("  id@23")), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  n@76"})));
                String details = renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan);
                this.$outer.convertToStringShouldWrapper(details).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+-------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers | Other |\n        |+----------+----------------+------+---------+-------------+-------+\n        || +NAME    |              1 |   42 |      33 | n           | id    |\n        |+----------+----------------+------+---------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't render planner in Other", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.Planner("COST"), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Identifier("  id@23")), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+-------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers | Other |\n        |+----------+----------------+------+---------+-------------+-------+\n        || +NAME    |              1 |   42 |      33 | n           | id    |\n        |+----------+----------------+------+---------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("round estimated rows to int", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NodeByLabelScanPipe pipe1 = new NodeByLabelScanPipe("n", new LazyLabel("Foo"), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)0.00123456789)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                NodeByLabelScanPipe pipe2 = new NodeByLabelScanPipe("n", new LazyLabel("Foo"), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.23456789)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(pipe1.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------------+----------------+-------------+-------+\n        || Operator         | Estimated Rows | Identifiers | Other |\n        |+------------------+----------------+-------------+-------+\n        || +NodeByLabelScan |              0 | n           | :Foo  |\n        |+------------------+----------------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(pipe2.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------------+----------------+-------------+-------+\n        || Operator         | Estimated Rows | Identifiers | Other |\n        |+------------------+----------------+-------------+-------+\n        || +NodeByLabelScan |              1 | n           | :Foo  |\n        |+------------------+----------------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("properly show Property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Property((Expression)new Identifier("x"), (KeyToken)new KeyToken.Resolved("Artist", 5, (TokenType)TokenType.PropertyKey$.MODULE$))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers | Other    |\n        |+----------+----------------+------+---------+-------------+----------+\n        || +NAME    |              1 |   42 |      33 | n           | x.Artist |\n        |+----------+----------------+------+---------+-------------+----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show hasProp with identifier and property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new PropertyExists((Expression)new Identifier("x"), (KeyToken)new KeyToken.Resolved("prop", 42, (TokenType)TokenType.PropertyKey$.MODULE$))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(new Id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-------------+-----------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Identifiers | Other           |\n        |+----------+----------------+------+---------+-------------+-----------------+\n        || +NAME    |              1 |   42 |      33 | n           | hasProp(x.prop) |\n        |+----------+----------------+------+---------+-------------+-----------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't show unnamed identifiers in key names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NodeHashJoinPipe joinPipe = new NodeHashJoinPipe((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "  UNNAMED45", "  FRESHID77"})), (Pipe)this.$outer.pipe(), (Pipe)this.$outer.pipe(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)42.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply(joinPipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+---------------+----------------+-----------------------+\n        || Operator      | Estimated Rows | Other                 |\n        |+---------------+----------------+-----------------------+\n        || +NodeHashJoin |             42 | a, anon[45], anon[77] |\n        || |\\            +----------------+-----------------------+\n        || | +Argument   |              1 |                       |\n        || |             +----------------+-----------------------+\n        || +Argument     |              1 |                       |\n        |+---------------+----------------+-----------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

