/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.planner;

import org.neo4j.cypher.internal.frontend.v2_3.ExpressionTypeInfo;
import org.neo4j.cypher.internal.frontend.v2_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v2_3.InternalException;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticTable;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticTable$;
import org.neo4j.cypher.internal.frontend.v2_3.ast.ASTAnnotationMap$;
import org.neo4j.cypher.internal.frontend.v2_3.ast.ASTNode;
import org.neo4j.cypher.internal.frontend.v2_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v2_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Identifier;
import org.neo4j.cypher.internal.frontend.v2_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.TypeSpec;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.TypeSpec$;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.package$;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001#\t\t2+Z7b]RL7\rV1cY\u0016$Vm\u001d;\u000b\u0005\r!\u0011a\u00029mC:tWM\u001d\u0006\u0003\u000b\u0019\tAA\u001e\u001a`g)\u0011q\u0001C\u0001\tG>l\u0007/\u001b7fe*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u00112\u0004\u0005\u0002\u001435\tAC\u0003\u0002\u0016-\u0005aA/Z:u?\",G\u000e]3sg*\u0011Qa\u0006\u0006\u00031!\t\u0001B\u001a:p]R,g\u000eZ\u0005\u00035Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\r\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f-\u0005\u0019\u0011m\u001d;\n\u0005\u0001j\"AG!ti\u000e{gn\u001d;sk\u000e$\u0018n\u001c8UKN$8+\u001e9q_J$\b\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\bF\u0001%!\t)\u0003!D\u0001\u0003\u0011\u00159\u0003\u0001b\u0011)\u0003\u0015IG-\u001a8u)\tIC\u0006\u0005\u0002\u001dU%\u00111&\b\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\b\"B\u0017'\u0001\u0004q\u0013\u0001\u00028b[\u0016\u0004\"aL\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003iE\u0002")
public class SemanticTableTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v2_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public HasLabels hasLabels(String identifier, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)identifier, (String)label);
    }

    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)identifier, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public Identifier ident(String name) {
        return new Identifier(name, this.pos());
    }

    public SemanticTableTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.test("can add nodes to a SemanticTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = SemanticTable$.MODULE$.apply(SemanticTable$.MODULE$.apply$default$1(), SemanticTable$.MODULE$.apply$default$2()).addNode(this.$outer.ident("x"));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)table.isNode("x"))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)table.isRelationship("x"))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("can add rels to a SemanticTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = SemanticTable$.MODULE$.apply(SemanticTable$.MODULE$.apply$default$1(), SemanticTable$.MODULE$.apply$default$2()).addRelationship(this.$outer.ident("r"));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)table.isRelationship("r"))).should(this.$outer.be().apply(true));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)table.isNode("r"))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("doesn't share mutable references after being copied", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table1 = SemanticTable$.MODULE$.apply(SemanticTable$.MODULE$.apply$default$1(), SemanticTable$.MODULE$.apply$default$2());
                SemanticTable table2 = table1.copy(table1.copy$default$1(), table1.copy$default$2(), table1.copy$default$3(), table1.copy$default$4(), table1.copy$default$5());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((table1.resolvedLabelIds() == table2.resolvedLabelIds() ? 1 : 0) != 0)).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((table1.resolvedPropertyKeyNames() == table2.resolvedPropertyKeyNames() ? 1 : 0) != 0)).should(this.$outer.be().apply(false));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((table1.resolvedRelTypeNames() == table2.resolvedRelTypeNames() ? 1 : 0) != 0)).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to tell the type of an identifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = SemanticTable$.MODULE$.apply(SemanticTable$.MODULE$.apply$default$1(), SemanticTable$.MODULE$.apply$default$2()).addNode(new Identifier("a", new InputPosition(1, 2, 3))).addRelationship(new Identifier("b", new InputPosition(1, 2, 3)));
                this.$outer.convertToAnyShouldWrapper(table.getTypeFor("a")).should(this.$outer.be().apply((Object)package$.MODULE$.CTNode().invariant()));
                this.$outer.convertToAnyShouldWrapper(table.getTypeFor("b")).should(this.$outer.be().apply((Object)package$.MODULE$.CTRelationship().invariant()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to tell the type of an identifier if there is an unknown type involved", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = SemanticTable$.MODULE$.apply(ASTAnnotationMap$.MODULE$.empty().updated((ASTNode)new Identifier("a", new InputPosition(0, 0, 0)), (Object)new ExpressionTypeInfo(TypeSpec$.MODULE$.all(), (Option)None$.MODULE$)), SemanticTable$.MODULE$.apply$default$2()).addNode(new Identifier("a", new InputPosition(1, 2, 3)));
                this.$outer.convertToAnyShouldWrapper(table.getTypeFor("a")).should(this.$outer.be().apply((Object)package$.MODULE$.CTNode().invariant()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to tell the type of an identifier if there is an unknown type involved other order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = SemanticTable$.MODULE$.apply(ASTAnnotationMap$.MODULE$.empty().updated((ASTNode)new Identifier("a", new InputPosition(1, 2, 3)), (Object)new ExpressionTypeInfo(package$.MODULE$.CTNode().invariant(), (Option)None$.MODULE$)).updated((ASTNode)new Identifier("a", new InputPosition(0, 0, 0)), (Object)new ExpressionTypeInfo(TypeSpec$.MODULE$.all(), (Option)None$.MODULE$)), SemanticTable$.MODULE$.apply$default$2());
                this.$outer.convertToAnyShouldWrapper(table.getTypeFor("a")).should(this.$outer.be().apply((Object)package$.MODULE$.CTNode().invariant()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail when asking for an unknown identifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = SemanticTable$.MODULE$.apply(SemanticTable$.MODULE$.apply$default$1(), SemanticTable$.MODULE$.apply$default$2());
                this.$outer.intercept((Function0)new Serializable(this, table){
                    public static final long serialVersionUID = 0L;
                    private final SemanticTable table$1;

                    public final TypeSpec apply() {
                        return this.table$1.getTypeFor("a");
                    }
                    {
                        this.table$1 = table$1;
                    }
                }, ManifestFactory$.MODULE$.classType(InternalException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail if the semantic table is confusing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticTable table = SemanticTable$.MODULE$.apply(ASTAnnotationMap$.MODULE$.empty().updated((ASTNode)new Identifier("a", new InputPosition(1, 2, 3)), (Object)new ExpressionTypeInfo(package$.MODULE$.CTNode().invariant(), (Option)None$.MODULE$)).updated((ASTNode)new Identifier("a", new InputPosition(0, 0, 0)), (Object)new ExpressionTypeInfo(package$.MODULE$.CTRelationship().invariant(), (Option)None$.MODULE$)), SemanticTable$.MODULE$.apply$default$2());
                this.$outer.intercept((Function0)new Serializable(this, table){
                    public static final long serialVersionUID = 0L;
                    private final SemanticTable table$2;

                    public final TypeSpec apply() {
                        return this.table$2.getTypeFor("a");
                    }
                    {
                        this.table$2 = table$2;
                    }
                }, ManifestFactory$.MODULE$.classType(InternalException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

