/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.symbols;

import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Add;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.FakeExpression;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.SymbolTable;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.SymbolTable$;
import org.neo4j.cypher.internal.frontend.v2_3.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v2_3.SyntaxException;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.CollectionType;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.CypherType;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.package$;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001#\ty1+_7c_2$\u0016M\u00197f)\u0016\u001cHO\u0003\u0002\u0004\t\u000591/_7c_2\u001c(BA\u0003\u0007\u0003\u00111(gX\u001a\u000b\u0005\u001dA\u0011\u0001C2p[BLG.\u001a:\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111#G\u0007\u0002))\u0011QCF\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000b]Q!\u0001\u0007\u0005\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!A\u0007\u000b\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")A\u0004\u0001C\u0001;\u00051A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011A\u0001\u0005\u0006\u0007\u0001!\t!\t\u000b\u0003E\u0015\u0002\"aH\u0012\n\u0005\u0011\u0012!aC*z[\n|G\u000eV1cY\u0016DQA\n\u0011A\u0002\u001d\nQ!\u001a7f[N\u00042\u0001K\u0016.\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#A\u0003\u001fsKB,\u0017\r^3e}A!\u0001F\f\u00198\u0013\ty\u0013F\u0001\u0004UkBdWM\r\t\u0003cQr!\u0001\u000b\u001a\n\u0005MJ\u0013A\u0002)sK\u0012,g-\u0003\u00026m\t11\u000b\u001e:j]\u001eT!aM\u0015\u0011\u0005aRT\"A\u001d\u000b\u0005\r1\u0012BA\u001e:\u0005)\u0019\u0015\u0010\u001d5feRK\b/\u001a")
public class SymbolTableTest
extends CypherFunSuite {
    public SymbolTable symbols(Seq<Tuple2<String, CypherType>> elems) {
        return new SymbolTable((Map)elems.toMap(Predef$.MODULE$.$conforms()));
    }

    public SymbolTableTest() {
        this.test("anytype_is_ok", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable s = this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p"), (Object)package$.MODULE$.CTPath())}));
                this.$outer.convertToAnyShouldWrapper(s.evaluateType("p", (CypherType)package$.MODULE$.CTAny())).should(this.$outer.equal(package$.MODULE$.CTPath()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("missing_identifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable s = this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Nil$.MODULE$);
                this.$outer.intercept((Function0)new Serializable(this, s){
                    public static final long serialVersionUID = 0L;
                    private final SymbolTable s$1;

                    public final CypherType apply() {
                        return this.s$1.evaluateType("p", (CypherType)package$.MODULE$.CTAny());
                    }
                    {
                        this.s$1 = s$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SyntaxException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("identifier_with_wrong_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable symbolTable = this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)package$.MODULE$.CTString())}));
                this.$outer.intercept((Function0)new Serializable(this, symbolTable){
                    public static final long serialVersionUID = 0L;
                    private final SymbolTable symbolTable$1;

                    public final CypherType apply() {
                        return this.symbolTable$1.evaluateType("x", (CypherType)package$.MODULE$.CTNumber());
                    }
                    {
                        this.symbolTable$1 = symbolTable$1;
                    }
                }, ManifestFactory$.MODULE$.classType(CypherTypeException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("identifier_with_type_not_specific_enough", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable symbolTable = this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)package$.MODULE$.CTMap())}));
                symbolTable.evaluateType("x", (CypherType)package$.MODULE$.CTRelationship());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("adding_string_with_string_gives_string_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable symbolTable = this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Nil$.MODULE$);
                Add exp = new Add((Expression)new FakeExpression((CypherType)package$.MODULE$.CTString()), (Expression)new FakeExpression((CypherType)package$.MODULE$.CTString()));
                CypherType returnType = exp.evaluateType((CypherType)package$.MODULE$.CTAny(), symbolTable);
                this.$outer.convertToAnyShouldWrapper(returnType).should(this.$outer.equal(package$.MODULE$.CTString()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("adding_number_with_number_gives_number_type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable symbolTable = this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Nil$.MODULE$);
                Add exp = new Add((Expression)new FakeExpression((CypherType)package$.MODULE$.CTNumber()), (Expression)new FakeExpression((CypherType)package$.MODULE$.CTNumber()));
                CypherType returnType = exp.evaluateType((CypherType)package$.MODULE$.CTAny(), symbolTable);
                this.$outer.convertToAnyShouldWrapper(returnType).should(this.$outer.equal(package$.MODULE$.CTNumber()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("adding_to_string_collection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable symbolTable = this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Nil$.MODULE$);
                Add exp = new Add((Expression)new FakeExpression((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())), (Expression)new FakeExpression((CypherType)package$.MODULE$.CTString()));
                CypherType returnType = exp.evaluateType((CypherType)package$.MODULE$.CTAny(), symbolTable);
                this.$outer.convertToAnyShouldWrapper(returnType).should(this.$outer.equal(package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("covariance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CollectionType.CollectionTypeImpl actual = package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTNode());
                CollectionType.CollectionTypeImpl expected = package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTMap());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)expected.isAssignableFrom((CypherType)actual))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of two symbol tables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(new SymbolTable(SymbolTable$.MODULE$.apply$default$1()).intersect(new SymbolTable(SymbolTable$.MODULE$.apply$default$1()))).should(this.$outer.equal(new SymbolTable(SymbolTable$.MODULE$.apply$default$1())), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString())})).intersect(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString())})))).should(this.$outer.equal(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString())}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString())})).intersect(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTAny())})))).should(this.$outer.equal(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTAny())}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString())})).intersect(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTNumber())})))).should(this.$outer.equal(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)((CypherType)package$.MODULE$.CTString()).leastUpperBound((CypherType)package$.MODULE$.CTNumber()))}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTString())})).intersect(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)package$.MODULE$.CTString())})))).should(this.$outer.equal(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString())}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTString())})).intersect(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Nil$.MODULE$))).should(this.$outer.equal(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString())})).intersect(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString())})))).should(this.$outer.equal(this.$outer.symbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)package$.MODULE$.CTString())}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

