/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters;

import org.apache.commons.lang3.SystemUtils;
import org.neo4j.cypher.internal.compiler.v2_3.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.InlineProjectionsTest$;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.expandStar;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.inlineProjections$;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.compiler.v2_3.planner.AstRewritingTestSupport;
import org.neo4j.cypher.internal.compiler.v2_3.planner.AstRewritingTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_3.planner.CantHandleQueryException;
import org.neo4j.cypher.internal.frontend.v2_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v2_3.Rewritable;
import org.neo4j.cypher.internal.frontend.v2_3.Rewritable$;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticState$;
import org.neo4j.cypher.internal.frontend.v2_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v2_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Identifier;
import org.neo4j.cypher.internal.frontend.v2_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Statement;
import org.neo4j.cypher.internal.frontend.v2_3.inSequence$;
import org.neo4j.cypher.internal.frontend.v2_3.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001'\t)\u0012J\u001c7j]\u0016\u0004&o\u001c6fGRLwN\\:UKN$(BA\u0002\u0005\u0003%\u0011Xm\u001e:ji\u0016\u00148O\u0003\u0002\u0006\r\u0005\u0019\u0011m\u001d;\u000b\u0005\u001dA\u0011\u0001\u0002<3?NR!!\u0003\u0006\u0002\u0011\r|W\u000e]5mKJT!a\u0003\u0007\u0002\u0011%tG/\u001a:oC2T!!\u0004\b\u0002\r\rL\b\u000f[3s\u0015\ty\u0001#A\u0003oK>$$NC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001A#\b\t\u0003+mi\u0011A\u0006\u0006\u0003/a\tA\u0002^3ti~CW\r\u001c9feNT!aB\r\u000b\u0005iQ\u0011\u0001\u00034s_:$XM\u001c3\n\u0005q1\"AD\"za\",'OR;o'VLG/\u001a\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\tq\u0001\u001d7b]:,'/\u0003\u0002#?\t9\u0012i\u001d;SK^\u0014\u0018\u000e^5oOR+7\u000f^*vaB|'\u000f\u001e\u0005\u0006I\u0001!\t!J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"a\n\u0001\u000e\u0003\tAQ!\u000b\u0001\u0005\n)\nA\u0003\u001d:pU\u0016\u001cG/[8o\u0013:d\u0017N\\3e\u0003N$HCA\u00161!\tac&D\u0001.\u0015\t)\u0001$\u0003\u00020[\tI1\u000b^1uK6,g\u000e\u001e\u0005\u0006c!\u0002\rAM\u0001\ncV,'/\u001f+fqR\u0004\"aM\u001d\u000f\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qUBQ!\u0002\u0001\u0005\nu\"\"a\u000b \t\u000bEb\u0004\u0019\u0001\u001a")
public class InlineProjectionsTest
extends CypherFunSuite
implements AstRewritingTestSupport {
    private final CypherParser parser;
    private final InputPosition pos;

    @Override
    public CypherParser parser() {
        return this.parser;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$planner$AstRewritingTestSupport$_setter_$parser_$eq(CypherParser x$1) {
        this.parser = x$1;
    }

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v2_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Identifier ident(String name) {
        return AstConstructionTestSupport.class.ident((AstConstructionTestSupport)this, (String)name);
    }

    public HasLabels hasLabels(String identifier, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)identifier, (String)label);
    }

    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)identifier, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public Statement org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(String queryText) {
        return (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)this.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(queryText)), (Function1)inlineProjections$.MODULE$);
    }

    public Statement org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(String queryText) {
        Statement parsed = this.parser().parse(queryText, this.parser().parse$default$2());
        SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(queryText, (Option)new Some((Object)this.pos()));
        Statement normalized = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)parsed), (Function1)inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
        SemanticCheckResult checkResult = (SemanticCheckResult)normalized.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
        return (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)normalized), (Function1)inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new expandStar(checkResult.state())})));
    }

    public InlineProjectionsTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        AstRewritingTestSupport$class.$init$(this);
        this.test("should inline: MATCH a, b, c WITH c AS c, b AS a RETURN c", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH a, b, c\n        |WITH c AS c, b AS d\n        |RETURN c\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH a, b, c\n        |WITH c AS c, b AS b\n        |RETURN c AS c\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline: WITH {b} AS tmp, {r} AS r WITH {a} AS b AS a, r LIMIT 1 MATCH (a)-[r]->(b) RETURN a, r, b", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH {a} AS b, {b} AS tmp, {r} AS r\n        |WITH b AS a, r LIMIT 1\n        |MATCH (a)-[r]->(b)\n        |RETURN a, r, b\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("\n                               |WITH {a} AS b, {r} AS r\n                               |WITH b AS a, r LIMIT 1\n                               |MATCH (a)-[r]->(b)\n                               |RETURN a, r, b\n                             ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline: MATCH a, b, c WITH c AS d, b AS a RETURN d", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH a, b, c\n        |WITH c AS d, b AS e\n        |RETURN d\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH a, b, c\n        |WITH c AS c, b AS b\n        |RETURN c AS d\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should  inline: MATCH n WITH n AS m RETURN m => MATCH n RETURN n", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS m\n        |RETURN m\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n\n        |RETURN n AS m\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should  inline: MATCH (a:Start) WITH a.prop AS property LIMIT 1 MATCH (b) WHERE id(b) = property RETURN b", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH (a:Start)\n        |WITH a.prop AS property LIMIT 1\n        |MATCH (b) WHERE id(b) = property\n        |RETURN b, property\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH (a:Start) WITH a LIMIT 1\n        |MATCH (b) WHERE id(b) = a.prop\n        |RETURN b, a.prop AS property\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline: MATCH (a) WITH a WHERE TRUE RETURN a", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH (a)\n        |WITH a WHERE TRUE\n        |RETURN a\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.parser().parse(new StringOps(Predef$.MODULE$.augmentString("MATCH (a)\n        |WITH a AS a\n        |WITH a AS a WHERE true\n        |WITH a AS a\n        |RETURN a AS a\n      ")).stripMargin(), this.$outer.parser().parse$default$2())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline pattern identifiers when possible", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n\n        |MATCH n-->x\n        |RETURN x\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n\n        |MATCH n-->x\n        |RETURN x")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline: WITH 1 AS x RETURN 1 + x => _PRAGMA WITH NONE RETURN 1 + 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH 1 AS x\n        |RETURN 1 + x\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("_PRAGMA WITH NONE\n        |RETURN 1 + 1 AS `1 + x`\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline: WITH 1 as b RETURN b => RETURN 1 AS `b`", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH 1 as b\n        |RETURN b\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("_PRAGMA WITH NONE\n        |RETURN 1 AS `b`\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not inline aggregations: WITH 1 as b WITH DISTINCT b AS c RETURN c => WITH DISTINCT 1 AS c RETURN c AS c", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH 1 as b\n        |WITH DISTINCT b AS c\n        |RETURN c\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("_PRAGMA WITH NONE\n        |WITH DISTINCT 1 AS `c`\n        |RETURN c AS `c`\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not inline identifiers into patterns: WITH {node} as a MATCH (a) RETURN a => WITH {node} as a MATCH (a) RETURN a AS `a`", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH {node} as a\n        |MATCH (a)\n        |RETURN a\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("WITH {node} as a\n        |MATCH (a)\n        |RETURN a AS `a`\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline multiple identifiers across multiple WITH clauses: WITH 1 as n WITH n+1 AS m RETURN m => RETURN 1+1 as m", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH 1 as n\n        |WITH n + 1 AS m\n        |RETURN m\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("_PRAGMA WITH NONE\n        |_PRAGMA WITH NONE\n        |RETURN 1+1 as `m`\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline node patterns: MATCH (a) WITH a as b MATCH (b) RETURN b => MATCH (a) _PRAGMA WITH NONE MATCH (a) RETURN a as `b`", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH (a)\n        |WITH a as b\n        |MATCH (b)\n        |RETURN b\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH (a)\n        |WITH a AS a\n        |MATCH (a)\n        |RETURN a as `b`\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline relationship patterns: MATCH ()-[a]->() WITH a as b MATCH ()-[b]->() RETURN b => MATCH ()-[a]->() _PRAGMA WITH NONE MATCH ()-[a]->() RETURN a as `b`", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH ()-[a]->()\n        |WITH a as b\n        |MATCH ()-[b]->()\n        |RETURN b\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH ()-[a]->()\n        |WITH a AS a\n        |MATCH ()-[a]->()\n        |RETURN a as `b`\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not inline aggregations: MATCH (a)-[r]->() WITH a, count(r) as b RETURN b as `b`", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH (a)-[r]->()\n        |WITH a, count(r) as b\n        |RETURN b as `b`\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH (a)-[r]->()\n        |WITH a, count(r) as b\n        |RETURN b as `b`\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not inline aggregations: MATCH (a)-[r]->() RETURN a, count(r) as `b`", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH (a)-[r]->()\n        |RETURN a, count(r) as `b`\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH (a)-[r]->()\n        |RETURN a, count(r) as `b`\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not inline identifiers which are reused multiple times: WITH 1 as n WITH 2 AS n RETURN n", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$17 $outer;

                    public final Statement apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH 1 as n\n        |WITH 2 AS n\n        |RETURN n\n      ")).stripMargin());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }

            public /* synthetic */ InlineProjectionsTest org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline same identifier across multiple WITH clauses, case #1: WITH 1 as n WITH n+1 AS n RETURN n => RETURN 1+1 as n", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;

                    public final Statement apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH 1 as n\n        |WITH n+1 AS n\n        |RETURN n\n      ")).stripMargin());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }

            public /* synthetic */ InlineProjectionsTest org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should inline same identifier across multiple WITH clauses, case #2: WITH 1 as n WITH n+2 AS m WITH n + m as n RETURN n => RETURN 1+1+2 as n", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;

                    public final Statement apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH 1 as n\n        |WITH n+2 AS m\n        |WITH n + m as n\n        |RETURN n\n      ")).stripMargin());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }

            public /* synthetic */ InlineProjectionsTest org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not inline identifiers which cannot be inlined when they are shadowed later on: WITH 1 as n MATCH (n) WITH 2 AS n RETURN n => WITH 1 as n MATCH (n) RETURN 2 as n", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final Statement apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH 1 as n\n        |MATCH (n)\n        |WITH 2 AS n\n        |RETURN n\n      ")).stripMargin());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }

            public /* synthetic */ InlineProjectionsTest org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should refuse to inline queries containing update clauses by throwing CantHandleQueryException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$21 $outer;

                    public final Statement apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("CREATE (n)\n          |RETURN n\n        ")).stripMargin());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CantHandleQueryException.class)));
            }

            public /* synthetic */ InlineProjectionsTest org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH n WITH n.prop AS x WITH x LIMIT 10 RETURN x", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS x\n        |WITH x LIMIT 10\n        |RETURN x\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |WITH n AS n LIMIT 10\n        |RETURN n.prop AS x\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (a:Start) WITH a.prop AS property, count(*) AS count MATCH (b) WHERE id(b) = property RETURN b", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("MATCH (a:Start)\n        |WITH a.prop AS property, count(*) AS count\n        |MATCH (b) WHERE id(b) = property\n        |RETURN b\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("MATCH (a:Start)\n        |WITH a.prop AS property, count(*) AS `count`\n        |MATCH (b) WHERE id(b) = property\n        |RETURN b AS `b`\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("removes unneeded projection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String query2 = new StringOps(Predef$.MODULE$.augmentString("MATCH (owner)\n        |WITH owner, COUNT(*) AS xyz\n        |WITH owner, xyz > 0 as collection\n        |WHERE (owner)--()\n        |RETURN owner\n      ")).stripMargin();
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(query2);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.parser().parse(new StringOps(Predef$.MODULE$.augmentString("MATCH (owner)\n        |WITH owner AS `owner`, COUNT(*) AS xyz\n        |WITH owner AS `owner`, xyz AS `xyz`\n        |WITH owner AS `owner`, xyz AS `xyz`, owner AS `owner`\n        |WHERE (owner)--()\n        |WITH xyz AS `xyz`, owner AS `owner`\n        |RETURN owner AS `owner`\n      ")).stripMargin(), this.$outer.parser().parse$default$2())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("WITH 1 as b RETURN b", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH 1 as b\n        |RETURN b\n      ")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("_PRAGMA WITH NONE\n        |RETURN 1 AS b\n      ")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("match n where id(n) IN [0,1,2,3] with n.division AS `n.division`, max(n.age) AS `max(n.age)` with `n.division` AS `n.division`, `max(n.age)` AS `max(n.age)` RETURN `n.division` AS `n.division`, `max(n.age)` AS `max(n.age)` order by `max(n.age)`", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("match n where id(n) IN [0,1,2,3]\n        |with n.division AS `n.division`, max(n.age) AS `max(n.age)`\n        |with `n.division` AS `n.division`, `max(n.age)` AS `max(n.age)`\n        |RETURN `n.division` AS `n.division`, `max(n.age)` AS `max(n.age)` order by `max(n.age)`\n      ")).stripMargin());
                String freshIdName = SystemUtils.IS_OS_WINDOWS ? "`  FRESHID197`" : "`  FRESHID194`";
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"match n where id(n) IN [0,1,2,3]\n        |with n.division AS `n.division`, max(n.age) AS `max(n.age)`\n        |with `n.division` AS `n.division`, `max(n.age)` AS `max(n.age)`\n        |with `n.division` AS `n.division`, `max(n.age)` AS ", " order by ", "\n        |RETURN `n.division` AS `n.division`, ", " AS `max(n.age)`\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{freshIdName, freshIdName, freshIdName})))).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not inline expressions used many times: WITH 1 as a MATCH (a) WHERE a.prop = x OR a.bar > x RETURN a, x => WITH 1 as a MATCH (a) WHERE a.prop = x OR a.bar > x RETURN a, x", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst(new StringOps(Predef$.MODULE$.augmentString("WITH 1 as x\n        |MATCH (a) WHERE a.prop = x OR a.bar > x\n        |RETURN a, x")).stripMargin());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast(new StringOps(Predef$.MODULE$.augmentString("WITH 1 as x\n        |MATCH (a) WHERE a.prop = x OR a.bar > x\n        |RETURN a, x")).stripMargin())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not inline relationship identifiers if not inlinging expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InlineProjectionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement result = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$projectionInlinedAst("MATCH (u)-[r1]->(v) WITH r1 AS r2 MATCH (a)-[r2]->(b) RETURN r2 AS rel");
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$InlineProjectionsTest$$ast("MATCH (u)-[r1]->(v) WITH r1 AS r2 MATCH (a)-[r2]->(b) RETURN r2 AS rel")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

