/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v2_3.ASTRewriter;
import org.neo4j.cypher.internal.compiler.v2_3.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.Namespacer;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.Namespacer$;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.NamespacerTest$;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.compiler.v2_3.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.compiler.v2_3.helpers.StatementHelper$;
import org.neo4j.cypher.internal.compiler.v2_3.parser.ParserFixture$;
import org.neo4j.cypher.internal.compiler.v2_3.tracing.rewriters.RewriterStepSequencer$;
import org.neo4j.cypher.internal.compiler.v2_3.tracing.rewriters.ValidatingRewriterStepSequencer;
import org.neo4j.cypher.internal.frontend.v2_3.ExpressionTypeInfo;
import org.neo4j.cypher.internal.frontend.v2_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v2_3.Ref$;
import org.neo4j.cypher.internal.frontend.v2_3.Rewritable;
import org.neo4j.cypher.internal.frontend.v2_3.Rewritable$;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticState;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticTable;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticTable$;
import org.neo4j.cypher.internal.frontend.v2_3.ast.ASTAnnotationMap$;
import org.neo4j.cypher.internal.frontend.v2_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v2_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Identifier;
import org.neo4j.cypher.internal.frontend.v2_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Statement;
import org.neo4j.cypher.internal.frontend.v2_3.inSequence$;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001'\tqa*Y7fgB\f7-\u001a:UKN$(BA\u0002\u0005\u0003%\u0011Xm\u001e:ji\u0016\u00148O\u0003\u0002\u0006\r\u0005\u0019\u0011m\u001d;\u000b\u0005\u001dA\u0011\u0001\u0002<3?NR!!\u0003\u0006\u0002\u0011\r|W\u000e]5mKJT!a\u0003\u0007\u0002\u0011%tG/\u001a:oC2T!!\u0004\b\u0002\r\rL\b\u000f[3s\u0015\ty\u0001#A\u0003oK>$$NC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001A#\b\t\u0003+mi\u0011A\u0006\u0006\u0003/a\tA\u0002^3ti~CW\r\u001c9feNT!aB\r\u000b\u0005iQ\u0011\u0001\u00034s_:$XM\u001c3\n\u0005q1\"AD\"za\",'OR;o'VLG/\u001a\t\u0003=\u0001j\u0011a\b\u0006\u0003\u000baI!!I\u0010\u00035\u0005\u001bHoQ8ogR\u0014Xo\u0019;j_:$Vm\u001d;TkB\u0004xN\u001d;\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005\u0011\u0001b\u0002\u0015\u0001\u0005\u0004%\t!K\u0001\u0006i\u0016\u001cHo]\u000b\u0002UA\u00191\u0006\r\u001a\u000e\u00031R!!\f\u0018\u0002\u0015\r|G\u000e\\3di&|gNC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tDFA\u0002TKF\u0004Ba\r\u001b7}5\ta&\u0003\u00026]\t1A+\u001e9mKJ\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\t1\fgn\u001a\u0006\u0002w\u0005!!.\u0019<b\u0013\ti\u0004H\u0001\u0004TiJLgn\u001a\t\u0003\u007f\ts!a\r!\n\u0005\u0005s\u0013A\u0002)sK\u0012,g-\u0003\u0002>\u0007*\u0011\u0011I\f\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002\u0016\u0002\rQ,7\u000f^:!\u0011\u001d9\u0005A1A\u0005\u0002!\u000b1\"Y:u%\u0016<(/\u001b;feV\t\u0011\n\u0005\u0002K\u00176\ta!\u0003\u0002M\r\tY\u0011i\u0015+SK^\u0014\u0018\u000e^3s\u0011\u0019q\u0005\u0001)A\u0005\u0013\u0006a\u0011m\u001d;SK^\u0014\u0018\u000e^3sA!)\u0001\u000b\u0001C\u0005#\u0006y\u0011m]:feR\u0014Vm\u001e:jiR,g\u000eF\u0002S+^\u0003\"aM*\n\u0005Qs#\u0001B+oSRDQAV(A\u0002y\nAA\u001a:p[\")\u0001l\u0014a\u0001}\u0005\u0011Ao\u001c\u0005\u00065\u0002!IaW\u0001\u0010a\u0006\u00148/Z!oIJ+wO]5uKR\u0011Al\u0018\t\u0003=uK!AX\u0010\u0003\u0013M#\u0018\r^3nK:$\b\"\u00021Z\u0001\u0004q\u0014!C9vKJLH+\u001a=u\u0001")
public class NamespacerTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final Seq<Tuple2<String, String>> tests;
    private final ASTRewriter astRewriter;
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v2_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Identifier ident(String name) {
        return AstConstructionTestSupport.class.ident((AstConstructionTestSupport)this, (String)name);
    }

    public HasLabels hasLabels(String identifier, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)identifier, (String)label);
    }

    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)identifier, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public Seq<Tuple2<String, String>> tests() {
        return this.tests;
    }

    public ASTRewriter astRewriter() {
        return this.astRewriter;
    }

    public void org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$NamespacerTest$$assertRewritten(String from, String to) {
        Statement fromAst = this.parseAndRewrite(from);
        SemanticState state = StatementHelper$.MODULE$.RichStatement(fromAst).semanticState();
        Namespacer namespacer = Namespacer$.MODULE$.apply(fromAst, state.scopeTree());
        Statement namespacedAst = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)fromAst), namespacer.statementRewriter());
        Statement expectedAst = this.parseAndRewrite(to);
        this.convertToAnyShouldWrapper(namespacedAst).should(this.equal(expectedAst), (Object)Equality$.MODULE$.default());
    }

    private Statement parseAndRewrite(String queryText) {
        Statement parsedAst = ParserFixture$.MODULE$.parser().parse(queryText, ParserFixture$.MODULE$.parser().parse$default$2());
        SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(queryText, (Option)new Some((Object)this.pos()));
        Statement cleanedAst = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)parsedAst), (Function1)inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
        Tuple3 tuple3 = this.astRewriter().rewrite(queryText, cleanedAst, StatementHelper$.MODULE$.RichStatement(cleanedAst).semanticState());
        if (tuple3 != null) {
            Statement rewrittenAst;
            Statement statement;
            Statement rewrittenAst2 = statement = (rewrittenAst = (Statement)tuple3._1());
            return rewrittenAst2;
        }
        throw new MatchError((Object)tuple3);
    }

    public NamespacerTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.tests = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"match n return n as n"), (Object)"match n return n as n"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"match n, x with n as n match x return n as n, x as x"), (Object)"match n, `  x@9` with n as n match `  x@29` return n as n, `  x@29` as x"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"match n, x where [x in n.prop where x = 2] return x as x"), (Object)"match n, `  x@9` where [`  x@18` in n.prop where `  x@18` = 2] return `  x@9` as x"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MATCH (a) WITH a.bar as bars WHERE 1 = 2 RETURN *"), (Object)"MATCH (a) WITH a.bar as bars WHERE 1 = 2 RETURN *"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"match (n) where id(n) = 0 WITH collect(n) as coll where length(coll)={id} RETURN coll"), (Object)"match (n) where id(n) = 0 WITH collect(n) as coll where length(coll)={id} RETURN coll"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"match me-[r1]->you with 1 AS x match me-[r1]->food<-[r2]-you return r1.times as `r1.times`"), (Object)"match `  me@6`-[`  r1@10`]->`  you@15` with 1 AS x match `  me@37`-[`  r1@41`]->food<-[r2]-`  you@57` return `  r1@41`.times as `r1.times`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MATCH (a:A)-[r1:T1]->(b:B)-[r2:T1]->(c:C) RETURN *"), (Object)"MATCH (a:A)-[r1:T1]->(b:B)-[r2:T1]->(c:C) RETURN *"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"match (a:Party) return a as a union match (a:Animal) return a as a"), (Object)"match (`  a@7`:Party) return `  a@7` as a union match (`  a@43`:Animal) return `  a@43` as a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"match p=(a:Start)-->b return *"), (Object)"match p=(a:Start)-->b return *"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"match n return n, count(*) as c order by c"), (Object)new StringOps(Predef$.MODULE$.augmentString("match `  n@6`\n      |with `  n@6` as `  FRESHID15`, count(*) as `  FRESHID18` ORDER BY `  FRESHID18`\n      |return `  FRESHID15` as n, `  FRESHID18` as c")).stripMargin()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"START root=node:Person(id='deevian') RETURN id(root) as id UNION START root=node:Person(id='retophy') RETURN id(root) as id"), (Object)"START `  root@6`=node:Person(id='deevian') RETURN id(`  root@6`) as id UNION START `  root@71`=node:Person(id='retophy') RETURN id(`  root@71`) as id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"WITH 1 AS p, count(*) AS rng RETURN p ORDER BY rng"), (Object)"WITH 1 AS `  p@10`, count(*) AS rng WITH `  p@10`  AS `  FRESHID36` ORDER BY rng RETURN `  FRESHID36` AS p")}));
        this.tests().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NamespacerTest $outer;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String q = (String)tuple2._1();
                    String rewritten = (String)tuple2._2();
                    this.$outer.test(q, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, q, rewritten){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$2 $outer;
                        private final String q$1;
                        private final String rewritten$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$NamespacerTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$NamespacerTest$$assertRewritten(this.q$1, this.rewritten$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.q$1 = q$1;
                            this.rewritten$1 = rewritten$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ NamespacerTest org$neo4j$cypher$internal$compiler$v2_3$ast$rewriters$NamespacerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Renames identifiers in semantic table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NamespacerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Identifier idA1 = new Identifier("a", new InputPosition(1, 0, 1));
                Identifier idA2 = new Identifier("a", new InputPosition(2, 0, 2));
                Identifier idA3 = new Identifier("a", new InputPosition(3, 0, 3));
                Identifier idB5 = new Identifier("b", new InputPosition(5, 0, 5));
                ExpressionTypeInfo infoA1 = (ExpressionTypeInfo)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExpressionTypeInfo.class));
                ExpressionTypeInfo infoA2 = (ExpressionTypeInfo)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExpressionTypeInfo.class));
                ExpressionTypeInfo infoA3 = (ExpressionTypeInfo)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExpressionTypeInfo.class));
                ExpressionTypeInfo infoA4 = (ExpressionTypeInfo)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExpressionTypeInfo.class));
                ExpressionTypeInfo infoB5 = (ExpressionTypeInfo)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExpressionTypeInfo.class));
                SemanticTable table = SemanticTable$.MODULE$.apply(ASTAnnotationMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)idA1), (Object)infoA1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)idA2), (Object)infoA2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)idA3), (Object)infoA3), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)idB5), (Object)infoB5)})), SemanticTable$.MODULE$.apply$default$2());
                Map renamings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Ref$.MODULE$.apply((Object)idA1)), (Object)new Identifier("a@1", new InputPosition(1, 0, 1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Ref$.MODULE$.apply((Object)idA2)), (Object)new Identifier("a@2", new InputPosition(2, 0, 2)))}));
                Namespacer namespacer = new Namespacer(renamings);
                SemanticTable newTable = (SemanticTable)namespacer.tableRewriter().apply((Object)table);
                this.$outer.convertToAnyShouldWrapper(newTable.types()).should(this.$outer.equal(ASTAnnotationMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Identifier("a@1", new InputPosition(1, 0, 1))), (Object)infoA1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Identifier("a@2", new InputPosition(2, 0, 2))), (Object)infoA2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)idA3), (Object)infoA3), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)idB5), (Object)infoB5)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.astRewriter = new ASTRewriter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ValidatingRewriterStepSequencer apply(String sequenceName) {
                return RewriterStepSequencer$.MODULE$.newValidating(sequenceName);
            }
        }, false);
    }
}

