/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.commands;

import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Collection;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.CoercedPredicate;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Not;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Predicate;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.True;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q2A!\u0001\u0002\u0001#\t!2i\\3sG\u0016$\u0007K]3eS\u000e\fG/\u001a+fgRT!a\u0001\u0003\u0002\u0011\r|W.\\1oINT!!\u0002\u0004\u0002\tY\u0014tl\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0006/)\u0011\u0001\u0004C\u0001\tMJ|g\u000e^3oI&\u0011!\u0004\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t!\u0001C\u0004\"\u0001\t\u0007I\u0011\u0001\u0012\u0002\u0007\r$\b0F\u0001$!\t!S%D\u0001\u0005\u0013\t1CA\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"1\u0001\u0006\u0001Q\u0001\n\r\nAa\u0019;yA!9!\u0006\u0001b\u0001\n\u0007Y\u0013!B:uCR,W#\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\"\u0011!\u00029ja\u0016\u001c\u0018BA\u0019/\u0005)\tV/\u001a:z'R\fG/\u001a\u0005\u0007g\u0001\u0001\u000b\u0011\u0002\u0017\u0002\rM$\u0018\r^3!\u0001")
public class CoercedPredicateTest
extends CypherFunSuite {
    private final ExecutionContext ctx = null;
    private final QueryState state = QueryStateHelper$.MODULE$.empty();

    public ExecutionContext ctx() {
        return this.ctx;
    }

    public QueryState state() {
        return this.state;
    }

    public CoercedPredicateTest() {
        this.test("should_coerce_non_empty_collection_to_true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoercedPredicateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Collection collection = new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToInteger((int)1))}));
                boolean result = new CoercedPredicate((Expression)collection).isTrue(this.$outer.ctx(), this.$outer.state());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result)).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_coerce_empty_collection_to_false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoercedPredicateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Collection collection = new Collection((Seq)Nil$.MODULE$);
                boolean result = new CoercedPredicate((Expression)collection).isTrue(this.$outer.ctx(), this.$outer.state());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result)).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_pass_through_false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoercedPredicateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Not inner = new Not((Predicate)new True());
                boolean result = new CoercedPredicate((Expression)inner).isTrue(this.$outer.ctx(), this.$outer.state());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result)).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_pass_through_true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoercedPredicateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                True inner = new True();
                boolean result = new CoercedPredicate((Expression)inner).isTrue(this.$outer.ctx(), this.$outer.state());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result)).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_treat_null_as_false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CoercedPredicateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Literal inner = new Literal(null);
                boolean result = new CoercedPredicate((Expression)inner).isTrue(this.$outer.ctx(), this.$outer.state());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result)).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

