/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.executionplan;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v2_3.CompilationPhaseTracer;
import org.neo4j.cypher.internal.compiler.v2_3.InternalNotificationLogger;
import org.neo4j.cypher.internal.compiler.v2_3.PreparedQuery;
import org.neo4j.cypher.internal.compiler.v2_3.PreparedQuery$;
import org.neo4j.cypher.internal.compiler.v2_3.RecordingNotificationLogger;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.ExecutablePlanBuilder;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.NewLogicalPlanSuccessRateMonitor;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.PipeInfo;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.SilentFallbackPlanBuilder;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.WarningFallbackPlanBuilder;
import org.neo4j.cypher.internal.compiler.v2_3.planner.CantHandleQueryException;
import org.neo4j.cypher.internal.compiler.v2_3.spi.PlanContext;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Statement;
import org.neo4j.cypher.internal.frontend.v2_3.notification.PlannerUnsupportedNotification$;
import org.neo4j.cypher.internal.frontend.v2_3.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Containing$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001#\t9b)\u00197mE\u0006\u001c7\u000e\u00157b]\n+\u0018\u000e\u001c3feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ\"\u001a=fGV$\u0018n\u001c8qY\u0006t'BA\u0003\u0007\u0003\u00111(gX\u001a\u000b\u0005\u001dA\u0011\u0001C2p[BLG.\u001a:\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111#G\u0007\u0002))\u0011QCF\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003\u000b]Q!\u0001\u0007\u0005\u0002\u0011\u0019\u0014xN\u001c;f]\u0012L!A\u0007\u000b\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")A\u0004\u0001C\u0001;\u00051A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011A\u0001\u0005\bC\u0001\u0011\r\u0011\"\u0001#\u0003\u0019\u0001\u0018M]:feV\t1\u0005\u0005\u0002%M5\tQE\u0003\u0002\"-%\u0011q%\n\u0002\r\u0007f\u0004\b.\u001a:QCJ\u001cXM\u001d\u0005\u0007S\u0001\u0001\u000b\u0011B\u0012\u0002\u000fA\f'o]3sA\u0019!1\u0006\u0001\u0001-\u0005\u0011)8/Z:\u0014\u0005)j\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g\r\u0003\u00055U\t\u0005\t\u0015!\u00036\u0003%\tX/\u001a:z)\u0016DH\u000f\u0005\u00027s9\u0011afN\u0005\u0003q=\na\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001h\f\u0005\u00069)\"\t!\u0010\u000b\u0003}\u0001\u0003\"a\u0010\u0016\u000e\u0003\u0001AQ\u0001\u000e\u001fA\u0002UBqA\u0011\u0016C\u0002\u0013\u00051)A\u0006qY\u0006t7i\u001c8uKb$X#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d#\u0011aA:qS&\u0011\u0011J\u0012\u0002\f!2\fgnQ8oi\u0016DH\u000f\u0003\u0004LU\u0001\u0006I\u0001R\u0001\ra2\fgnQ8oi\u0016DH\u000f\t\u0005\b\u001b*\u0012\r\u0011\"\u0001O\u0003)yG\u000e\u001a\"vS2$WM]\u000b\u0002\u001fB\u0011q\u0004U\u0005\u0003#\n\u0011Q#\u0012=fGV$\u0018M\u00197f!2\fgNQ;jY\u0012,'\u000f\u0003\u0004TU\u0001\u0006IaT\u0001\f_2$')^5mI\u0016\u0014\b\u0005C\u0004VU\t\u0007I\u0011\u0001(\u0002\u00159,wOQ;jY\u0012,'\u000f\u0003\u0004XU\u0001\u0006IaT\u0001\f]\u0016<()^5mI\u0016\u0014\b\u0005C\u0004ZU\t\u0007I\u0011\u0001.\u0002\u0017AL\u0007/\u001a\"vS2$WM]\u000b\u00027B\u0011q\u0004X\u0005\u0003;\n\u0011\u0011dU5mK:$h)\u00197mE\u0006\u001c7\u000e\u00157b]\n+\u0018\u000e\u001c3fe\"1qL\u000bQ\u0001\nm\u000bA\u0002]5qK\n+\u0018\u000e\u001c3fe\u0002Bq!\u0019\u0016C\u0002\u0013\u0005!-A\u0007qe\u0016\u0004\u0018M]3e#V,'/_\u000b\u0002GB\u0011A-Z\u0007\u0002\t%\u0011a\r\u0002\u0002\u000e!J,\u0007/\u0019:fIF+XM]=\t\r!T\u0003\u0015!\u0003d\u00039\u0001(/\u001a9be\u0016$\u0017+^3ss\u0002BqA\u001b\u0016C\u0002\u0013\u00051.\u0001\u0005qSB,\u0017J\u001c4p+\u0005a\u0007CA\u0010n\u0013\tq'A\u0001\u0005QSB,\u0017J\u001c4p\u0011\u0019\u0001(\u0006)A\u0005Y\u0006I\u0001/\u001b9f\u0013:4w\u000e\t\u0005\u0006e*\"\ta[\u0001\u0007e\u0016\u001cX\u000f\u001c;\t\u000bQTC\u0011A;\u0002\u0015\u0005\u001c8/\u001a:u+N,G\r\u0006\u0002wsB\u0011af^\u0005\u0003q>\u0012A!\u00168ji\")!p\u001da\u0001\u001f\u0006!Qo]3e\u0001")
public class FallbackPlanBuilderTest
extends CypherFunSuite {
    private final CypherParser parser = new CypherParser();

    public CypherParser parser() {
        return this.parser;
    }

    public FallbackPlanBuilderTest() {
        this.test("should delegate var length to old pipe builder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FallbackPlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                new uses(this){
                    {
                        super("MATCH ()-[r*]->() RETURN r");
                        $outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().convertToAnyShouldWrapper(this.result()).should($outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().equal(this.pipeInfo()), (Object)Equality$.MODULE$.default());
                        this.assertUsed(this.newBuilder());
                    }
                };
            }

            public /* synthetic */ FallbackPlanBuilderTest org$neo4j$cypher$internal$compiler$v2_3$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should delegate plain shortest path to new pipe builder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FallbackPlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                new uses(this){
                    {
                        super("MATCH shortestPath(()-[r*]->()) RETURN r");
                        $outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().convertToAnyShouldWrapper(this.result()).should($outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().equal(this.pipeInfo()), (Object)Equality$.MODULE$.default());
                        this.assertUsed(this.newBuilder());
                    }
                };
            }

            public /* synthetic */ FallbackPlanBuilderTest org$neo4j$cypher$internal$compiler$v2_3$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should delegate shortest path with var length expressions to old pipe builder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FallbackPlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                new uses(this){
                    {
                        super("MATCH shortestPath(()-[r*]->({x: ()-[:T*]->()})) RETURN r");
                        $outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().convertToAnyShouldWrapper(this.result()).should($outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer().equal(this.pipeInfo()), (Object)Equality$.MODULE$.default());
                        this.assertUsed(this.newBuilder());
                    }
                };
            }

            public /* synthetic */ FallbackPlanBuilderTest org$neo4j$cypher$internal$compiler$v2_3$executionplan$FallbackPlanBuilderTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should warn if falling back from a specified plan", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FallbackPlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object x$9 = null;
                Object x$10 = null;
                Object x$11 = null;
                Object x$12 = null;
                Object x$13 = null;
                Object x$14 = null;
                RecordingNotificationLogger x$15 = new RecordingNotificationLogger();
                String x$16 = PreparedQuery$.MODULE$.$lessinit$greater$default$8(null, null, null);
                PreparedQuery preparedQuery = new PreparedQuery(null, null, null, null, null, null, (InternalNotificationLogger)x$15, x$16);
                ExecutablePlanBuilder builder = (ExecutablePlanBuilder)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class));
                Mockito.when((Object)builder.producePlan(preparedQuery, null, null)).thenThrow(new Class[]{CantHandleQueryException.class});
                new WarningFallbackPlanBuilder((ExecutablePlanBuilder)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class)), builder, (NewLogicalPlanSuccessRateMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(NewLogicalPlanSuccessRateMonitor.class))).producePlan(preparedQuery, null, null);
                this.$outer.convertToAnyShouldWrapper(preparedQuery.notificationLogger().notifications()).should(this.$outer.contain().apply((Object)PlannerUnsupportedNotification$.MODULE$), (Object)Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not warn if falling back from fallback plan", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FallbackPlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object x$17 = null;
                Object x$18 = null;
                Object x$19 = null;
                Object x$20 = null;
                Object x$21 = null;
                Object x$22 = null;
                RecordingNotificationLogger x$23 = new RecordingNotificationLogger();
                String x$24 = PreparedQuery$.MODULE$.$lessinit$greater$default$8(null, null, null);
                PreparedQuery preparedQuery = new PreparedQuery(null, null, null, null, null, null, (InternalNotificationLogger)x$23, x$24);
                ExecutablePlanBuilder builder = (ExecutablePlanBuilder)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class));
                Mockito.when((Object)builder.producePlan(preparedQuery, null, null)).thenThrow(new Class[]{CantHandleQueryException.class});
                new SilentFallbackPlanBuilder((ExecutablePlanBuilder)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class)), builder, (NewLogicalPlanSuccessRateMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(NewLogicalPlanSuccessRateMonitor.class))).producePlan(preparedQuery, null, null);
                this.$outer.convertToAnyShouldWrapper(preparedQuery.notificationLogger().notifications()).should(this.$outer.not()).contain((Object)PlannerUnsupportedNotification$.MODULE$, Containing$.MODULE$.containingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class uses {
        private final PlanContext planContext;
        private final ExecutablePlanBuilder oldBuilder;
        private final ExecutablePlanBuilder newBuilder;
        private final SilentFallbackPlanBuilder pipeBuilder;
        private final PreparedQuery preparedQuery;
        private final PipeInfo pipeInfo;

        public PlanContext planContext() {
            return this.planContext;
        }

        public ExecutablePlanBuilder oldBuilder() {
            return this.oldBuilder;
        }

        public ExecutablePlanBuilder newBuilder() {
            return this.newBuilder;
        }

        public SilentFallbackPlanBuilder pipeBuilder() {
            return this.pipeBuilder;
        }

        public PreparedQuery preparedQuery() {
            return this.preparedQuery;
        }

        public PipeInfo pipeInfo() {
            return this.pipeInfo;
        }

        /*
         * WARNING - void declaration
         */
        public PipeInfo result() {
            void var1_1;
            PipeInfo plan = this.pipeBuilder().producePlan(this.preparedQuery(), this.planContext(), this.pipeBuilder().producePlan$default$3());
            return var1_1;
        }

        public void assertUsed(ExecutablePlanBuilder used) {
            ExecutablePlanBuilder executablePlanBuilder = used;
            ExecutablePlanBuilder executablePlanBuilder2 = this.oldBuilder();
            ExecutablePlanBuilder notUsed = !(executablePlanBuilder != null ? !executablePlanBuilder.equals(executablePlanBuilder2) : executablePlanBuilder2 != null) ? this.newBuilder() : this.oldBuilder();
            ((ExecutablePlanBuilder)Mockito.verify((Object)used)).producePlan(this.preparedQuery(), this.planContext(), CompilationPhaseTracer.NO_TRACING);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{used});
            Mockito.verifyZeroInteractions((Object[])new Object[]{notUsed});
        }

        public /* synthetic */ FallbackPlanBuilderTest org$neo4j$cypher$internal$compiler$v2_3$executionplan$FallbackPlanBuilderTest$uses$$$outer() {
            return FallbackPlanBuilderTest.this;
        }

        public uses(String queryText) {
            if (FallbackPlanBuilderTest.this == null) {
                throw null;
            }
            this.planContext = (PlanContext)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
            this.oldBuilder = (ExecutablePlanBuilder)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class));
            this.newBuilder = (ExecutablePlanBuilder)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(ExecutablePlanBuilder.class));
            this.pipeBuilder = new SilentFallbackPlanBuilder(this.oldBuilder(), this.newBuilder(), (NewLogicalPlanSuccessRateMonitor)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(NewLogicalPlanSuccessRateMonitor.class)));
            Statement x$1 = FallbackPlanBuilderTest.this.parser().parse(queryText, FallbackPlanBuilderTest.this.parser().parse$default$2());
            String x$2 = queryText;
            Map x$3 = Predef$.MODULE$.Map().empty();
            Object x$4 = null;
            Set x$5 = Predef$.MODULE$.Set().empty();
            Object x$6 = null;
            Object x$7 = null;
            String x$8 = PreparedQuery$.MODULE$.apply$default$8(x$1, x$2, x$3);
            this.preparedQuery = new PreparedQuery(x$1, x$2, x$3, null, x$5, null, null, x$8);
            this.pipeInfo = (PipeInfo)FallbackPlanBuilderTest.this.mock(ManifestFactory$.MODULE$.classType(PipeInfo.class));
            Mockito.when((Object)this.oldBuilder().producePlan(this.preparedQuery(), this.planContext(), CompilationPhaseTracer.NO_TRACING)).thenReturn((Object)this.pipeInfo());
            Mockito.when((Object)this.newBuilder().producePlan(this.preparedQuery(), this.planContext(), CompilationPhaseTracer.NO_TRACING)).thenReturn((Object)this.pipeInfo());
        }
    }
}

