/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.executionplan;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v2_3.InternalNotificationLogger;
import org.neo4j.cypher.internal.compiler.v2_3.Monitors;
import org.neo4j.cypher.internal.compiler.v2_3.PreparedQuery;
import org.neo4j.cypher.internal.compiler.v2_3.PreparedQuery$;
import org.neo4j.cypher.internal.compiler.v2_3.devNullLogger$;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.LegacyExecutablePlanBuilder;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.LegacyExecutablePlanBuilder$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.DistinctPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.EagerPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.NodeStartPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.TraversalMatchPipe;
import org.neo4j.cypher.internal.compiler.v2_3.spi.PlanContext;
import org.neo4j.cypher.internal.compiler.v2_3.spi.SchemaTypes;
import org.neo4j.cypher.internal.compiler.v2_3.tracing.rewriters.RewriterStepSequencer$;
import org.neo4j.cypher.internal.compiler.v2_3.tracing.rewriters.ValidatingRewriterStepSequencer;
import org.neo4j.cypher.internal.frontend.v2_3.Scope;
import org.neo4j.cypher.internal.frontend.v2_3.SemanticTable;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Statement;
import org.neo4j.cypher.internal.frontend.v2_3.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001#\ti\"+\u001e7f\u000bb,7-\u001e;bE2,\u0007\u000b\\1o\u0005VLG\u000eZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005iQ\r_3dkRLwN\u001c9mC:T!!\u0002\u0004\u0002\tY\u0014tl\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0006/)\u0011\u0001\u0004C\u0001\tMJ|g\u000e^3oI&\u0011!\u0004\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t!\u0001C\u0004\"\u0001\t\u0007I\u0011\u0001\u0012\u0002\u0017Ad\u0017M\\\"p]R,\u0007\u0010^\u000b\u0002GA\u0011AeJ\u0007\u0002K)\u0011a\u0005B\u0001\u0004gBL\u0017B\u0001\u0015&\u0005-\u0001F.\u00198D_:$X\r\u001f;\t\r)\u0002\u0001\u0015!\u0003$\u00031\u0001H.\u00198D_:$X\r\u001f;!\u0011\u001da\u0003A1A\u0005\u00025\na\u0001]1sg\u0016\u0014X#\u0001\u0018\u0011\u0005=\nT\"\u0001\u0019\u000b\u000512\u0012B\u0001\u001a1\u00051\u0019\u0015\u0010\u001d5feB\u000b'o]3s\u0011\u0019!\u0004\u0001)A\u0005]\u00059\u0001/\u0019:tKJ\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\taN\u0001\fa2\fgNQ;jY\u0012,'/F\u00019!\ty\u0012(\u0003\u0002;\u0005\tYB*Z4bGf,\u00050Z2vi\u0006\u0014G.\u001a)mC:\u0014U/\u001b7eKJDa\u0001\u0010\u0001!\u0002\u0013A\u0014\u0001\u00049mC:\u0014U/\u001b7eKJ\u0004\u0003\"\u0002 \u0001\t\u0003y\u0014\u0001E1tg\u0016\u0014H\u000fU5qK\u0016C\u0018n\u001d;t+\t\u0001%\fF\u0002B\u000f>\u0003\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013A!\u00168ji\")\u0001*\u0010a\u0001\u0013\u0006!\u0001/\u001b9f!\tQU*D\u0001L\u0015\taE!A\u0003qSB,7/\u0003\u0002O\u0017\n!\u0001+\u001b9f\u0011\u0015\u0001V\b1\u0001R\u0003\u0015YG.Y:t!\r\u0011V\u000b\u0017\b\u0003\u0005NK!\u0001V\"\u0002\rA\u0013X\rZ3g\u0013\t1vKA\u0003DY\u0006\u001c8O\u0003\u0002U\u0007B\u0011\u0011L\u0017\u0007\u0001\t\u0015YVH1\u0001]\u0005\u0005!\u0016CA/a!\t\u0011e,\u0003\u0002`\u0007\n9aj\u001c;iS:<\u0007C\u0001\"b\u0013\t\u00117IA\u0002B]fDQ\u0001\u001a\u0001\u0005\u0002\u0015\fa#Y:tKJ$\b+\u001b9f\t>,7OT8u\u000bbL7\u000f^\u000b\u0003M.$2!Q4i\u0011\u0015A5\r1\u0001J\u0011\u0015\u00016\r1\u0001j!\r\u0011VK\u001b\t\u00033.$QaW2C\u0002qCQ!\u001c\u0001\u0005\n9\f!CY;jY\u0012,\u00050Z2vi&|g\u000eU5qKR\u0011\u0011j\u001c\u0005\u0006a2\u0004\r!]\u0001\u0002cB\u0011!K]\u0005\u0003g^\u0013aa\u0015;sS:<\u0007")
public class RuleExecutablePlanBuilderTest
extends CypherFunSuite {
    private final PlanContext planContext = (PlanContext)this.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
    private final CypherParser parser = new CypherParser();
    private final LegacyExecutablePlanBuilder planBuilder = new LegacyExecutablePlanBuilder((Monitors)this.mock(ManifestFactory$.MODULE$.classType(Monitors.class)), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final ValidatingRewriterStepSequencer apply(String sequenceName) {
            return RewriterStepSequencer$.MODULE$.newValidating(sequenceName);
        }
    }, LegacyExecutablePlanBuilder$.MODULE$.$lessinit$greater$default$3());

    public PlanContext planContext() {
        return this.planContext;
    }

    public CypherParser parser() {
        return this.parser;
    }

    public LegacyExecutablePlanBuilder planBuilder() {
        return this.planBuilder;
    }

    public <T> void assertPipeExists(Pipe pipe, Class<T> klass) {
        Pipe $org_scalatest_assert_macro_left = pipe;
        Class<T> $org_scalatest_assert_macro_right = klass;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.existsMacroBool((Object)$org_scalatest_assert_macro_left, $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.exists((Function1)new Serializable(this, klass){
            public static final long serialVersionUID = 0L;
            private final Class klass$2;

            public final boolean apply(Pipe x$3) {
                Class<?> clazz = x$3.getClass();
                Class clazz2 = this.klass$2;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
            {
                this.klass$2 = klass$2;
            }
        }));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected to contain a pipe of type ", ". Got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{klass, pipe})));
    }

    public <T> void assertPipeDoesNotExist(Pipe pipe, Class<T> klass) {
        Pipe $org_scalatest_assert_macro_left = pipe;
        Class<T> $org_scalatest_assert_macro_right = klass;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.existsMacroBool((Object)$org_scalatest_assert_macro_left, $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.exists((Function1)new Serializable(this, klass){
            public static final long serialVersionUID = 0L;
            private final Class klass$1;

            public final boolean apply(Pipe x$4) {
                Class<?> clazz = x$4.getClass();
                Class clazz2 = this.klass$1;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
            {
                this.klass$1 = klass$1;
            }
        })));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected not to contain a pipe of type ", ". Got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{klass, pipe})));
    }

    public Pipe org$neo4j$cypher$internal$compiler$v2_3$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe(String q) {
        Statement statement;
        Statement x$5 = statement = this.parser().parse(q, this.parser().parse$default$2());
        String x$6 = q;
        Map x$7 = Predef$.MODULE$.Map().empty();
        SemanticTable x$8 = (SemanticTable)this.mock(ManifestFactory$.MODULE$.classType(SemanticTable.class));
        Set x$9 = Predef$.MODULE$.Set().empty();
        Scope x$10 = (Scope)this.mock(ManifestFactory$.MODULE$.classType(Scope.class));
        devNullLogger$ x$11 = devNullLogger$.MODULE$;
        String x$12 = PreparedQuery$.MODULE$.apply$default$8(x$5, x$6, x$7);
        PreparedQuery parsedQ = new PreparedQuery(x$5, x$6, x$7, x$8, x$9, x$10, (InternalNotificationLogger)x$11, x$12);
        return this.planBuilder().producePlan(parsedQ, this.planContext(), this.planBuilder().producePlan$default$3()).pipe();
    }

    public RuleExecutablePlanBuilderTest() {
        this.test("should_use_distinct_pipe_for_distinct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("MATCH n RETURN DISTINCT n");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pipe x$1) {
                        return x$1 instanceof DistinctPipe;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_use_traversal_matcher_when_possible", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.planContext().getOptLabelId("Foo")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("match (n:Foo)-->(x) return x");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pipe x$2) {
                        return x$2 instanceof TraversalMatchPipe;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_use_schema_index_with_load_csv", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.planContext().getOptLabelId("Person")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getOptPropertyKeyId("name")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getIndexRule("Person", "name")).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(1, 1)));
                Mockito.when((Object)this.$outer.planContext().getUniquenessConstraint("Person", "name")).thenReturn((Object)None$.MODULE$);
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("LOAD CSV FROM 'file:///tmp/foo.csv' AS line MATCH (p:Person { name: line[0] }) RETURN p;");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Pipe pipe) {
                        if (!(pipe instanceof NodeStartPipe)) return false;
                        String string = ((NodeStartPipe)pipe).createSource().producerType();
                        String string2 = "SchemaIndex";
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should_use_schema_index_with_load_csv_2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.planContext().getOptLabelId("Person")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getOptPropertyKeyId("name")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getIndexRule("Person", "name")).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(1, 1)));
                Mockito.when((Object)this.$outer.planContext().getUniquenessConstraint("Person", "name")).thenReturn((Object)None$.MODULE$);
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("LOAD CSV FROM 'file:///tmp/foo.csv' AS line MATCH (p:Person { name: \"Foo Bar Baz\" }) RETURN p;");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Pipe pipe) {
                        if (!(pipe instanceof NodeStartPipe)) return false;
                        String string = ((NodeStartPipe)pipe).createSource().producerType();
                        String string2 = "SchemaIndex";
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not introduce an eager pipe between two node reads and a relationships create", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("MATCH (a), (b) CREATE (a)-[:TYPE]->(b)");
                this.$outer.assertPipeDoesNotExist(pipe, EagerPipe.class);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not introduce an eager pipe between two node reads and a relationships create when theres is sorting between the two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("MATCH (a), (b) WITH a, b ORDER BY id(a) CREATE (a)-[:TYPE]->(b)");
                this.$outer.assertPipeDoesNotExist(pipe, EagerPipe.class);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should introduce an eager pipe between a node read and a relationship + node create", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("MATCH (a) CREATE (a)-[:TYPE]->()");
                this.$outer.assertPipeExists(pipe, EagerPipe.class);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should introduce an eager pipe between a relationship read and a relationship create", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RuleExecutablePlanBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$RuleExecutablePlanBuilderTest$$buildExecutionPipe("MATCH (a)-[:TYPE]->(b) CREATE (a)-[:TYPE]->(b)");
                this.$outer.assertPipeExists(pipe, EagerPipe.class);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

