/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v2_3.commands.AnyInCollection;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Collection;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Identifier;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Property;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Equals;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.HasLabel;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Predicate;
import org.neo4j.cypher.internal.compiler.v2_3.commands.values.UnresolvedLabel$;
import org.neo4j.cypher.internal.compiler.v2_3.commands.values.UnresolvedProperty$;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.NodeFetchStrategy$;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.NodeFetchStrategyTest$;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.NodeFetchStrategyTest$$anonfun$4$inner$3$;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.NodeFetchStrategyTest$$anonfun$5$inner$4$;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.RatedStartItem;
import org.neo4j.cypher.internal.compiler.v2_3.spi.PlanContext;
import org.neo4j.cypher.internal.compiler.v2_3.spi.SchemaTypes;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.SymbolTable;
import org.neo4j.cypher.internal.compiler.v2_3.symbols.SymbolTable$;
import org.neo4j.cypher.internal.frontend.v2_3.symbols.package$;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001'\t)bj\u001c3f\r\u0016$8\r[*ue\u0006$XmZ=UKN$(BA\u0002\u0005\u0003!\u0011W/\u001b7eKJ\u001c(BA\u0003\u0007\u00035)\u00070Z2vi&|g\u000e\u001d7b]*\u0011q\u0001C\u0001\u0005mJz6G\u0003\u0002\n\u0015\u0005A1m\\7qS2,'O\u0003\u0002\f\u0019\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u000e\u001d\u000511-\u001f9iKJT!a\u0004\t\u0002\u000b9,w\u000e\u000e6\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UYR\"\u0001\f\u000b\u0005]A\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\u0004\u001a\u0015\tQ\"\"\u0001\u0005ge>tG/\u001a8e\u0013\tabC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0011\u0001bB\u0012\u0001\u0005\u0004%\t\u0001J\u0001\raJ|\u0007/\u001a:us:\u000bW.Z\u000b\u0002KA\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0005Y\u0006twMC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#AB*ue&tw\r\u0003\u0004/\u0001\u0001\u0006I!J\u0001\u000eaJ|\u0007/\u001a:us:\u000bW.\u001a\u0011\t\u000fA\u0002!\u0019!C\u0001I\u0005IA.\u00192fY:\u000bW.\u001a\u0005\u0007e\u0001\u0001\u000b\u0011B\u0013\u0002\u00151\f'-\u001a7OC6,\u0007\u0005")
public class NodeFetchStrategyTest
extends CypherFunSuite {
    private final String propertyName;
    private final String labelName;

    public String propertyName() {
        return this.propertyName;
    }

    public String labelName() {
        return this.labelName;
    }

    public NodeFetchStrategyTest() {
        this.propertyName = "prop";
        this.labelName = "Label";
        this.test("should not select schema index when expression is missing dependencies", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeFetchStrategyTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable noSymbols = new SymbolTable(SymbolTable$.MODULE$.$lessinit$greater$default$1());
                Equals equalityPredicate = new Equals((Expression)new Property((Expression)new Identifier("a"), UnresolvedProperty$.MODULE$.apply(this.$outer.propertyName())), (Expression)new Identifier("b"));
                HasLabel labelPredicate = new HasLabel((Expression)new Identifier("a"), UnresolvedLabel$.MODULE$.apply(this.$outer.labelName()));
                PlanContext planCtx = (PlanContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
                SchemaTypes.IndexDescriptor indexDescriptor = new SchemaTypes.IndexDescriptor(0, 0);
                Mockito.when((Object)planCtx.getIndexRule(this.$outer.labelName(), this.$outer.propertyName())).thenReturn((Object)new Some((Object)indexDescriptor));
                RatedStartItem foundStartItem = NodeFetchStrategy$.MODULE$.findStartStrategy("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{equalityPredicate, labelPredicate})), planCtx, noSymbols);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)foundStartItem.rating())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)NodeFetchStrategy$.MODULE$.LabelScan())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should select schema index when expression valid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeFetchStrategyTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable noSymbols = new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())})));
                Equals equalityPredicate = new Equals((Expression)new Property((Expression)new Identifier("a"), UnresolvedProperty$.MODULE$.apply(this.$outer.propertyName())), (Expression)new Identifier("b"));
                HasLabel labelPredicate = new HasLabel((Expression)new Identifier("a"), UnresolvedLabel$.MODULE$.apply(this.$outer.labelName()));
                PlanContext planCtx = (PlanContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
                SchemaTypes.IndexDescriptor indexDescriptor = new SchemaTypes.IndexDescriptor(0, 0);
                Mockito.when((Object)planCtx.getIndexRule(this.$outer.labelName(), this.$outer.propertyName())).thenReturn((Object)new Some((Object)indexDescriptor));
                Mockito.when((Object)planCtx.getUniquenessConstraint(this.$outer.labelName(), this.$outer.propertyName())).thenReturn((Object)None$.MODULE$);
                RatedStartItem foundStartItem = NodeFetchStrategy$.MODULE$.findStartStrategy("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{equalityPredicate, labelPredicate})), planCtx, noSymbols);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)foundStartItem.rating())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)NodeFetchStrategy$.MODULE$.IndexEquality())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should select schema index when expression property check with in", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeFetchStrategyTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable noSymbols = new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())})));
                AnyInCollection inPredicate = new AnyInCollection((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Identifier("b")})), "_inner_", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), UnresolvedProperty$.MODULE$.apply(this.$outer.propertyName())), (Expression)new Identifier("_inner_")));
                HasLabel labelPredicate = new HasLabel((Expression)new Identifier("a"), UnresolvedLabel$.MODULE$.apply(this.$outer.labelName()));
                PlanContext planCtx = (PlanContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
                SchemaTypes.IndexDescriptor indexDescriptor = new SchemaTypes.IndexDescriptor(0, 0);
                Mockito.when((Object)planCtx.getIndexRule(this.$outer.labelName(), this.$outer.propertyName())).thenReturn((Object)new Some((Object)indexDescriptor));
                Mockito.when((Object)planCtx.getUniquenessConstraint(this.$outer.labelName(), this.$outer.propertyName())).thenReturn((Object)None$.MODULE$);
                RatedStartItem foundStartItem = NodeFetchStrategy$.MODULE$.findStartStrategy("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{inPredicate, labelPredicate})), planCtx, noSymbols);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)foundStartItem.rating())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)NodeFetchStrategy$.MODULE$.IndexEquality())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should select schema index for prefix search", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeFetchStrategyTest $outer;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private NodeFetchStrategyTest$$anonfun$4$inner$3$ inner$1$lzycompute(VolatileObjectRef x$1) {
                $anonfun$4 var2_2 = this;
                synchronized (var2_2) {
                    if (x$1.elem != null) return (NodeFetchStrategyTest$$anonfun$4$inner$3$)x$1.elem;
                    x$1.elem = new NodeFetchStrategyTest$$anonfun$4$inner$3$(this);
                    return (NodeFetchStrategyTest$$anonfun$4$inner$3$)x$1.elem;
                }
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VolatileObjectRef inner$module = VolatileObjectRef.zero();
                this.inner$1(inner$module).run();
            }

            public /* synthetic */ NodeFetchStrategyTest org$neo4j$cypher$internal$compiler$v2_3$executionplan$builders$NodeFetchStrategyTest$$anonfun$$$outer() {
                return this.$outer;
            }

            private final NodeFetchStrategyTest$$anonfun$4$inner$3$ inner$1(VolatileObjectRef inner$module$1) {
                return inner$module$1.elem == null ? this.inner$1$lzycompute(inner$module$1) : (NodeFetchStrategyTest$$anonfun$4$inner$3$)inner$module$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should select schema index for range queries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeFetchStrategyTest $outer;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private NodeFetchStrategyTest$$anonfun$5$inner$4$ inner$2$lzycompute(VolatileObjectRef x$1) {
                $anonfun$5 var2_2 = this;
                synchronized (var2_2) {
                    if (x$1.elem != null) return (NodeFetchStrategyTest$$anonfun$5$inner$4$)x$1.elem;
                    x$1.elem = new NodeFetchStrategyTest$$anonfun$5$inner$4$(this);
                    return (NodeFetchStrategyTest$$anonfun$5$inner$4$)x$1.elem;
                }
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VolatileObjectRef inner$module = VolatileObjectRef.zero();
                this.inner$2(inner$module).run();
            }

            public /* synthetic */ NodeFetchStrategyTest org$neo4j$cypher$internal$compiler$v2_3$executionplan$builders$NodeFetchStrategyTest$$anonfun$$$outer() {
                return this.$outer;
            }

            private final NodeFetchStrategyTest$$anonfun$5$inner$4$ inner$2(VolatileObjectRef inner$module$2) {
                return inner$module$2.elem == null ? this.inner$2$lzycompute(inner$module$2) : (NodeFetchStrategyTest$$anonfun$5$inner$4$)inner$module$2.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

