/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v2_3.InequalitySeekRange;
import org.neo4j.cypher.internal.compiler.v2_3.PrefixRange;
import org.neo4j.cypher.internal.compiler.v2_3.RangeBetween;
import org.neo4j.cypher.internal.compiler.v2_3.RangeGreaterThan;
import org.neo4j.cypher.internal.compiler.v2_3.RangeLessThan;
import org.neo4j.cypher.internal.compiler.v2_3.commands.AllNodes;
import org.neo4j.cypher.internal.compiler.v2_3.commands.AllRelationships;
import org.neo4j.cypher.internal.compiler.v2_3.commands.AnyIndex$;
import org.neo4j.cypher.internal.compiler.v2_3.commands.NodeByIndexQuery;
import org.neo4j.cypher.internal.compiler.v2_3.commands.Pattern;
import org.neo4j.cypher.internal.compiler.v2_3.commands.Query;
import org.neo4j.cypher.internal.compiler.v2_3.commands.RangeQueryExpression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.RelationshipById$;
import org.neo4j.cypher.internal.compiler.v2_3.commands.ReturnColumn;
import org.neo4j.cypher.internal.compiler.v2_3.commands.SchemaIndex;
import org.neo4j.cypher.internal.compiler.v2_3.commands.SchemaIndexKind;
import org.neo4j.cypher.internal.compiler.v2_3.commands.SingleQueryExpression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.StartItem;
import org.neo4j.cypher.internal.compiler.v2_3.commands.UniqueIndex$;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Identifier;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.InequalitySeekRangeExpression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.PrefixSeekRangeExpression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Property;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Equals;
import org.neo4j.cypher.internal.compiler.v2_3.commands.predicates.Predicate;
import org.neo4j.cypher.internal.compiler.v2_3.commands.values.KeyToken;
import org.neo4j.cypher.internal.compiler.v2_3.commands.values.TokenType;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.ExecutionPlanInProgress;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.PartiallySolvedQuery;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.PartiallySolvedQuery$;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.BuilderTest;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.BuilderTest$class;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.QueryToken;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.Solved;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.StartPointBuilder;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.StartPointBuilderTest$;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.builders.Unsolved;
import org.neo4j.cypher.internal.compiler.v2_3.mutation.UpdateAction;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.FakePipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.NodeStartPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v2_3.spi.PlanContext;
import org.neo4j.cypher.internal.compiler.v2_3.spi.SchemaTypes;
import org.neo4j.cypher.internal.frontend.v2_3.ExclusiveBound;
import org.neo4j.cypher.internal.frontend.v2_3.InclusiveBound;
import org.neo4j.cypher.internal.frontend.v2_3.IndexHintException;
import org.neo4j.cypher.internal.frontend.v2_3.helpers.NonEmptyList$;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Length$;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001'\t)2\u000b^1siB{\u0017N\u001c;Ck&dG-\u001a:UKN$(BA\u0002\u0005\u0003!\u0011W/\u001b7eKJ\u001c(BA\u0003\u0007\u00035)\u00070Z2vi&|g\u000e\u001d7b]*\u0011q\u0001C\u0001\u0005mJz6G\u0003\u0002\n\u0015\u0005A1m\\7qS2,'O\u0003\u0002\f\u0019\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u000e\u001d\u000511-\u001f9iKJT!a\u0004\t\u0002\u000b9,w\u000e\u000e6\u000b\u0003E\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u000b\u001e!\t)2$D\u0001\u0017\u0015\t9\u0002$\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\b3)\u0011!DC\u0001\tMJ|g\u000e^3oI&\u0011AD\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f!\tqr$D\u0001\u0003\u0013\t\u0001#AA\u0006Ck&dG-\u001a:UKN$\b\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\bF\u0001%!\tq\u0002\u0001C\u0004'\u0001\t\u0007I\u0011A\u0014\u0002\u000f\t,\u0018\u000e\u001c3feV\t\u0001\u0006\u0005\u0002\u001fS%\u0011!F\u0001\u0002\u0012'R\f'\u000f\u001e)pS:$()^5mI\u0016\u0014\bB\u0002\u0017\u0001A\u0003%\u0001&\u0001\u0005ck&dG-\u001a:!\u0001")
public class StartPointBuilderTest
extends CypherFunSuite
implements BuilderTest {
    private final StartPointBuilder builder;
    private final PipeMonitor monitor;
    private PlanContext context;

    @Override
    public PipeMonitor monitor() {
        return this.monitor;
    }

    @Override
    public PlanContext context() {
        return this.context;
    }

    @Override
    @TraitSetter
    public void context_$eq(PlanContext x$1) {
        this.context = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$executionplan$builders$BuilderTest$_setter_$monitor_$eq(PipeMonitor x$1) {
        this.monitor = x$1;
    }

    @Override
    public FakePipe createPipe(Seq<String> nodes, Seq<String> relationships) {
        return BuilderTest$class.createPipe(this, nodes, relationships);
    }

    @Override
    public final ExecutionPlanInProgress plan(PartiallySolvedQuery q) {
        return BuilderTest$class.plan((BuilderTest)this, q);
    }

    @Override
    public final ExecutionPlanInProgress plan(Query q) {
        return BuilderTest$class.plan((BuilderTest)this, q);
    }

    @Override
    public final ExecutionPlanInProgress plan(Pipe p, PartiallySolvedQuery q) {
        return BuilderTest$class.plan(this, p, q);
    }

    @Override
    public ExecutionPlanInProgress assertAccepts(PartiallySolvedQuery q) {
        return BuilderTest$class.assertAccepts((BuilderTest)this, q);
    }

    @Override
    public ExecutionPlanInProgress assertAccepts(Query q) {
        return BuilderTest$class.assertAccepts((BuilderTest)this, q);
    }

    @Override
    public ExecutionPlanInProgress assertAccepts(Pipe p, PartiallySolvedQuery q) {
        return BuilderTest$class.assertAccepts(this, p, q);
    }

    @Override
    public ExecutionPlanInProgress assertAccepts(ExecutionPlanInProgress planInProgress) {
        return BuilderTest$class.assertAccepts((BuilderTest)this, planInProgress);
    }

    @Override
    public void assertRejects(PartiallySolvedQuery q) {
        BuilderTest$class.assertRejects((BuilderTest)this, q);
    }

    @Override
    public void assertRejects(Query q) {
        BuilderTest$class.assertRejects((BuilderTest)this, q);
    }

    @Override
    public void assertRejects(Pipe p, PartiallySolvedQuery q) {
        BuilderTest$class.assertRejects(this, p, q);
    }

    @Override
    public void assertRejects(ExecutionPlanInProgress planInProgress) {
        BuilderTest$class.assertRejects((BuilderTest)this, planInProgress);
    }

    @Override
    public PartiallySolvedQuery newQuery(Seq<StartItem> start, Seq<Predicate> where, Seq<UpdateAction> updates, Seq<Pattern> patterns2, Seq<ReturnColumn> returns, Option<PartiallySolvedQuery> tail) {
        return BuilderTest$class.newQuery(this, start, where, updates, patterns2, returns, tail);
    }

    @Override
    public Seq<String> createPipe$default$1() {
        return BuilderTest$class.createPipe$default$1(this);
    }

    @Override
    public Seq<String> createPipe$default$2() {
        return BuilderTest$class.createPipe$default$2(this);
    }

    @Override
    public Seq<StartItem> newQuery$default$1() {
        return BuilderTest$class.newQuery$default$1(this);
    }

    @Override
    public Seq<Predicate> newQuery$default$2() {
        return BuilderTest$class.newQuery$default$2(this);
    }

    @Override
    public Seq<UpdateAction> newQuery$default$3() {
        return BuilderTest$class.newQuery$default$3(this);
    }

    @Override
    public Seq<Pattern> newQuery$default$4() {
        return BuilderTest$class.newQuery$default$4(this);
    }

    @Override
    public Seq<ReturnColumn> newQuery$default$5() {
        return BuilderTest$class.newQuery$default$5(this);
    }

    @Override
    public Option<PartiallySolvedQuery> newQuery$default$6() {
        return BuilderTest$class.newQuery$default$6(this);
    }

    public StartPointBuilder builder() {
        return this.builder;
    }

    public StartPointBuilderTest() {
        BuilderTest$class.$init$(this);
        this.context_$eq((PlanContext)this.mock(ManifestFactory$.MODULE$.classType(PlanContext.class)));
        this.builder = new StartPointBuilder();
        this.test("says_yes_to_node_by_id_queries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PartiallySolvedQuery qual$1 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new NodeByIndexQuery("s", "idx", (Expression)new Literal((Object)"foo")))}));
                Seq x$6 = qual$1.copy$default$1();
                Seq x$7 = qual$1.copy$default$3();
                Seq x$8 = qual$1.copy$default$4();
                Seq x$9 = qual$1.copy$default$5();
                Seq x$10 = qual$1.copy$default$6();
                Seq x$11 = qual$1.copy$default$7();
                Option x$12 = qual$1.copy$default$8();
                Seq x$13 = qual$1.copy$default$9();
                boolean x$14 = qual$1.copy$default$10();
                boolean x$15 = qual$1.copy$default$11();
                boolean x$16 = qual$1.copy$default$12();
                Option x$17 = qual$1.copy$default$13();
                PartiallySolvedQuery q = qual$1.copy(x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plans index seek by prefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PrefixSeekRangeExpression range = new PrefixSeekRangeExpression(new PrefixRange((Object)new Literal((Object)"prefix")));
                String labelName2 = "Label";
                String propertyName = "prop";
                PartiallySolvedQuery qual$2 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$18 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new SchemaIndex("n", labelName2, propertyName, (SchemaIndexKind)AnyIndex$.MODULE$, (Option)new Some((Object)new RangeQueryExpression((Object)range))))}));
                Seq x$19 = qual$2.copy$default$1();
                Seq x$20 = qual$2.copy$default$3();
                Seq x$21 = qual$2.copy$default$4();
                Seq x$22 = qual$2.copy$default$5();
                Seq x$23 = qual$2.copy$default$6();
                Seq x$24 = qual$2.copy$default$7();
                Option x$25 = qual$2.copy$default$8();
                Seq x$26 = qual$2.copy$default$9();
                boolean x$27 = qual$2.copy$default$10();
                boolean x$28 = qual$2.copy$default$11();
                boolean x$29 = qual$2.copy$default$12();
                Option x$30 = qual$2.copy$default$13();
                PartiallySolvedQuery q = qual$2.copy(x$19, x$18, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30);
                Mockito.when((Object)this.$outer.context().getIndexRule(labelName2, propertyName)).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(123, 456)));
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plans unique index seek by prefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PrefixSeekRangeExpression range = new PrefixSeekRangeExpression(new PrefixRange((Object)new Literal((Object)"prefix")));
                String labelName2 = "Label";
                String propertyName = "prop";
                PartiallySolvedQuery qual$3 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$31 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new SchemaIndex("n", labelName2, propertyName, (SchemaIndexKind)UniqueIndex$.MODULE$, (Option)new Some((Object)new RangeQueryExpression((Object)range))))}));
                Seq x$32 = qual$3.copy$default$1();
                Seq x$33 = qual$3.copy$default$3();
                Seq x$34 = qual$3.copy$default$4();
                Seq x$35 = qual$3.copy$default$5();
                Seq x$36 = qual$3.copy$default$6();
                Seq x$37 = qual$3.copy$default$7();
                Option x$38 = qual$3.copy$default$8();
                Seq x$39 = qual$3.copy$default$9();
                boolean x$40 = qual$3.copy$default$10();
                boolean x$41 = qual$3.copy$default$11();
                boolean x$42 = qual$3.copy$default$12();
                Option x$43 = qual$3.copy$default$13();
                PartiallySolvedQuery q = qual$3.copy(x$32, x$31, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43);
                Mockito.when((Object)this.$outer.context().getUniqueIndexRule(labelName2, propertyName)).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(123, 456)));
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plans index seek for textual range query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InequalitySeekRangeExpression range = new InequalitySeekRangeExpression((InequalitySeekRange)new RangeLessThan(NonEmptyList$.MODULE$.apply((Object)new InclusiveBound((Object)new Literal((Object)"xxx")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InclusiveBound[0]))));
                String labelName2 = "Label";
                String propertyName = "prop";
                PartiallySolvedQuery qual$4 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$44 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new SchemaIndex("n", labelName2, propertyName, (SchemaIndexKind)AnyIndex$.MODULE$, (Option)new Some((Object)new RangeQueryExpression((Object)range))))}));
                Seq x$45 = qual$4.copy$default$1();
                Seq x$46 = qual$4.copy$default$3();
                Seq x$47 = qual$4.copy$default$4();
                Seq x$48 = qual$4.copy$default$5();
                Seq x$49 = qual$4.copy$default$6();
                Seq x$50 = qual$4.copy$default$7();
                Option x$51 = qual$4.copy$default$8();
                Seq x$52 = qual$4.copy$default$9();
                boolean x$53 = qual$4.copy$default$10();
                boolean x$54 = qual$4.copy$default$11();
                boolean x$55 = qual$4.copy$default$12();
                Option x$56 = qual$4.copy$default$13();
                PartiallySolvedQuery q = qual$4.copy(x$45, x$44, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56);
                Mockito.when((Object)this.$outer.context().getIndexRule(labelName2, propertyName)).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(123, 456)));
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plans index seek for textual range query with several ranges", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InequalitySeekRangeExpression range = new InequalitySeekRangeExpression((InequalitySeekRange)new RangeBetween(new RangeGreaterThan(NonEmptyList$.MODULE$.apply((Object)new InclusiveBound((Object)new Literal((Object)"xxx")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new ExclusiveBound((Object)new Literal((Object)"yyy"))}))), new RangeLessThan(NonEmptyList$.MODULE$.apply((Object)new ExclusiveBound((Object)new Literal((Object)"@@@")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExclusiveBound[0])))));
                String labelName2 = "Label";
                String propertyName = "prop";
                PartiallySolvedQuery qual$5 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$57 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new SchemaIndex("n", labelName2, propertyName, (SchemaIndexKind)AnyIndex$.MODULE$, (Option)new Some((Object)new RangeQueryExpression((Object)range))))}));
                Seq x$58 = qual$5.copy$default$1();
                Seq x$59 = qual$5.copy$default$3();
                Seq x$60 = qual$5.copy$default$4();
                Seq x$61 = qual$5.copy$default$5();
                Seq x$62 = qual$5.copy$default$6();
                Seq x$63 = qual$5.copy$default$7();
                Option x$64 = qual$5.copy$default$8();
                Seq x$65 = qual$5.copy$default$9();
                boolean x$66 = qual$5.copy$default$10();
                boolean x$67 = qual$5.copy$default$11();
                boolean x$68 = qual$5.copy$default$12();
                Option x$69 = qual$5.copy$default$13();
                PartiallySolvedQuery q = qual$5.copy(x$58, x$57, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69);
                Mockito.when((Object)this.$outer.context().getIndexRule(labelName2, propertyName)).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(123, 456)));
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plans index seek for numerical range query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InequalitySeekRangeExpression range = new InequalitySeekRangeExpression((InequalitySeekRange)new RangeGreaterThan(NonEmptyList$.MODULE$.apply((Object)new InclusiveBound((Object)new Literal((Object)BoxesRunTime.boxToInteger((int)42))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InclusiveBound[0]))));
                String labelName2 = "Label";
                String propertyName = "prop";
                PartiallySolvedQuery qual$6 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$70 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new SchemaIndex("n", labelName2, propertyName, (SchemaIndexKind)UniqueIndex$.MODULE$, (Option)new Some((Object)new RangeQueryExpression((Object)range))))}));
                Seq x$71 = qual$6.copy$default$1();
                Seq x$72 = qual$6.copy$default$3();
                Seq x$73 = qual$6.copy$default$4();
                Seq x$74 = qual$6.copy$default$5();
                Seq x$75 = qual$6.copy$default$6();
                Seq x$76 = qual$6.copy$default$7();
                Option x$77 = qual$6.copy$default$8();
                Seq x$78 = qual$6.copy$default$9();
                boolean x$79 = qual$6.copy$default$10();
                boolean x$80 = qual$6.copy$default$11();
                boolean x$81 = qual$6.copy$default$12();
                Option x$82 = qual$6.copy$default$13();
                PartiallySolvedQuery q = qual$6.copy(x$71, x$70, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$81, x$82);
                Mockito.when((Object)this.$outer.context().getUniqueIndexRule(labelName2, propertyName)).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(123, 456)));
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plans index seek for numerical range query with several ranges", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InequalitySeekRangeExpression range = new InequalitySeekRangeExpression((InequalitySeekRange)new RangeBetween(new RangeGreaterThan(NonEmptyList$.MODULE$.apply((Object)new InclusiveBound((Object)new Literal((Object)BoxesRunTime.boxToDouble((double)Double.NaN))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new ExclusiveBound((Object)new Literal((Object)BoxesRunTime.boxToDouble((double)25.5)))}))), new RangeLessThan(NonEmptyList$.MODULE$.apply((Object)new ExclusiveBound((Object)new Literal((Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExclusiveBound[0])))));
                String labelName2 = "Label";
                String propertyName = "prop";
                PartiallySolvedQuery qual$7 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$83 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new SchemaIndex("n", labelName2, propertyName, (SchemaIndexKind)UniqueIndex$.MODULE$, (Option)new Some((Object)new RangeQueryExpression((Object)range))))}));
                Seq x$84 = qual$7.copy$default$1();
                Seq x$85 = qual$7.copy$default$3();
                Seq x$86 = qual$7.copy$default$4();
                Seq x$87 = qual$7.copy$default$5();
                Seq x$88 = qual$7.copy$default$6();
                Seq x$89 = qual$7.copy$default$7();
                Option x$90 = qual$7.copy$default$8();
                Seq x$91 = qual$7.copy$default$9();
                boolean x$92 = qual$7.copy$default$10();
                boolean x$93 = qual$7.copy$default$11();
                boolean x$94 = qual$7.copy$default$12();
                Option x$95 = qual$7.copy$default$13();
                PartiallySolvedQuery q = qual$7.copy(x$84, x$83, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95);
                Mockito.when((Object)this.$outer.context().getUniqueIndexRule(labelName2, propertyName)).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(123, 456)));
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plans unique index seek for textual range query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InequalitySeekRangeExpression range = new InequalitySeekRangeExpression((InequalitySeekRange)new RangeLessThan(NonEmptyList$.MODULE$.apply((Object)new InclusiveBound((Object)new Literal((Object)"xxx")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InclusiveBound[0]))));
                String labelName2 = "Label";
                String propertyName = "prop";
                PartiallySolvedQuery qual$8 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$96 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new SchemaIndex("n", labelName2, propertyName, (SchemaIndexKind)UniqueIndex$.MODULE$, (Option)new Some((Object)new RangeQueryExpression((Object)range))))}));
                Seq x$97 = qual$8.copy$default$1();
                Seq x$98 = qual$8.copy$default$3();
                Seq x$99 = qual$8.copy$default$4();
                Seq x$100 = qual$8.copy$default$5();
                Seq x$101 = qual$8.copy$default$6();
                Seq x$102 = qual$8.copy$default$7();
                Option x$103 = qual$8.copy$default$8();
                Seq x$104 = qual$8.copy$default$9();
                boolean x$105 = qual$8.copy$default$10();
                boolean x$106 = qual$8.copy$default$11();
                boolean x$107 = qual$8.copy$default$12();
                Option x$108 = qual$8.copy$default$13();
                PartiallySolvedQuery q = qual$8.copy(x$97, x$96, x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108);
                Mockito.when((Object)this.$outer.context().getUniqueIndexRule(labelName2, propertyName)).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(123, 456)));
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plans unique index seek for numerical range query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InequalitySeekRangeExpression range = new InequalitySeekRangeExpression((InequalitySeekRange)new RangeGreaterThan(NonEmptyList$.MODULE$.apply((Object)new InclusiveBound((Object)new Literal((Object)BoxesRunTime.boxToInteger((int)42))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InclusiveBound[0]))));
                String labelName2 = "Label";
                String propertyName = "prop";
                PartiallySolvedQuery qual$9 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$109 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new SchemaIndex("n", labelName2, propertyName, (SchemaIndexKind)UniqueIndex$.MODULE$, (Option)new Some((Object)new RangeQueryExpression((Object)range))))}));
                Seq x$110 = qual$9.copy$default$1();
                Seq x$111 = qual$9.copy$default$3();
                Seq x$112 = qual$9.copy$default$4();
                Seq x$113 = qual$9.copy$default$5();
                Seq x$114 = qual$9.copy$default$6();
                Seq x$115 = qual$9.copy$default$7();
                Option x$116 = qual$9.copy$default$8();
                Seq x$117 = qual$9.copy$default$9();
                boolean x$118 = qual$9.copy$default$10();
                boolean x$119 = qual$9.copy$default$11();
                boolean x$120 = qual$9.copy$default$12();
                Option x$121 = qual$9.copy$default$13();
                PartiallySolvedQuery q = qual$9.copy(x$110, x$109, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121);
                Mockito.when((Object)this.$outer.context().getUniqueIndexRule(labelName2, propertyName)).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(123, 456)));
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("only_takes_one_start_item_at_the_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PartiallySolvedQuery qual$10 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$122 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new NodeByIndexQuery("s", "idx", (Expression)new Literal((Object)"foo"))), new Unsolved((Object)new NodeByIndexQuery("x", "idx", (Expression)new Literal((Object)"foo")))}));
                Seq x$123 = qual$10.copy$default$1();
                Seq x$124 = qual$10.copy$default$3();
                Seq x$125 = qual$10.copy$default$4();
                Seq x$126 = qual$10.copy$default$5();
                Seq x$127 = qual$10.copy$default$6();
                Seq x$128 = qual$10.copy$default$7();
                Option x$129 = qual$10.copy$default$8();
                Seq x$130 = qual$10.copy$default$9();
                boolean x$131 = qual$10.copy$default$10();
                boolean x$132 = qual$10.copy$default$11();
                boolean x$133 = qual$10.copy$default$12();
                Option x$134 = qual$10.copy$default$13();
                PartiallySolvedQuery q = qual$10.copy(x$123, x$122, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133, x$134);
                PartiallySolvedQuery remaining = this.$outer.assertAccepts(q).query();
                this.$outer.convertToAnyShouldWrapper(remaining.start().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(QueryToken<StartItem> x$1) {
                        return x$1.solved();
                    }
                })).should(this.$outer.have()).length(1L, Length$.MODULE$.lengthOfGenSeq());
                this.$outer.convertToAnyShouldWrapper(remaining.start().filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(QueryToken<StartItem> x$2) {
                        return x$2.solved();
                    }
                })).should(this.$outer.have()).length(1L, Length$.MODULE$.lengthOfGenSeq());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("fixes_node_by_id_and_keeps_the_rest_around", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PartiallySolvedQuery qual$11 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$135 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new NodeByIndexQuery("s", "idx", (Expression)new Literal((Object)"foo"))), new Unsolved((Object)RelationshipById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})))}));
                Seq x$136 = qual$11.copy$default$1();
                Seq x$137 = qual$11.copy$default$3();
                Seq x$138 = qual$11.copy$default$4();
                Seq x$139 = qual$11.copy$default$5();
                Seq x$140 = qual$11.copy$default$6();
                Seq x$141 = qual$11.copy$default$7();
                Option x$142 = qual$11.copy$default$8();
                Seq x$143 = qual$11.copy$default$9();
                boolean x$144 = qual$11.copy$default$10();
                boolean x$145 = qual$11.copy$default$11();
                boolean x$146 = qual$11.copy$default$12();
                Option x$147 = qual$11.copy$default$13();
                PartiallySolvedQuery q = qual$11.copy(x$136, x$135, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, x$145, x$146, x$147);
                PartiallySolvedQuery result = this.$outer.assertAccepts(q).query();
                Set expected = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QueryToken[]{new Solved((Object)new NodeByIndexQuery("s", "idx", (Expression)new Literal((Object)"foo"))), new Unsolved((Object)RelationshipById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})))}));
                this.$outer.convertToAnyShouldWrapper(result.start().toSet()).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("says_no_to_already_solved_node_by_id_queries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PartiallySolvedQuery qual$12 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$148 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Solved[]{new Solved((Object)new NodeByIndexQuery("s", "idx", (Expression)new Literal((Object)"foo")))}));
                Seq x$149 = qual$12.copy$default$1();
                Seq x$150 = qual$12.copy$default$3();
                Seq x$151 = qual$12.copy$default$4();
                Seq x$152 = qual$12.copy$default$5();
                Seq x$153 = qual$12.copy$default$6();
                Seq x$154 = qual$12.copy$default$7();
                Option x$155 = qual$12.copy$default$8();
                Seq x$156 = qual$12.copy$default$9();
                boolean x$157 = qual$12.copy$default$10();
                boolean x$158 = qual$12.copy$default$11();
                boolean x$159 = qual$12.copy$default$12();
                Option x$160 = qual$12.copy$default$13();
                PartiallySolvedQuery q = qual$12.copy(x$149, x$148, x$150, x$151, x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160);
                this.$outer.assertRejects(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("builds_a_nice_start_pipe", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PartiallySolvedQuery qual$13 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$161 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new NodeByIndexQuery("s", "idx", (Expression)new Literal((Object)"foo")))}));
                Seq x$162 = qual$13.copy$default$1();
                Seq x$163 = qual$13.copy$default$3();
                Seq x$164 = qual$13.copy$default$4();
                Seq x$165 = qual$13.copy$default$5();
                Seq x$166 = qual$13.copy$default$6();
                Seq x$167 = qual$13.copy$default$7();
                Option x$168 = qual$13.copy$default$8();
                Seq x$169 = qual$13.copy$default$9();
                boolean x$170 = qual$13.copy$default$10();
                boolean x$171 = qual$13.copy$default$11();
                boolean x$172 = qual$13.copy$default$12();
                Option x$173 = qual$13.copy$default$13();
                PartiallySolvedQuery q = qual$13.copy(x$162, x$161, x$163, x$164, x$165, x$166, x$167, x$168, x$169, x$170, x$171, x$172, x$173);
                PartiallySolvedQuery remainingQ = this.$outer.assertAccepts(q).query();
                this.$outer.convertToAnyShouldWrapper(remainingQ.start()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Solved[]{new Solved((Object)new NodeByIndexQuery("s", "idx", (Expression)new Literal((Object)"foo")))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("does_not_offer_to_solve_empty_queries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRejects(PartiallySolvedQuery$.MODULE$.apply());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("offers_to_solve_query_with_index_hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                KeyToken.Unresolved propertyKey = TokenType.PropertyKey$.MODULE$.apply("name");
                String labelName2 = "Person";
                PartiallySolvedQuery qual$14 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$174 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)propertyKey), (Expression)new Literal((Object)"Stefan")))}));
                Seq x$175 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new SchemaIndex("n", labelName2, propertyKey.name(), (SchemaIndexKind)AnyIndex$.MODULE$, (Option)new Some((Object)new SingleQueryExpression((Object)new Literal((Object)"a")))))}));
                Seq x$176 = qual$14.copy$default$1();
                Seq x$177 = qual$14.copy$default$3();
                Seq x$178 = qual$14.copy$default$4();
                Seq x$179 = qual$14.copy$default$6();
                Seq x$180 = qual$14.copy$default$7();
                Option x$181 = qual$14.copy$default$8();
                Seq x$182 = qual$14.copy$default$9();
                boolean x$183 = qual$14.copy$default$10();
                boolean x$184 = qual$14.copy$default$11();
                boolean x$185 = qual$14.copy$default$12();
                Option x$186 = qual$14.copy$default$13();
                PartiallySolvedQuery q = qual$14.copy(x$176, x$175, x$177, x$178, x$174, x$179, x$180, x$181, x$182, x$183, x$184, x$185, x$186);
                Mockito.when((Object)this.$outer.context().getIndexRule(labelName2, propertyKey.name())).thenReturn((Object)new Some((Object)new SchemaTypes.IndexDescriptor(123, 456)));
                ExecutionPlanInProgress producedPlan = this.$outer.assertAccepts(q);
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(producedPlan.pipe()).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(NodeStartPipe.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("throws_exception_if_no_index_is_found", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                KeyToken.Unresolved propertyKey = TokenType.PropertyKey$.MODULE$.apply("name");
                PartiallySolvedQuery qual$15 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$187 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)propertyKey), (Expression)new Literal((Object)"Stefan")))}));
                Seq x$188 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new SchemaIndex("n", "Person", "name", (SchemaIndexKind)AnyIndex$.MODULE$, (Option)None$.MODULE$))}));
                Seq x$189 = qual$15.copy$default$1();
                Seq x$190 = qual$15.copy$default$3();
                Seq x$191 = qual$15.copy$default$4();
                Seq x$192 = qual$15.copy$default$6();
                Seq x$193 = qual$15.copy$default$7();
                Option x$194 = qual$15.copy$default$8();
                Seq x$195 = qual$15.copy$default$9();
                boolean x$196 = qual$15.copy$default$10();
                boolean x$197 = qual$15.copy$default$11();
                boolean x$198 = qual$15.copy$default$12();
                Option x$199 = qual$15.copy$default$13();
                PartiallySolvedQuery q = qual$15.copy(x$189, x$188, x$190, x$191, x$187, x$192, x$193, x$194, x$195, x$196, x$197, x$198, x$199);
                Mockito.when((Object)this.$outer.context().getIndexRule((String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)None$.MODULE$);
                this.$outer.intercept((Function0)new Serializable(this, q){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;
                    private final PartiallySolvedQuery q$1;

                    public final ExecutionPlanInProgress apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$executionplan$builders$StartPointBuilderTest$$anonfun$$$outer().assertAccepts(this.q$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.q$1 = q$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IndexHintException.class));
            }

            public /* synthetic */ StartPointBuilderTest org$neo4j$cypher$internal$compiler$v2_3$executionplan$builders$StartPointBuilderTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("says_yes_to_global_queries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PartiallySolvedQuery qual$16 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$200 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new AllNodes("s"))}));
                Seq x$201 = qual$16.copy$default$1();
                Seq x$202 = qual$16.copy$default$3();
                Seq x$203 = qual$16.copy$default$4();
                Seq x$204 = qual$16.copy$default$5();
                Seq x$205 = qual$16.copy$default$6();
                Seq x$206 = qual$16.copy$default$7();
                Option x$207 = qual$16.copy$default$8();
                Seq x$208 = qual$16.copy$default$9();
                boolean x$209 = qual$16.copy$default$10();
                boolean x$210 = qual$16.copy$default$11();
                boolean x$211 = qual$16.copy$default$12();
                Option x$212 = qual$16.copy$default$13();
                PartiallySolvedQuery q = qual$16.copy(x$201, x$200, x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210, x$211, x$212);
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("says_yes_to_global_rel_queries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PartiallySolvedQuery qual$17 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$213 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new AllRelationships("s"))}));
                Seq x$214 = qual$17.copy$default$1();
                Seq x$215 = qual$17.copy$default$3();
                Seq x$216 = qual$17.copy$default$4();
                Seq x$217 = qual$17.copy$default$5();
                Seq x$218 = qual$17.copy$default$6();
                Seq x$219 = qual$17.copy$default$7();
                Option x$220 = qual$17.copy$default$8();
                Seq x$221 = qual$17.copy$default$9();
                boolean x$222 = qual$17.copy$default$10();
                boolean x$223 = qual$17.copy$default$11();
                boolean x$224 = qual$17.copy$default$12();
                Option x$225 = qual$17.copy$default$13();
                PartiallySolvedQuery q = qual$17.copy(x$214, x$213, x$215, x$216, x$217, x$218, x$219, x$220, x$221, x$222, x$223, x$224, x$225);
                this.$outer.assertAccepts(q);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("only_takes_one_global_start_item_at_the_time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StartPointBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PartiallySolvedQuery qual$18 = PartiallySolvedQuery$.MODULE$.apply();
                Seq x$226 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Unsolved[]{new Unsolved((Object)new AllNodes("s")), new Unsolved((Object)new AllNodes("x"))}));
                Seq x$227 = qual$18.copy$default$1();
                Seq x$228 = qual$18.copy$default$3();
                Seq x$229 = qual$18.copy$default$4();
                Seq x$230 = qual$18.copy$default$5();
                Seq x$231 = qual$18.copy$default$6();
                Seq x$232 = qual$18.copy$default$7();
                Option x$233 = qual$18.copy$default$8();
                Seq x$234 = qual$18.copy$default$9();
                boolean x$235 = qual$18.copy$default$10();
                boolean x$236 = qual$18.copy$default$11();
                boolean x$237 = qual$18.copy$default$12();
                Option x$238 = qual$18.copy$default$13();
                PartiallySolvedQuery q = qual$18.copy(x$227, x$226, x$228, x$229, x$230, x$231, x$232, x$233, x$234, x$235, x$236, x$237, x$238);
                PartiallySolvedQuery remaining = this.$outer.assertAccepts(q).query();
                this.$outer.convertToAnyShouldWrapper(remaining.start().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(QueryToken<StartItem> x$3) {
                        return x$3.solved();
                    }
                })).should(this.$outer.have()).length(1L, Length$.MODULE$.lengthOfGenSeq());
                this.$outer.convertToAnyShouldWrapper(remaining.start().filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(QueryToken<StartItem> x$4) {
                        return x$4.solved();
                    }
                })).should(this.$outer.have()).length(1L, Length$.MODULE$.lengthOfGenSeq());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

