/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.pipes;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_3.PrefixRange;
import org.neo4j.cypher.internal.compiler.v2_3.commands.ManyQueryExpression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.QueryExpression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.RangeQueryExpression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.SingleQueryExpression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Collection;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.PrefixSeekRangeExpression;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.ExternalResource;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.IndexSeek$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.IndexSeekByRange$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.IndexSeekMode;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.LockingUniqueIndexSeek$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.NodeIndexSeekPipe;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.NodeIndexSeekPipe$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.PipeDecorator;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.UniqueIndexSeek$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.UniqueIndexSeekByRange$;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.PlanDescriptionImpl;
import org.neo4j.cypher.internal.compiler.v2_3.spi.QueryContext;
import org.neo4j.cypher.internal.compiler.v2_3.spi.SchemaTypes;
import org.neo4j.cypher.internal.frontend.v2_3.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v2_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v2_3.InternalException;
import org.neo4j.cypher.internal.frontend.v2_3.LabelId;
import org.neo4j.cypher.internal.frontend.v2_3.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v2_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v2_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Identifier;
import org.neo4j.cypher.internal.frontend.v2_3.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v2_3.ast.LabelToken;
import org.neo4j.cypher.internal.frontend.v2_3.ast.LabelToken$;
import org.neo4j.cypher.internal.frontend.v2_3.ast.PropertyKeyName;
import org.neo4j.cypher.internal.frontend.v2_3.ast.PropertyKeyToken;
import org.neo4j.cypher.internal.frontend.v2_3.ast.PropertyKeyToken$;
import org.neo4j.cypher.internal.frontend.v2_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Node;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001E\u0011QCT8eK&sG-\u001a=TK\u0016\\\u0007+\u001b9f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)\u0001/\u001b9fg*\u0011QAB\u0001\u0005mJz6G\u0003\u0002\b\u0011\u0005A1m\\7qS2,'O\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u001c!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0006/)\u0011\u0001\u0004C\u0001\tMJ|g\u000e^3oI&\u0011!\u0004\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f!\tar$D\u0001\u001e\u0015\tqb#A\u0002bgRL!\u0001I\u000f\u00035\u0005\u001bHoQ8ogR\u0014Xo\u0019;j_:$Vm\u001d;TkB\u0004xN\u001d;\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u0005\u0011\u0001bB\u0014\u0001\u0005\u0004%\u0019\u0001K\u0001\b[>t\u0017\u000e^8s+\u0005I\u0003CA\u0013+\u0013\tY#AA\u0006QSB,Wj\u001c8ji>\u0014\bBB\u0017\u0001A\u0003%\u0011&\u0001\u0005n_:LGo\u001c:!\u0011\u001dy\u0003A1A\u0005\u0002A\nQ\u0001\\1cK2,\u0012!\r\t\u00039IJ!aM\u000f\u0003\u00151\u000b'-\u001a7U_.,g\u000e\u0003\u00046\u0001\u0001\u0006I!M\u0001\u0007Y\u0006\u0014W\r\u001c\u0011\t\u000f]\u0002!\u0019!C\u0001q\u0005Y\u0001O]8qKJ$\u0018pS3z+\u0005I\u0004C\u0001\u000f;\u0013\tYTD\u0001\tQe>\u0004XM\u001d;z\u0017\u0016LHk\\6f]\"1Q\b\u0001Q\u0001\ne\nA\u0002\u001d:pa\u0016\u0014H/_&fs\u0002Bqa\u0010\u0001C\u0002\u0013\u0005\u0001)\u0001\u0006eKN\u001c'/\u001b9u_J,\u0012!\u0011\t\u0003\u0005bs!aQ+\u000f\u0005\u0011\u001bfBA#S\u001d\t1\u0015K\u0004\u0002H!:\u0011\u0001j\u0014\b\u0003\u0013:s!AS'\u000e\u0003-S!\u0001\u0014\t\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011BA\u0007\u000f\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!\u0001\u0016\u0003\u0002\u0007M\u0004\u0018.\u0003\u0002W/\u0006Y1k\u00195f[\u0006$\u0016\u0010]3t\u0015\t!F!\u0003\u0002Z5\ny\u0011J\u001c3fq\u0012+7o\u0019:jaR|'O\u0003\u0002W/\"1A\f\u0001Q\u0001\n\u0005\u000b1\u0002Z3tGJL\u0007\u000f^8sA!9a\f\u0001b\u0001\n\u0003y\u0016\u0001\u00028pI\u0016,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G2\tqa\u001a:ba\"$'-\u0003\u0002fE\n!aj\u001c3f\u0011\u00199\u0007\u0001)A\u0005A\u0006)an\u001c3fA!9\u0011\u000e\u0001b\u0001\n\u0003y\u0016!\u00028pI\u0016\u0014\u0004BB6\u0001A\u0003%\u0001-\u0001\u0004o_\u0012,'\u0007\t\u0005\u0006[\u0002!IA\\\u0001\tS:$W\r\u001f$peR\u0011qn\u001d\t\u0003aFl\u0011aV\u0005\u0003e^\u0013A\"U;fef\u001cuN\u001c;fqRDQ\u0001\u001e7A\u0002U\faA^1mk\u0016\u001c\bc\u0001<zw6\tqOC\u0001y\u0003\u0015\u00198-\u00197b\u0013\tQxO\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002RA\u001e?\u007f\u0003\u0007I!!`<\u0003\rQ+\b\u000f\\33!\t1x0C\u0002\u0002\u0002]\u00141!\u00118z!\u0015\t)!a\u0004a\u001d\u0011\t9!a\u0003\u000f\u0007)\u000bI!C\u0001y\u0013\r\tia^\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t\"a\u0005\u0003\u0011%#XM]1u_JT1!!\u0004x\u0001")
public class NodeIndexSeekPipeTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final PipeMonitor monitor;
    private final LabelToken label;
    private final PropertyKeyToken propertyKey;
    private final SchemaTypes.IndexDescriptor descriptor;
    private final Node node;
    private final Node node2;
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v2_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Identifier ident(String name) {
        return AstConstructionTestSupport.class.ident((AstConstructionTestSupport)this, (String)name);
    }

    public HasLabels hasLabels(String identifier, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)identifier, (String)label);
    }

    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)identifier, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public PipeMonitor monitor() {
        return this.monitor;
    }

    public LabelToken label() {
        return this.label;
    }

    public PropertyKeyToken propertyKey() {
        return this.propertyKey;
    }

    public SchemaTypes.IndexDescriptor descriptor() {
        return this.descriptor;
    }

    public Node node() {
        return this.node;
    }

    public Node node2() {
        return this.node2;
    }

    /*
     * WARNING - void declaration
     */
    public QueryContext org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor(Seq<Tuple2<Object, Iterator<Node>>> values) {
        void var2_2;
        QueryContext query2 = (QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
        Mockito.when((Object)query2.indexSeek((SchemaTypes.IndexDescriptor)Matchers.any(), Matchers.any())).thenReturn((Object)package$.MODULE$.Iterator().empty());
        values.foreach((Function1)new Serializable(this, query2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;
            private final QueryContext query$1;

            public final OngoingStubbing<Iterator<Node>> apply(Tuple2<Object, Iterator<Node>> x0$1) {
                Tuple2<Object, Iterator<Node>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Object searchTerm = tuple2._1();
                    Iterator result = (Iterator)tuple2._2();
                    OngoingStubbing ongoingStubbing = Mockito.when((Object)this.query$1.indexSeek(this.$outer.descriptor(), searchTerm)).thenReturn((Object)result);
                    return ongoingStubbing;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        });
        return var2_2;
    }

    public NodeIndexSeekPipeTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.monitor = (PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class));
        this.label = LabelToken$.MODULE$.apply((LabelName)this.withPos((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabelName apply(InputPosition position) {
                return new LabelName("LabelName", position);
            }
        }), new LabelId(11));
        this.propertyKey = PropertyKeyToken$.MODULE$.apply((PropertyKeyName)this.withPos((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final PropertyKeyName apply(InputPosition position) {
                return new PropertyKeyName("PropertyName", position);
            }
        }), new PropertyKeyId(10));
        this.descriptor = new SchemaTypes.IndexDescriptor(this.label().nameId().id(), this.propertyKey().nameId().id());
        this.node = (Node)this.mock(ManifestFactory$.MODULE$.classType(Node.class));
        this.node2 = (Node)this.mock(ManifestFactory$.MODULE$.classType(Node.class));
        this.test("should produce the correct plan description for equality seeks", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String x$11 = "a";
                LabelToken x$12 = this.$outer.label();
                PropertyKeyToken x$13 = this.$outer.propertyKey();
                SingleQueryExpression x$14 = new SingleQueryExpression((Object)new Literal((Object)"hello"));
                LockingUniqueIndexSeek$ x$15 = LockingUniqueIndexSeek$.MODULE$;
                Option x$16 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$11, x$12, x$13, (QueryExpression)x$14, (IndexSeekMode)x$15);
                NodeIndexSeekPipe uniquePipe = new NodeIndexSeekPipe(x$11, x$12, x$13, (QueryExpression)x$14, (IndexSeekMode)x$15, x$16, this.$outer.monitor());
                String x$17 = "a";
                LabelToken x$18 = this.$outer.label();
                PropertyKeyToken x$19 = this.$outer.propertyKey();
                SingleQueryExpression x$20 = new SingleQueryExpression((Object)new Literal((Object)"hello"));
                IndexSeek$ x$21 = IndexSeek$.MODULE$;
                Option x$22 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$17, x$18, x$19, (QueryExpression)x$20, (IndexSeekMode)x$21);
                NodeIndexSeekPipe nonUniquePipe = new NodeIndexSeekPipe(x$17, x$18, x$19, (QueryExpression)x$20, (IndexSeekMode)x$21, x$22, this.$outer.monitor());
                String uniquePlan = uniquePipe.planDescriptionWithoutCardinality().toString();
                this.$outer.convertToStringShouldWrapper(uniquePlan).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------------------+-------------+--------------------------+\n                              || Operator             | Identifiers | Other                    |\n                              |+----------------------+-------------+--------------------------+\n                              || +NodeUniqueIndexSeek | a           | :LabelName(PropertyName) |\n                              |+----------------------+-------------+--------------------------+\n                              |\n                              |Total database accesses: ?\n                              |")).stripMargin()), (Object)Equality$.MODULE$.default());
                String nonUniquePlan = nonUniquePipe.planDescriptionWithoutCardinality().toString();
                this.$outer.convertToStringShouldWrapper(nonUniquePlan).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------------+-------------+--------------------------+\n                                 || Operator       | Identifiers | Other                    |\n                                 |+----------------+-------------+--------------------------+\n                                 || +NodeIndexSeek | a           | :LabelName(PropertyName) |\n                                 |+----------------+-------------+--------------------------+\n                                 |\n                                 |Total database accesses: ?\n                                 |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should produce the correct plan description for unique range seek based on query expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PrefixSeekRangeExpression expression = new PrefixSeekRangeExpression(new PrefixRange((Object)new Literal((Object)"prefix")));
                RangeQueryExpression queryExpression = new RangeQueryExpression((Object)expression);
                String x$23 = "a";
                LabelToken x$24 = this.$outer.label();
                PropertyKeyToken x$25 = this.$outer.propertyKey();
                RangeQueryExpression x$26 = queryExpression;
                UniqueIndexSeekByRange$ x$27 = UniqueIndexSeekByRange$.MODULE$;
                Option x$28 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$23, x$24, x$25, (QueryExpression)x$26, (IndexSeekMode)x$27);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$23, x$24, x$25, (QueryExpression)x$26, (IndexSeekMode)x$27, x$28, this.$outer.monitor());
                this.$outer.convertToStringShouldWrapper(pipe.planDescriptionWithoutCardinality().toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------------------+-------------+------------------------------------------------------+\n        || Operator                    | Identifiers | Other                                                |\n        |+-----------------------------+-------------+------------------------------------------------------+\n        || +NodeUniqueIndexSeekByRange | a           | :LabelName(PropertyName STARTS WITH Literal(prefix)) |\n        |+-----------------------------+-------------+------------------------------------------------------+\n        |\n        |Total database accesses: ?\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
                String x$29 = "a";
                LabelToken x$30 = this.$outer.label();
                PropertyKeyToken x$31 = this.$outer.propertyKey();
                SingleQueryExpression x$32 = new SingleQueryExpression((Object)new Literal((Object)"hello"));
                UniqueIndexSeekByRange$ x$33 = UniqueIndexSeekByRange$.MODULE$;
                Option x$34 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$29, x$30, x$31, (QueryExpression)x$32, (IndexSeekMode)x$33);
                NodeIndexSeekPipe illegalPipe = new NodeIndexSeekPipe(x$29, x$30, x$31, (QueryExpression)x$32, (IndexSeekMode)x$33, x$34, this.$outer.monitor());
                this.$outer.a(ManifestFactory$.MODULE$.classType(InternalException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this, illegalPipe){
                    public static final long serialVersionUID = 0L;
                    private final NodeIndexSeekPipe illegalPipe$1;

                    public final PlanDescriptionImpl apply() {
                        return this.illegalPipe$1.planDescriptionWithoutCardinality();
                    }
                    {
                        this.illegalPipe$1 = illegalPipe$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should produce the correct plan description for nonunique range seek based on query expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PrefixSeekRangeExpression expression = new PrefixSeekRangeExpression(new PrefixRange((Object)new Literal((Object)"prefix")));
                RangeQueryExpression queryExpression = new RangeQueryExpression((Object)expression);
                String x$35 = "a";
                LabelToken x$36 = this.$outer.label();
                PropertyKeyToken x$37 = this.$outer.propertyKey();
                RangeQueryExpression x$38 = queryExpression;
                IndexSeekByRange$ x$39 = IndexSeekByRange$.MODULE$;
                Option x$40 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$35, x$36, x$37, (QueryExpression)x$38, (IndexSeekMode)x$39);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$35, x$36, x$37, (QueryExpression)x$38, (IndexSeekMode)x$39, x$40, this.$outer.monitor());
                this.$outer.convertToStringShouldWrapper(pipe.planDescriptionWithoutCardinality().toString()).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------------+-------------+------------------------------------------------------+\n        || Operator              | Identifiers | Other                                                |\n        |+-----------------------+-------------+------------------------------------------------------+\n        || +NodeIndexSeekByRange | a           | :LabelName(PropertyName STARTS WITH Literal(prefix)) |\n        |+-----------------------+-------------+------------------------------------------------------+\n        |\n        |Total database accesses: ?\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
                String x$41 = "a";
                LabelToken x$42 = this.$outer.label();
                PropertyKeyToken x$43 = this.$outer.propertyKey();
                ManyQueryExpression x$44 = new ManyQueryExpression((Object)new Literal((Object)"hello"));
                IndexSeekByRange$ x$45 = IndexSeekByRange$.MODULE$;
                Option x$46 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$41, x$42, x$43, (QueryExpression)x$44, (IndexSeekMode)x$45);
                NodeIndexSeekPipe illegalPipe = new NodeIndexSeekPipe(x$41, x$42, x$43, (QueryExpression)x$44, (IndexSeekMode)x$45, x$46, this.$outer.monitor());
                this.$outer.a(ManifestFactory$.MODULE$.classType(InternalException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this, illegalPipe){
                    public static final long serialVersionUID = 0L;
                    private final NodeIndexSeekPipe illegalPipe$2;

                    public final PlanDescriptionImpl apply() {
                        return this.illegalPipe$2.planDescriptionWithoutCardinality();
                    }
                    {
                        this.illegalPipe$2 = illegalPipe$2;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return nodes found by index lookup when both labelId and property key id are solved at compile time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor((Seq<Tuple2<Object, Iterator<Node>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()})))})), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                String x$47 = "n";
                LabelToken x$48 = this.$outer.label();
                PropertyKeyToken x$49 = this.$outer.propertyKey();
                SingleQueryExpression x$50 = new SingleQueryExpression((Object)new Literal((Object)"hello"));
                IndexSeekMode x$51 = NodeIndexSeekPipe$.MODULE$.apply$default$5();
                Option x$52 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$47, x$48, x$49, (QueryExpression)x$50, x$51);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$47, x$48, x$49, (QueryExpression)x$50, x$51, x$52, this.$outer.monitor());
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$1) {
                        return x$1.apply((Object)"n");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle index lookups for multiple values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor((Seq<Tuple2<Object, Iterator<Node>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"world"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node2()})))})), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                String x$53 = "n";
                LabelToken x$54 = this.$outer.label();
                PropertyKeyToken x$55 = this.$outer.propertyKey();
                ManyQueryExpression x$56 = new ManyQueryExpression((Object)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"hello"), new Literal((Object)"world")})));
                IndexSeekMode x$57 = NodeIndexSeekPipe$.MODULE$.apply$default$5();
                Option x$58 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$53, x$54, x$55, (QueryExpression)x$56, x$57);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$53, x$54, x$55, (QueryExpression)x$56, x$57, x$58, this.$outer.monitor());
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$2) {
                        return x$2.apply((Object)"n");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node(), this.$outer.node2()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle unique index lookups for multiple values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor((Seq<Tuple2<Object, Iterator<Node>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"world"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node2()})))})), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                String x$59 = "n";
                LabelToken x$60 = this.$outer.label();
                PropertyKeyToken x$61 = this.$outer.propertyKey();
                ManyQueryExpression x$62 = new ManyQueryExpression((Object)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"hello"), new Literal((Object)"world")})));
                UniqueIndexSeek$ x$63 = UniqueIndexSeek$.MODULE$;
                Option x$64 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$59, x$60, x$61, (QueryExpression)x$62, (IndexSeekMode)x$63);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$59, x$60, x$61, (QueryExpression)x$62, (IndexSeekMode)x$63, x$64, this.$outer.monitor());
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$3) {
                        return x$3.apply((Object)"n");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node(), this.$outer.node2()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle index lookups for multiple values when some are null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor((Seq<Tuple2<Object, Iterator<Node>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()})))})), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                String x$65 = "n";
                LabelToken x$66 = this.$outer.label();
                PropertyKeyToken x$67 = this.$outer.propertyKey();
                ManyQueryExpression x$68 = new ManyQueryExpression((Object)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"hello"), new Literal(null)})));
                IndexSeekMode x$69 = NodeIndexSeekPipe$.MODULE$.apply$default$5();
                Option x$70 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$65, x$66, x$67, (QueryExpression)x$68, x$69);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$65, x$66, x$67, (QueryExpression)x$68, x$69, x$70, this.$outer.monitor());
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$4) {
                        return x$4.apply((Object)"n");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle unique index lookups for multiple values when some are null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor((Seq<Tuple2<Object, Iterator<Node>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()})))})), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                String x$71 = "n";
                LabelToken x$72 = this.$outer.label();
                PropertyKeyToken x$73 = this.$outer.propertyKey();
                ManyQueryExpression x$74 = new ManyQueryExpression((Object)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"hello"), new Literal(null)})));
                UniqueIndexSeek$ x$75 = UniqueIndexSeek$.MODULE$;
                Option x$76 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$71, x$72, x$73, (QueryExpression)x$74, (IndexSeekMode)x$75);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$71, x$72, x$73, (QueryExpression)x$74, (IndexSeekMode)x$75, x$76, this.$outer.monitor());
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$5) {
                        return x$5.apply((Object)"n");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle index lookups for IN an empty collection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor((Seq<Tuple2<Object, Iterator<Node>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()})))})), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                String x$77 = "n";
                LabelToken x$78 = this.$outer.label();
                PropertyKeyToken x$79 = this.$outer.propertyKey();
                ManyQueryExpression x$80 = new ManyQueryExpression((Object)new Collection((Seq)Nil$.MODULE$));
                IndexSeekMode x$81 = NodeIndexSeekPipe$.MODULE$.apply$default$5();
                Option x$82 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$77, x$78, x$79, (QueryExpression)x$80, x$81);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$77, x$78, x$79, (QueryExpression)x$80, x$81, x$82, this.$outer.monitor());
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$6) {
                        return x$6.apply((Object)"n");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle index lookups for IN a collection with duplicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor((Seq<Tuple2<Object, Iterator<Node>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()})))})), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                String x$83 = "n";
                LabelToken x$84 = this.$outer.label();
                PropertyKeyToken x$85 = this.$outer.propertyKey();
                ManyQueryExpression x$86 = new ManyQueryExpression((Object)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"hello"), new Literal((Object)"hello")})));
                IndexSeekMode x$87 = NodeIndexSeekPipe$.MODULE$.apply$default$5();
                Option x$88 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$83, x$84, x$85, (QueryExpression)x$86, x$87);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$83, x$84, x$85, (QueryExpression)x$86, x$87, x$88, this.$outer.monitor());
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$7) {
                        return x$7.apply((Object)"n");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle index lookups for IN a collection that returns the same nodes for multiple values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor((Seq<Tuple2<Object, Iterator<Node>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"world"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()})))})), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                String x$89 = "n";
                LabelToken x$90 = this.$outer.label();
                PropertyKeyToken x$91 = this.$outer.propertyKey();
                ManyQueryExpression x$92 = new ManyQueryExpression((Object)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"hello"), new Literal((Object)"world")})));
                IndexSeekMode x$93 = NodeIndexSeekPipe$.MODULE$.apply$default$5();
                Option x$94 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$89, x$90, x$91, (QueryExpression)x$92, x$93);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$89, x$90, x$91, (QueryExpression)x$92, x$93, x$94, this.$outer.monitor());
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$8) {
                        return x$8.apply((Object)"n");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node(), this.$outer.node()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should give a helpful error message", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                String x$95 = "n";
                LabelToken x$96 = this.$outer.label();
                PropertyKeyToken x$97 = this.$outer.propertyKey();
                ManyQueryExpression x$98 = new ManyQueryExpression((Object)new Literal((Object)"wut?"));
                IndexSeekMode x$99 = NodeIndexSeekPipe$.MODULE$.apply$default$5();
                Option x$100 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$95, x$96, x$97, (QueryExpression)x$98, x$99);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$95, x$96, x$97, (QueryExpression)x$98, x$99, x$100, this.$outer.monitor());
                this.$outer.intercept((Function0)new Serializable(this, queryState, pipe){
                    public static final long serialVersionUID = 0L;
                    private final QueryState queryState$1;
                    private final NodeIndexSeekPipe pipe$1;

                    public final Iterator<ExecutionContext> apply() {
                        return this.pipe$1.createResults(this.queryState$1);
                    }
                    {
                        this.queryState$1 = queryState$1;
                        this.pipe$1 = pipe$1;
                    }
                }, ManifestFactory$.MODULE$.classType(CypherTypeException.class));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return the node found by the unique index lookup when both labelId and property key id are solved at compile time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor((Seq<Tuple2<Object, Iterator<Node>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()})))})), QueryStateHelper$.MODULE$.emptyWith$default$2(), QueryStateHelper$.MODULE$.emptyWith$default$3(), QueryStateHelper$.MODULE$.emptyWith$default$4(), QueryStateHelper$.MODULE$.emptyWith$default$5());
                String x$101 = "n";
                LabelToken x$102 = this.$outer.label();
                PropertyKeyToken x$103 = this.$outer.propertyKey();
                SingleQueryExpression x$104 = new SingleQueryExpression((Object)new Literal((Object)"hello"));
                UniqueIndexSeek$ x$105 = UniqueIndexSeek$.MODULE$;
                Option x$106 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$101, x$102, x$103, (QueryExpression)x$104, (IndexSeekMode)x$105);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$101, x$102, x$103, (QueryExpression)x$104, (IndexSeekMode)x$105, x$106, this.$outer.monitor());
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$9) {
                        return x$9.apply((Object)"n");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should use existing values from arguments when available", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeIndexSeekPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryContext x$107 = this.$outer.org$neo4j$cypher$internal$compiler$v2_3$pipes$NodeIndexSeekPipeTest$$indexFor((Seq<Tuple2<Object, Iterator<Node>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()})))}));
                Some x$108 = new Some((Object)ExecutionContext$.MODULE$.from((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)"hello")})));
                ExternalResource x$109 = QueryStateHelper$.MODULE$.emptyWith$default$2();
                Map<String, Object> x$110 = QueryStateHelper$.MODULE$.emptyWith$default$3();
                PipeDecorator x$111 = QueryStateHelper$.MODULE$.emptyWith$default$4();
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(x$107, x$109, x$110, x$111, (Option<ExecutionContext>)x$108);
                String x$112 = "n";
                LabelToken x$113 = this.$outer.label();
                PropertyKeyToken x$114 = this.$outer.propertyKey();
                SingleQueryExpression x$115 = new SingleQueryExpression((Object)new org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Identifier("x"));
                IndexSeekMode x$116 = NodeIndexSeekPipe$.MODULE$.apply$default$5();
                Option x$117 = NodeIndexSeekPipe$.MODULE$.apply$default$6(x$112, x$113, x$114, (QueryExpression)x$115, x$116);
                NodeIndexSeekPipe pipe = new NodeIndexSeekPipe(x$112, x$113, x$114, (QueryExpression)x$115, x$116, x$117, this.$outer.monitor());
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$10) {
                        return x$10.apply((Object)"n");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.$outer.node()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

